/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.matcher;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetMultipleSegmentComparator;
import com.mapinfo.mapmarker.core.matcher.ICoreMatcher;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.IMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CoreMatcherHandler
implements IMatcherHandler {
    public static final String removeMultipleSegments = "MATCHER_REMOVE_MULTIPLE_SEGMENTS";
    private double m_maximumAddressScore;
    private double m_maximumAdditionalFieldScore;

    @Override
    public double getMaximumAddressScore() {
        return this.m_maximumAddressScore;
    }

    @Override
    public double getMaximumAdditionalFieldScore() {
        return this.m_maximumAdditionalFieldScore;
    }

    @Override
    public void setMaximumAddressScore(double value) {
        this.m_maximumAddressScore = value;
    }

    @Override
    public void setMaximumAdditionalFieldScore(double value) {
        this.m_maximumAdditionalFieldScore = value;
    }

    @Override
    public void decideCloseMatch(IMatchPreferences preferences, InternalCandidateAddress candidate, InternalMatcherConstants constants, ScoringAddress scoringAddress) throws MatcherException {
        if (preferences.getExactMatchPostalCode1() && candidate.getPostCode1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchPostalCode2() && candidate.getPostCode2Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchStreetNameFields() && (candidate.getMainAddressScore() != 1.0 || candidate.getPostAddressScore() != 1.0 || candidate.getPreAddressScore() != 1.0 || candidate.getPreThoroughfareTypeScore() != 1.0 || candidate.getPostThoroughfareTypeScore() != 1.0 || candidate.getPreDirectionalScore() != 1.0 || candidate.getPostDirectionalScore() != 1.0)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAddressNumber() && candidate.getAddressNumberScore() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName1() && candidate.getAreaName1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName2() && candidate.getAreaName2Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName3() && candidate.getAreaName3Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName4() && candidate.getAreaName4Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getCombinedAddressScore() < constants.getCloseMatchCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getCombinedAdditionalFieldScore() < constants.getAdditionalFieldsCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        candidate.setCloseMatchFlag(true);
    }

    @Override
    public void scoreCandidate(InternalCandidateAddress candidate, ScoringAddress scoringAddress, InternalMatcherConstants constants) {
        double score = 0.0;
        double typeDelta = 0.0;
        candidate.computeScores(scoringAddress, constants.getCharsToIgnore());
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        score = scoringAddress.getParsedAddressNumber() != null ? (score += candidate.getAddressNumberScore() * matchedConstants.getAddressNumber()) : (score += candidate.getAddressNumberScore() * blankConstants.getAddressNumber());
        score = CoreMatcherHandler.fieldExists(scoringAddress.getPreAddress()) || CoreMatcherHandler.fieldExists(candidate.getPreAddress()) ? (score += matchedConstants.getPreAddress() * candidate.getPreAddressScore()) : (score += blankConstants.getPreAddress() * candidate.getPreAddressScore());
        score = CoreMatcherHandler.fieldExists(scoringAddress.getMainAddress()) || CoreMatcherHandler.fieldExists(candidate.getMainAddress()) ? (score += matchedConstants.getMainAddress() * candidate.getMainAddressScore()) : (score += blankConstants.getMainAddress() * candidate.getMainAddressScore());
        score = CoreMatcherHandler.fieldExists(scoringAddress.getPostAddress()) || CoreMatcherHandler.fieldExists(candidate.getPostAddress()) ? (score += matchedConstants.getPostAddress() * candidate.getPostAddressScore()) : (score += blankConstants.getPostAddress() * candidate.getPostAddressScore());
        if (CoreMatcherHandler.fieldExists(scoringAddress.getPreThoroughfareType()) || CoreMatcherHandler.fieldExists(candidate.getPreThoroughfareType())) {
            score += matchedConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore();
            if (!CoreMatcherHandler.fieldExists(scoringAddress.getPreThoroughfareType())) {
                typeDelta += matchedConstants.getPreThoroughfareType() - blankConstants.getPreThoroughfareType();
            }
        } else {
            score += blankConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore();
        }
        if (CoreMatcherHandler.fieldExists(scoringAddress.getPostThoroughfareType()) || CoreMatcherHandler.fieldExists(candidate.getPostThoroughfareType())) {
            score += matchedConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore();
            if (!CoreMatcherHandler.fieldExists(scoringAddress.getPostThoroughfareType())) {
                typeDelta += matchedConstants.getPostThoroughfareType() - blankConstants.getPostThoroughfareType();
            }
        } else {
            score += blankConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore();
        }
        if (candidate.hasAdditionalFields()) {
            score += matchedConstants.getAdditionalFields() * candidate.getAdditionalParserFieldsScore();
        }
        candidate.setCombinedAddressScore(Math.min(score / (this.m_maximumAddressScore + typeDelta), 1.0));
        score = 0.0;
        score = CoreMatcherHandler.fieldExists(scoringAddress.getPostCode1()) ? (score += matchedConstants.getPostalCode1() * candidate.getPostCode1Score()) : (score += blankConstants.getPostalCode1() * candidate.getPostCode1Score());
        score = CoreMatcherHandler.fieldExists(scoringAddress.getPostCode2()) ? (score += matchedConstants.getPostalCode2() * candidate.getPostCode2Score()) : (score += blankConstants.getPostalCode2() * candidate.getPostCode2Score());
        score = CoreMatcherHandler.fieldExists(scoringAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1() * candidate.getAreaName1Score()) : (score += blankConstants.getAreaName1() * candidate.getAreaName1Score());
        score = CoreMatcherHandler.fieldExists(scoringAddress.getAreaName2()) ? (score += matchedConstants.getAreaName2() * candidate.getAreaName2Score()) : (score += blankConstants.getAreaName2() * candidate.getAreaName2Score());
        score = CoreMatcherHandler.fieldExists(scoringAddress.getAreaName3()) ? (score += matchedConstants.getAreaName3() * candidate.getAreaName3Score()) : (score += blankConstants.getAreaName3() * candidate.getAreaName3Score());
        score = CoreMatcherHandler.fieldExists(scoringAddress.getAreaName4()) ? (score += matchedConstants.getAreaName4() * candidate.getAreaName4Score()) : (score += blankConstants.getAreaName4() * candidate.getAreaName4Score());
        score = CoreMatcherHandler.fieldExists(scoringAddress.getUnitType()) ? (score += matchedConstants.getUnitType() * candidate.getUnitTypeScore()) : (score += blankConstants.getUnitType() * candidate.getUnitTypeScore());
        candidate.setCombinedAdditionalFieldScore(score / this.m_maximumAdditionalFieldScore);
        candidate.buildInputMatchScore(scoringAddress, matchedConstants);
    }

    @Override
    public void computeMaximumAddressScore(Address parsedAddress, InternalMatcherConstants constants) {
        this.m_maximumAddressScore = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        this.m_maximumAddressScore = parsedAddress.getParsedAddressNumber() != null ? (this.m_maximumAddressScore += matchedConstants.getAddressNumber()) : (this.m_maximumAddressScore += blankConstants.getAddressNumber());
        this.m_maximumAddressScore = CoreMatcherHandler.fieldExists(parsedAddress.getPreThoroughfareType()) ? (this.m_maximumAddressScore += matchedConstants.getPreThoroughfareType()) : (this.m_maximumAddressScore += blankConstants.getPreThoroughfareType());
        this.m_maximumAddressScore = CoreMatcherHandler.fieldExists(parsedAddress.getPreAddress()) ? (this.m_maximumAddressScore += matchedConstants.getPreAddress()) : (this.m_maximumAddressScore += blankConstants.getPreAddress());
        this.m_maximumAddressScore = CoreMatcherHandler.fieldExists(parsedAddress.getMainAddress()) ? (this.m_maximumAddressScore += matchedConstants.getMainAddress()) : (this.m_maximumAddressScore += blankConstants.getMainAddress());
        this.m_maximumAddressScore = CoreMatcherHandler.fieldExists(parsedAddress.getPostAddress()) ? (this.m_maximumAddressScore += matchedConstants.getPostAddress()) : (this.m_maximumAddressScore += blankConstants.getPostAddress());
        this.m_maximumAddressScore = CoreMatcherHandler.fieldExists(parsedAddress.getPostThoroughfareType()) ? (this.m_maximumAddressScore += matchedConstants.getPostThoroughfareType()) : (this.m_maximumAddressScore += blankConstants.getPostThoroughfareType());
    }

    @Override
    public void computeMaximumAdditionalFieldScore(Address parsedAddress, InternalMatcherConstants constants) {
        this.m_maximumAdditionalFieldScore = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        this.m_maximumAdditionalFieldScore = CoreMatcherHandler.fieldExists(parsedAddress.getAreaName1()) ? (this.m_maximumAdditionalFieldScore += matchedConstants.getAreaName1()) : (this.m_maximumAdditionalFieldScore += blankConstants.getAreaName1());
        this.m_maximumAdditionalFieldScore = CoreMatcherHandler.fieldExists(parsedAddress.getAreaName2()) ? (this.m_maximumAdditionalFieldScore += matchedConstants.getAreaName2()) : (this.m_maximumAdditionalFieldScore += blankConstants.getAreaName2());
        this.m_maximumAdditionalFieldScore = CoreMatcherHandler.fieldExists(parsedAddress.getAreaName3()) ? (this.m_maximumAdditionalFieldScore += matchedConstants.getAreaName3()) : (this.m_maximumAdditionalFieldScore += blankConstants.getAreaName3());
        this.m_maximumAdditionalFieldScore = CoreMatcherHandler.fieldExists(parsedAddress.getAreaName4()) ? (this.m_maximumAdditionalFieldScore += matchedConstants.getAreaName4()) : (this.m_maximumAdditionalFieldScore += blankConstants.getAreaName4());
        this.m_maximumAdditionalFieldScore = CoreMatcherHandler.fieldExists(parsedAddress.getPostCode1()) ? (this.m_maximumAdditionalFieldScore += matchedConstants.getPostalCode1()) : (this.m_maximumAdditionalFieldScore += blankConstants.getPostalCode1());
        this.m_maximumAdditionalFieldScore = CoreMatcherHandler.fieldExists(parsedAddress.getPostCode2()) ? (this.m_maximumAdditionalFieldScore += matchedConstants.getPostalCode2()) : (this.m_maximumAdditionalFieldScore += blankConstants.getPostalCode2());
    }

    public static boolean fieldExists(String str) {
        return str != null && str.length() != 0;
    }

    @Override
    public List removeMultipleSegmentsForStreet(List candidates, IConstraints constraints) {
        if (candidates == null || candidates.isEmpty()) {
            return candidates;
        }
        if (constraints.isMatcherRemoveMultipleSegments()) {
            StreetMultipleSegmentComparator comparator = new StreetMultipleSegmentComparator();
            Collections.sort(candidates, comparator);
            Collections.reverse(candidates);
            ICoreMatcher handler = (ICoreMatcher)((Object)constraints.getHandler());
            Iterator candidateIterator = candidates.iterator();
            boolean first = true;
            InternalCandidateAddress bestCandidateForStreet = null;
            while (candidateIterator.hasNext()) {
                if (first) {
                    bestCandidateForStreet = (InternalCandidateAddress)candidateIterator.next();
                    first = false;
                    continue;
                }
                InternalCandidateAddress candidate = (InternalCandidateAddress)candidateIterator.next();
                if (candidate.getStreetOffset() == bestCandidateForStreet.getStreetOffset()) {
                    if (handler.getMatcherHandler().removeSecondCandidate(bestCandidateForStreet, candidate)) {
                        candidateIterator.remove();
                        continue;
                    }
                    bestCandidateForStreet = candidate;
                    continue;
                }
                bestCandidateForStreet = candidate;
            }
            return candidates;
        }
        return candidates;
    }

    @Override
    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        return true;
    }
}

