/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.multicountry;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class CandidateAddressComparator
implements Comparator<CandidateAddress> {
    private boolean preferZoverGatSameLevel = false;
    private boolean preferADoverUD = true;
    private Set<String> availableCountrySet = new HashSet<String>();

    public CandidateAddressComparator(Set<String> availableCountries) {
        this.availableCountrySet.addAll(availableCountries);
    }

    @Override
    public int compare(CandidateAddress first, CandidateAddress second) {
        char otherC;
        if (first.isCloseMatch() && !second.isCloseMatch()) {
            return -1;
        }
        if (second.isCloseMatch() && !first.isCloseMatch()) {
            return 1;
        }
        String mine = first.getPrecisionCode();
        String other = second.getPrecisionCode();
        if (mine == null || mine.length() < 2) {
            if (other == null || other.length() < 2) {
                return 0;
            }
            return 1;
        }
        if (other == null || other.length() < 2) {
            return -1;
        }
        char myC = mine.charAt(0);
        if (myC != (otherC = other.charAt(0))) {
            if (myC == 'S' || otherC == 'S') {
                return this.compareGeographicToStreet(first, second);
            }
            if (this.preferZoverGatSameLevel) {
                if (myC == 'Z') {
                    return -1;
                }
                return 1;
            }
            if (myC == 'G') {
                return -1;
            }
            return 1;
        }
        if (myC == 'S') {
            int otherMisses;
            int myMisses = this.countMisses(mine);
            if (myMisses < (otherMisses = this.countMisses(other))) {
                return -1;
            }
            if (otherMisses < myMisses) {
                return 1;
            }
            if (first.getLocationPrecision() > second.getLocationPrecision()) {
                return -1;
            }
            if (first.getLocationPrecision() < second.getLocationPrecision()) {
                return 1;
            }
            if (mine.length() == other.length() && (myC = mine.charAt(mine.length() - 1)) != (otherC = other.charAt(other.length() - 1))) {
                if (this.preferADoverUD) {
                    if (myC == 'A') {
                        return -1;
                    }
                    return 1;
                }
                if (myC == 'U') {
                    return -1;
                }
                return 1;
            }
        } else if (myC == 'G') {
            int test = this.compareSameCountry(first, second);
            if (test != 0) {
                return test;
            }
            test = this.compareGeographicMatches(first, second);
            if (test != 0) {
                return test;
            }
            test = this.compareCountryAvailability(first, second);
            if (test != 0) {
                return test;
            }
            if (first.doesAreaName3Match() && !second.doesAreaName3Match()) {
                return -1;
            }
            if (!first.doesAreaName3Match() && second.doesAreaName3Match()) {
                return 1;
            }
            if (first.doesAreaName4Match() && !second.doesAreaName4Match()) {
                return -1;
            }
            if (!first.doesAreaName4Match() && second.doesAreaName4Match()) {
                return 1;
            }
            if (first.doesAreaName1Match() && !second.doesAreaName1Match()) {
                return -1;
            }
            if (!first.doesAreaName1Match() && second.doesAreaName1Match()) {
                return 1;
            }
            if (first.doesAreaName2Match() && !second.doesAreaName2Match()) {
                return -1;
            }
            if (!first.doesAreaName2Match() && second.doesAreaName2Match()) {
                return 1;
            }
        } else if (myC == 'Z') {
            if (first.getLocationPrecision() > second.getLocationPrecision()) {
                return -1;
            }
            if (first.getLocationPrecision() < second.getLocationPrecision()) {
                return 1;
            }
            if (first.doesPostalCode1Match() && !second.doesPostalCode1Match()) {
                return -1;
            }
            if (!first.doesPostalCode1Match() && second.doesPostalCode1Match()) {
                return 1;
            }
        }
        return this.compareCountryAvailability(first, second);
    }

    protected int compareGeographicMatches(CandidateAddress first, CandidateAddress second) {
        int secondPrec;
        int firstPrec;
        String firstRank = first.getAdditionalFieldForKey("CITYRANK");
        String secondRank = second.getAdditionalFieldForKey("CITYRANK");
        if (firstRank != null && secondRank != null && !firstRank.equals(secondRank)) {
            try {
                int firstI = Integer.parseInt(firstRank);
                int secondI = Integer.parseInt(secondRank);
                if (firstI < secondI) {
                    return -1;
                }
                return 1;
            }
            catch (NumberFormatException firstI) {
                // empty catch block
            }
        }
        if ((firstPrec = first.getLocationPrecision()) != (secondPrec = second.getLocationPrecision())) {
            if (firstPrec == 10) {
                return -1;
            }
            if (secondPrec == 10) {
                return 1;
            }
            if (first.getLocationPrecision() > second.getLocationPrecision()) {
                return -1;
            }
            if (first.getLocationPrecision() < second.getLocationPrecision()) {
                return 1;
            }
        }
        return 0;
    }

    protected int compareCountryAvailability(CandidateAddress first, CandidateAddress second) {
        boolean firstBool = this.availableCountrySet.contains(first.getCountry());
        boolean secondBool = this.availableCountrySet.contains(second.getCountry());
        if (firstBool && !secondBool) {
            return -1;
        }
        if (secondBool && !firstBool) {
            return 1;
        }
        return 0;
    }

    protected int compareSameCountry(CandidateAddress first, CandidateAddress second) {
        int secondDict;
        boolean secondFromWorld;
        if (!StringUtilities.equalStrings(first.getCountry(), second.getCountry())) {
            return 0;
        }
        boolean firstFromWorld = first.getAdditionalFieldForKey("CITYRANK") != null;
        boolean bl = secondFromWorld = second.getAdditionalFieldForKey("CITYRANK") != null;
        if (firstFromWorld && !secondFromWorld) {
            return 1;
        }
        if (secondFromWorld && !firstFromWorld) {
            return -1;
        }
        int firstDict = first.getConfiguredDictionaryNumber();
        if (firstDict < (secondDict = second.getConfiguredDictionaryNumber())) {
            return -1;
        }
        if (firstDict > secondDict) {
            return 1;
        }
        return 0;
    }

    protected int compareGeographicToStreet(CandidateAddress first, CandidateAddress second) {
        boolean sameCountry;
        int preferFirst = 0;
        int preferSecond = 0;
        String firstPrec = first.getPrecisionCode();
        String secondPrec = second.getPrecisionCode();
        boolean bl = sameCountry = first.getCountry() != null && first.getCountry().equals(second.getCountry());
        if (firstPrec.charAt(0) == 'G') {
            if (sameCountry) {
                return 1;
            }
            preferFirst = this.adjustByRank(first.getAdditionalFieldForKey("CITYRANK"), preferFirst);
            preferSecond = this.adjustByPrecision(secondPrec, preferSecond);
        } else {
            if (sameCountry) {
                return -1;
            }
            preferSecond = this.adjustByRank(second.getAdditionalFieldForKey("CITYRANK"), preferSecond);
            preferFirst = this.adjustByPrecision(firstPrec, preferFirst);
        }
        if (preferFirst > preferSecond) {
            return -1;
        }
        if (preferFirst < preferSecond) {
            return 1;
        }
        return 0;
    }

    protected int adjustByRank(String rank, int initVal) {
        int value = initVal;
        if (rank != null && !rank.isEmpty()) {
            ++value;
            if ("10".equals(rank)) {
                --value;
            }
            if ("1".equals(rank)) {
                ++value;
            }
        }
        return value;
    }

    protected int adjustByPrecision(String precision, int initVal) {
        int value = initVal;
        if (precision.indexOf(67) > 0) {
            ++value;
        }
        if (precision.indexOf(90) > 0) {
            ++value;
        }
        if (precision.indexOf(72) > 0) {
            ++value;
        }
        if (precision.indexOf(78) > 0) {
            ++value;
        }
        return value;
    }

    private int countMisses(String str) {
        String missed = StringUtilities.trimToChars(str, "-");
        return missed.length();
    }

    public void setPreferZoverGatSameLevel(boolean preferZoverGatSameLevel) {
        this.preferZoverGatSameLevel = preferZoverGatSameLevel;
    }

    public void setPreferADoverUD(boolean preferADoverUD) {
        this.preferADoverUD = preferADoverUD;
    }

    public Set<String> getAvailableCountrySet() {
        return this.availableCountrySet;
    }
}

