/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.multicountry;

import com.mapinfo.mapmarker.common.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CountryTuner {
    protected String originalString;
    private ArrayList<String> tokensByLength = null;
    private ArrayList<Integer> tokenTypes = null;
    private static final LengthSorter sorter = new LengthSorter();
    private static final Map<String, String[]> keywordMap;
    private static final List<Pattern> patternList;
    private static final List<String[]> patternSuggestions;
    private static Map<Character.UnicodeBlock, Set<String>> charsetMap;
    private static int ALPHA;
    private static int NUMERIC;
    private static int OTHER;

    public CountryTuner(Address input) {
        this.originalString = this.buildSingleLine(input);
    }

    public CountryTuner(String input) {
        this.originalString = input;
    }

    protected ArrayList<String> getTokensByLength() {
        if (this.tokensByLength == null) {
            this.buildTokens();
        }
        return this.tokensByLength;
    }

    public List<String> recommendCountriesByCharset(boolean stopOnFirstMatch, String charsetDescriptiveString) {
        Map<Character.UnicodeBlock, Set<String>> blockSet = CountryTuner.getBlockSet(charsetDescriptiveString);
        ArrayList<String> countries = new ArrayList<String>();
        for (char c : this.originalString.toCharArray()) {
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            Set<String> supportedCountries = blockSet.get(block);
            if (supportedCountries != null) {
                countries.addAll(supportedCountries);
            }
            if (!stopOnFirstMatch || countries.isEmpty()) continue;
            return countries;
        }
        return countries;
    }

    public List<String> recommendCountriesWithAlnumPostcodes(ArrayList<String> countries) {
        this.buildTokens();
        int alnum = ALPHA | NUMERIC;
        for (int type : this.tokenTypes) {
            if (type != alnum) continue;
            countries.add("GBR");
            countries.add("CAN");
            break;
        }
        return countries;
    }

    public List<String> recommendCountriesByKeywords(boolean stopOnFirstMatch) {
        ArrayList<String> countries = new ArrayList<String>();
        ArrayList<String> tokens = this.getTokensByLength();
        for (String token : tokens) {
            if (!keywordMap.containsKey(token)) continue;
            for (String ctry : keywordMap.get(token)) {
                countries.add(ctry);
            }
            if (!stopOnFirstMatch) continue;
            return countries;
        }
        return countries;
    }

    public List<String> recommendCountriesByPatterns(boolean stopOnFirstMatch) {
        ArrayList<String> countries = new ArrayList<String>();
        if (this.originalString == null) {
            return countries;
        }
        for (int i = 0; i < patternList.size(); ++i) {
            if (!patternList.get(i).matcher(this.originalString).matches()) continue;
            for (String str : patternSuggestions.get(i)) {
                countries.add(str);
            }
            if (!stopOnFirstMatch) continue;
            return countries;
        }
        return countries;
    }

    private String buildSingleLine(Address address) {
        StringBuilder stringBuilder = new StringBuilder();
        if (address != null) {
            this.appendNonNull(stringBuilder, address.getAddressNumber());
            this.appendNonNull(stringBuilder, address.getPreDirectional());
            this.appendNonNull(stringBuilder, address.getPreThoroughfareType());
            this.appendNonNull(stringBuilder, address.getMainAddress());
            this.appendNonNull(stringBuilder, address.getPostThoroughfareType());
            this.appendNonNull(stringBuilder, address.getPostDirectional());
            this.appendNonNull(stringBuilder, address.getPostAddress());
            this.appendNonNull(stringBuilder, address.getAreaName1());
            this.appendNonNull(stringBuilder, address.getAreaName2());
            this.appendNonNull(stringBuilder, address.getAreaName3());
            this.appendNonNull(stringBuilder, address.getAreaName4());
            this.appendNonNull(stringBuilder, address.getPostCode1());
            this.appendNonNull(stringBuilder, address.getPostCode2());
        }
        return stringBuilder.toString();
    }

    private void appendNonNull(StringBuilder builder, String test) {
        if (test != null && test.length() > 0) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(test);
        }
    }

    private void buildTokens() {
        if (this.tokensByLength != null) {
            return;
        }
        this.tokensByLength = new ArrayList();
        if (this.originalString == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.originalString.toLowerCase(), ",.- ");
        while (stringTokenizer.hasMoreTokens()) {
            this.tokensByLength.add(stringTokenizer.nextToken());
        }
        Collections.sort(this.tokensByLength, sorter);
        this.tokenTypes = new ArrayList(this.tokensByLength.size());
        for (int i = 0; i < this.tokensByLength.size(); ++i) {
            String token = this.tokensByLength.get(i);
            int type = 0;
            for (char c : token.toCharArray()) {
                if (Character.isLetter(c)) {
                    type |= ALPHA;
                    continue;
                }
                if (Character.isDigit(c)) {
                    type |= NUMERIC;
                    continue;
                }
                type |= OTHER;
            }
            this.tokenTypes.add(type);
        }
    }

    protected static Map<Character.UnicodeBlock, Set<String>> getBlockSet(String charsetDescriptiveString) {
        if (charsetMap != null) {
            return charsetMap;
        }
        HashMap<Character.UnicodeBlock, Set<String>> map = new HashMap<Character.UnicodeBlock, Set<String>>();
        if (charsetDescriptiveString == null) {
            return map;
        }
        StringTokenizer entryTokenizer = new StringTokenizer(charsetDescriptiveString, ":");
        while (entryTokenizer.hasMoreTokens()) {
            String entry = entryTokenizer.nextToken();
            StringTokenizer lineTokenizer = new StringTokenizer(entry, " ");
            String name = lineTokenizer.nextToken();
            HashSet<String> countries = new HashSet<String>();
            while (lineTokenizer.hasMoreTokens()) {
                countries.add(lineTokenizer.nextToken());
            }
            Character.UnicodeBlock block = Character.UnicodeBlock.forName(name);
            if (name == null) continue;
            map.put(block, countries);
        }
        charsetMap = Collections.unmodifiableMap(map);
        return charsetMap;
    }

    static {
        ALPHA = 1;
        NUMERIC = 2;
        OTHER = 4;
        HashMap<String, String[]> tempMap = new HashMap<String, String[]>();
        String[] germanSpeaking = new String[]{"DEU", "AUT"};
        String[] germany = new String[]{"DEU"};
        String[] frenchSpeaking = new String[]{"FRA", "CAN"};
        String[] france = new String[]{"FRA"};
        tempMap.put("str", germanSpeaking);
        tempMap.put("bad", germany);
        tempMap.put("munchen", germany);
        tempMap.put("m\u00fcnchen", germany);
        tempMap.put("strasse", germanSpeaking);
        tempMap.put("rue", frenchSpeaking);
        tempMap.put("cedex", france);
        keywordMap = Collections.unmodifiableMap(tempMap);
        ArrayList<Pattern> tempPatterns = new ArrayList<Pattern>();
        ArrayList<String[]> tempCountries = new ArrayList<String[]>();
        Pattern pat = Pattern.compile(".*\u00df.*");
        tempPatterns.add(pat);
        tempCountries.add(germanSpeaking);
        pat = Pattern.compile(".*str\\.? .*");
        tempPatterns.add(pat);
        tempCountries.add(germanSpeaking);
        patternList = Collections.unmodifiableList(tempPatterns);
        patternSuggestions = Collections.unmodifiableList(tempCountries);
    }

    private static class LengthSorter
    implements Comparator<String> {
        private LengthSorter() {
        }

        @Override
        public int compare(String firstStr, String secondStr) {
            int second;
            int first = firstStr.length();
            if (first > (second = secondStr.length())) {
                return -1;
            }
            if (second > first) {
                return 1;
            }
            return 0;
        }
    }
}

