/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.multicountry;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.multicountry.IGeocodeInputFilter;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class DefaultCGGEGeocodeInputFilter
implements IGeocodeInputFilter {
    HashSet<String> types = new HashSet();
    HashSet<String> altTypes = new HashSet();
    HashSet<String> multiWordTypes = new HashSet();
    HashSet<String> multiWordAltTypes = new HashSet();
    HashSet<String> commonWords = new HashSet();
    HashSet<String> multiWordCommonWords = new HashSet();

    public DefaultCGGEGeocodeInputFilter(String countryCode) {
        StringTokenizer st;
        int idx;
        String value;
        String key;
        Properties properties2;
        StringBuilder base = new StringBuilder("com.mapinfo.mapmarker.");
        base.append(countryCode);
        base.append(".config.");
        base.append(countryCode);
        StringBuilder sb = new StringBuilder(base);
        sb.append("_ThoroughfareTypes.properties");
        try {
            properties2 = FileUtilities.loadProperties(sb.toString());
            for (Object obj : properties2.keySet()) {
                key = (String)obj;
                value = properties2.getProperty(key);
                idx = key.indexOf(95);
                if ((idx = (key = key.substring(idx + 1)).indexOf(43)) < 0) {
                    this.types.add(key);
                } else {
                    key = key.replace('+', ' ');
                    this.multiWordTypes.add(key);
                }
                if (StringUtilities.isEmpty(value)) continue;
                st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    key = st.nextToken().trim();
                    idx = key.indexOf(32);
                    if (idx < 0) {
                        if (this.types.contains(key)) continue;
                        this.altTypes.add(key);
                        continue;
                    }
                    if (this.multiWordTypes.contains(key)) continue;
                    this.multiWordAltTypes.add(key);
                }
            }
        }
        catch (Throwable properties2) {
            // empty catch block
        }
        sb = new StringBuilder(base);
        sb.append("_ParserTerms.properties");
        try {
            properties2 = FileUtilities.loadProperties(sb.toString());
            for (Object obj : properties2.keySet()) {
                key = (String)obj;
                value = properties2.getProperty(key);
                idx = key.indexOf(95);
                if (idx < 0) {
                    idx = key.indexOf(43);
                    if (idx < 0) {
                        this.commonWords.add(key);
                        continue;
                    }
                    this.multiWordCommonWords.add(key.replace('+', ' '));
                    continue;
                }
                if (StringUtilities.isEmpty(value)) continue;
                st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    key = st.nextToken().trim();
                    idx = key.indexOf(32);
                    if (idx < 0) {
                        this.commonWords.add(key);
                        continue;
                    }
                    this.multiWordCommonWords.add(key);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public double scoreAddressForCountry(Address address, String concatenatedFields) {
        double score = 0.0;
        double commonCount = 0.0;
        StringTokenizer st = new StringTokenizer(concatenatedFields);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (this.types.contains(tok)) {
                score += 0.3;
            } else if (this.commonWords.contains(tok)) {
                commonCount += 1.0;
            }
            if (!(commonCount > 6.0)) continue;
            return score + 0.7;
        }
        return score += commonCount * 0.1;
    }
}

