/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.multicountry;

import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class MultiCountryBasicSettings {
    public static final String COUNTRY_FALLBACK_MODE = "COUNTRY_FALLBACK_MODE";
    public static final String CF_MODE_LIMITED = "LIMITED";
    public static final String CF_MODE_BASIC = "BASIC";
    public static final String CF_MODE_OPTIMIZED = "OPTIMIZED";
    public static final String CF_MODE_EXTENDED = "EXTENDED";
    public static final String DEFAULT_GEOCODER_KEY = "DEFAULT_GEOCODER_COUNTRY_CODE";
    public static final String DEFAULT_GEOCODER_ANY_COUNTRY_KEY = "USE_DEFAULT_GEOCODER_FOR_ANY_UNAVAILABLE_COUNTRY";
    public static final String REPLACE_NULL_COUNTRY_WITH_DEFAULT = "REPLACE_NULL_COUNTRY_WITH_DEFAULT";
    public static final String CHECK_SINGLELINE_FOR_COUNTRY_CODE = "CHECK_SINGLELINE_FOR_COUNTRY_CODE";
    public static final String CHECK_POSTADDRESS_FOR_COUNTRY_CODE = "CHECK_POSTADDRESS_FOR_COUNTRY_CODE";
    public static final String COUNTRY_FALLBACK_ENABLED = "COUNTRY_FALLBACK_ENABLED";
    public static final String COUNTRY_FALLBACK_ON_UNRECOGNIZED_INPUT_COUNTRY = "COUNTRY_FALLBACK_ON_UNRECOGNIZED_INPUT_COUNTRY";
    public static final String COUNTRY_FALLBACK_ON_NULL_INPUT_COUNTRY = "COUNTRY_FALLBACK_ON_NULL_INPUT_COUNTRY";
    public static final String COUNTRY_FALLBACK_INCLUDE_UNFILTERED_GEOCODERS = "COUNTRY_FALLBACK_INCLUDE_UNFILTERED_GEOCODERS";
    public static final String COUNTRY_FALLBACK_RETURN_ON_FIRST_CLOSE_STREET_CANDIDATES = "COUNTRY_FALLBACK_RETURN_ON_FIRST_CLOSE_STREET_CANDIDATES";
    public static final String COUNTRY_FALLBACK_EXCLUDED_COUNTRIES = "COUNTRY_FALLBACK_EXCLUDED_COUNTRIES";
    public static final String COUNTRY_FALLBACK_PREFERRED_COUNTRIES = "COUNTRY_FALLBACK_PREFERRED_COUNTRIES";
    public static final String COUNTRY_FALLBACK_PREFERRED_COUNTRIES_ONLY = "COUNTRY_FALLBACK_PREFERRED_COUNTRIES_ONLY";
    public static final String COUNTRY_FALLBACK_PRIMARY_GEOCODER = "COUNTRY_FALLBACK_PRIMARY_GEOCODER";
    public static final String COUNTRY_FALLBACK_WORLD_GEOCODER_SUGGESTIONS_ONLY = "COUNTRY_FALLBACK_WORLD_GEOCODER_SUGGESTIONS_ONLY";
    public static final String COUNTRY_FALLBACK_USE_WORLD_GEOCODER_TO_SUGGEST_COUNTRY = "COUNTRY_FALLBACK_USE_WORLD_GEOCODER_TO_SUGGEST_COUNTRY";
    public static final String COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_KEYWORD = "COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_KEYWORD";
    public static final String COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_PATTERN = "COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_PATTERN";
    public static final String COUNTRY_FALLBACK_OVERRIDE_ENABLED = "COUNTRY_FALLBACK_OVERRIDE_ENABLED";
    private boolean m_bNoCountryGeocodingInitialized;
    private boolean countryFallbackOnUnrecognizedInputCountry;
    private boolean countryFallbackOnNullInputCountry;
    private boolean countryFallbackIncludeUnfilteredCountries;
    private boolean useDefaultForAnyUnavailableCountry;
    private boolean replaceNullInputCountryWithDefault;
    private boolean countryFallbackEnabled;
    private boolean checkSingleLineForCountryCode = true;
    private boolean checkLastLineForCountryCode = true;
    private boolean returnOnFirstCloseStreetCandidates;
    private boolean searchWorldGeocoderRecommendationsOnly;
    private boolean searchPreferredCountriesOnly;
    private boolean determineCountryByKeyword;
    private boolean determineCountryByPattern;
    private boolean allowConstraintsOverride;
    private boolean useWorldGeocoderToDetermineCountry;
    private List<String> primaryGeocoderCodeList = new ArrayList<String>();
    private String defaultGeocoderCode = "XWG";
    private List<String> preferredCountriesList = new ArrayList<String>();
    private Set<String> excludedCountriesSet = new HashSet<String>();

    public MultiCountryBasicSettings() {
    }

    public MultiCountryBasicSettings(Properties properties) {
        this.initializeFromProperties(properties);
    }

    public boolean isReturnOnFirstCloseStreetCandidates() {
        return this.returnOnFirstCloseStreetCandidates;
    }

    public void setReturnOnFirstCloseStreetCandidates(boolean returnOnFirstCloseStreetCandidates) {
        this.returnOnFirstCloseStreetCandidates = returnOnFirstCloseStreetCandidates;
    }

    public boolean isSearchWorldGeocoderRecommendationsOnly() {
        return this.searchWorldGeocoderRecommendationsOnly;
    }

    public void setSearchWorldGeocoderRecommendationsOnly(boolean searchWorldGeocoderRecommendationsOnly) {
        this.searchWorldGeocoderRecommendationsOnly = searchWorldGeocoderRecommendationsOnly;
    }

    public List<String> getPrimaryGeocoderCountryCodes() {
        return this.primaryGeocoderCodeList;
    }

    public void setPrimaryGeocoderCountryCodes(String primaryGeocoderCodes) {
        this.primaryGeocoderCodeList.clear();
        if (!StringUtilities.isEmpty(primaryGeocoderCodes)) {
            StringTokenizer stringTokenizer = new StringTokenizer(primaryGeocoderCodes, ",; ");
            while (stringTokenizer.hasMoreTokens()) {
                this.primaryGeocoderCodeList.add(stringTokenizer.nextToken());
            }
        }
    }

    public void setPrimaryGeocoderCountryCodes(List<String> primaryGeocoderCodes) {
        this.primaryGeocoderCodeList = primaryGeocoderCodes;
    }

    public String getDefaultGeocoderCountryCode() {
        return this.defaultGeocoderCode;
    }

    public void setDefaultGeocoderCountryCode(String defaultGeocoderCode) {
        this.defaultGeocoderCode = defaultGeocoderCode;
    }

    public boolean isSearchPreferredCountriesOnly() {
        return this.searchPreferredCountriesOnly;
    }

    public void setSearchPreferredCountriesOnly(boolean searchPreferredCountriesOnly) {
        this.searchPreferredCountriesOnly = searchPreferredCountriesOnly;
    }

    public List<String> getPreferredCountriesList() {
        return this.preferredCountriesList;
    }

    public void setPreferredCountriesList(List<String> preferredCountriesList) {
        this.preferredCountriesList.clear();
        if (preferredCountriesList != null) {
            this.preferredCountriesList.addAll(preferredCountriesList);
        }
    }

    public Set<String> getExcludedCountriesSet() {
        return this.excludedCountriesSet;
    }

    public void setExcludedCountriesSet(Set<String> excludedCountriesList) {
        this.excludedCountriesSet.clear();
        if (excludedCountriesList != null) {
            this.excludedCountriesSet.addAll(excludedCountriesList);
        }
    }

    public boolean isDetermineCountryByKeyword() {
        return this.determineCountryByKeyword;
    }

    public void setDetermineCountryByKeyword(boolean determineCountryByKeyword) {
        this.determineCountryByKeyword = determineCountryByKeyword;
    }

    public boolean isDetermineCountryByPattern() {
        return this.determineCountryByPattern;
    }

    public void setDetermineCountryByPattern(boolean determineCountryByPattern) {
        this.determineCountryByPattern = determineCountryByPattern;
    }

    public boolean isAllowConstraintsOverride() {
        return this.allowConstraintsOverride;
    }

    public void setAllowConstraintsOverride(boolean allowConstraintsOverride) {
        this.allowConstraintsOverride = allowConstraintsOverride;
    }

    public boolean isUseWorldGeocoderToDetermineCountry() {
        return this.useWorldGeocoderToDetermineCountry;
    }

    public void setUseWorldGeocoderToDetermineCountry(boolean useWorldGeocoderToDetermineCountry) {
        this.useWorldGeocoderToDetermineCountry = useWorldGeocoderToDetermineCountry;
    }

    public void loadDefaultSettingsFromProvider() {
        if (this.m_bNoCountryGeocodingInitialized) {
            return;
        }
        DataManagerSettingsProvider provider = DataManagerSettingsProvider.getInstance();
        Properties props = null;
        try {
            props = provider.getSettingsForCountry("CORE_SETTINGS");
        }
        catch (IOException e) {
            MMJLog.getLog().warn("Unable to locate DataManagerSettings.properties file for country fallback and default geocoder options.", (Throwable)e);
            this.m_bNoCountryGeocodingInitialized = true;
            return;
        }
        this.initializeFromProperties(props);
        this.m_bNoCountryGeocodingInitialized = true;
    }

    public boolean isCheckSingleLineForCountryCode() {
        return this.checkSingleLineForCountryCode;
    }

    public void setCheckSingleLineForCountryCode(boolean checkSingleLineForCountryCode) {
        this.checkSingleLineForCountryCode = checkSingleLineForCountryCode;
    }

    public boolean isCheckLastLineForCountryCode() {
        return this.checkLastLineForCountryCode;
    }

    public void setCheckLastLineForCountryCode(boolean checkLastLineForCountryCode) {
        this.checkLastLineForCountryCode = checkLastLineForCountryCode;
    }

    protected CountryFallbackMode getMode(String value) {
        if (CF_MODE_LIMITED.equalsIgnoreCase(value)) {
            return CountryFallbackMode.LIMITED;
        }
        if (CF_MODE_BASIC.equalsIgnoreCase(value)) {
            return CountryFallbackMode.BASIC;
        }
        if (CF_MODE_OPTIMIZED.equalsIgnoreCase(value)) {
            return CountryFallbackMode.OPTIMIZED;
        }
        if (CF_MODE_EXTENDED.equalsIgnoreCase(value)) {
            return CountryFallbackMode.EXTENDED;
        }
        return CountryFallbackMode.UNKNOWN;
    }

    protected void initializeFromProperties(Properties props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        HashSet excludeSet = new HashSet();
        String tempStr = props.getProperty(COUNTRY_FALLBACK_EXCLUDED_COUNTRIES);
        MultiCountryBasicSettings.parseAndAddCountryCodes(tempStr, excludeSet);
        this.setExcludedCountriesSet(Collections.unmodifiableSet(excludeSet));
        CountryFallbackMode mode = this.getMode(props.getProperty(COUNTRY_FALLBACK_MODE));
        if (mode != CountryFallbackMode.UNKNOWN) {
            this.setDefaultGeocoderCountryCode("XWG");
            this.setUseDefaultForAnyUnavailableCountry(true);
            if (mode.equals((Object)CountryFallbackMode.LIMITED)) {
                this.setReplaceNullInputCountryWithDefault(true);
                this.setCountryFallbackEnabled(false);
                return;
            }
            this.setCountryFallbackEnabled(true);
            this.setCountryFallbackOnNullInputCountry(true);
            this.setCountryFallbackOnUnrecognizedInputCountry(true);
            this.setUseWorldGeocoderToDetermineCountry(true);
            if (mode.equals((Object)CountryFallbackMode.BASIC)) {
                this.setSearchWorldGeocoderRecommendationsOnly(true);
                this.setReturnOnFirstCloseStreetCandidates(true);
            } else if (mode.equals((Object)CountryFallbackMode.OPTIMIZED)) {
                this.setSearchWorldGeocoderRecommendationsOnly(true);
                this.setReturnOnFirstCloseStreetCandidates(false);
            } else {
                this.setSearchWorldGeocoderRecommendationsOnly(false);
                this.setReturnOnFirstCloseStreetCandidates(false);
                this.setAllowConstraintsOverride(true);
                ArrayList preferredOrderList = new ArrayList();
                tempStr = props.getProperty(COUNTRY_FALLBACK_PREFERRED_COUNTRIES);
                MultiCountryBasicSettings.parseAndAddCountryCodes(tempStr, preferredOrderList);
                this.setPreferredCountriesList(Collections.unmodifiableList(preferredOrderList));
                this.setSearchPreferredCountriesOnly("true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_PREFERRED_COUNTRIES_ONLY, "false")));
            }
            return;
        }
        this.checkSingleLineForCountryCode = Boolean.valueOf(props.getProperty(CHECK_SINGLELINE_FOR_COUNTRY_CODE, "true"));
        this.checkLastLineForCountryCode = Boolean.valueOf(props.getProperty(CHECK_POSTADDRESS_FOR_COUNTRY_CODE, "true"));
        this.setDefaultGeocoderCountryCode(props.getProperty(DEFAULT_GEOCODER_KEY));
        this.useDefaultForAnyUnavailableCountry = "true".equalsIgnoreCase(props.getProperty(DEFAULT_GEOCODER_ANY_COUNTRY_KEY, "false"));
        this.replaceNullInputCountryWithDefault = "true".equalsIgnoreCase(props.getProperty(REPLACE_NULL_COUNTRY_WITH_DEFAULT, "false"));
        this.countryFallbackEnabled = "true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_ENABLED, "false"));
        if (this.countryFallbackEnabled) {
            this.setPrimaryGeocoderCountryCodes(props.getProperty(COUNTRY_FALLBACK_PRIMARY_GEOCODER));
            this.setReturnOnFirstCloseStreetCandidates("true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_RETURN_ON_FIRST_CLOSE_STREET_CANDIDATES, "false")));
            this.setSearchPreferredCountriesOnly("true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_PREFERRED_COUNTRIES_ONLY, "false")));
            this.setUseWorldGeocoderToDetermineCountry("true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_USE_WORLD_GEOCODER_TO_SUGGEST_COUNTRY, "false")));
            this.setSearchWorldGeocoderRecommendationsOnly("true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_WORLD_GEOCODER_SUGGESTIONS_ONLY, "false")));
            this.setDetermineCountryByKeyword("true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_KEYWORD, "false")));
            this.setDetermineCountryByPattern("true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_PATTERN, "false")));
            this.setAllowConstraintsOverride("true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_OVERRIDE_ENABLED, "false")));
            this.countryFallbackOnUnrecognizedInputCountry = "true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_ON_UNRECOGNIZED_INPUT_COUNTRY, "false"));
            this.countryFallbackOnNullInputCountry = "true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_ON_NULL_INPUT_COUNTRY, "false"));
            this.countryFallbackIncludeUnfilteredCountries = "true".equalsIgnoreCase(props.getProperty(COUNTRY_FALLBACK_INCLUDE_UNFILTERED_GEOCODERS, "false"));
            ArrayList preferredOrderList = new ArrayList();
            tempStr = props.getProperty(COUNTRY_FALLBACK_PREFERRED_COUNTRIES);
            MultiCountryBasicSettings.parseAndAddCountryCodes(tempStr, preferredOrderList);
            this.setPreferredCountriesList(Collections.unmodifiableList(preferredOrderList));
        }
    }

    static void parseAndAddCountryCodes(String countryCodeListString, Collection collection) {
        if (!StringUtilities.isEmpty(countryCodeListString)) {
            StringTokenizer st = new StringTokenizer(countryCodeListString, ", ;");
            while (st.hasMoreTokens()) {
                collection.add(st.nextToken().toUpperCase());
            }
        }
    }

    public boolean isCountryFallbackOnUnrecognizedInputCountry() {
        return this.countryFallbackOnUnrecognizedInputCountry;
    }

    public void setCountryFallbackOnUnrecognizedInputCountry(boolean countryFallbackOnUnrecognizedInputCountry) {
        this.countryFallbackOnUnrecognizedInputCountry = countryFallbackOnUnrecognizedInputCountry;
    }

    public boolean isCountryFallbackOnNullInputCountry() {
        return this.countryFallbackOnNullInputCountry;
    }

    public void setCountryFallbackOnNullInputCountry(boolean countryFallbackOnNullInputCountry) {
        this.countryFallbackOnNullInputCountry = countryFallbackOnNullInputCountry;
    }

    public boolean isCountryFallbackIncludeUnfilteredCountries() {
        return this.countryFallbackIncludeUnfilteredCountries;
    }

    public void setCountryFallbackIncludeUnfilteredCountries(boolean countryFallbackIncludeUnfilteredCountries) {
        this.countryFallbackIncludeUnfilteredCountries = countryFallbackIncludeUnfilteredCountries;
    }

    public boolean isUseDefaultForAnyUnavailableCountry() {
        return this.useDefaultForAnyUnavailableCountry;
    }

    public void setUseDefaultForAnyUnavailableCountry(boolean useDefaultForAnyUnavailableCountry) {
        this.useDefaultForAnyUnavailableCountry = useDefaultForAnyUnavailableCountry;
    }

    public boolean isReplaceNullInputCountryWithDefault() {
        return this.replaceNullInputCountryWithDefault;
    }

    public void setReplaceNullInputCountryWithDefault(boolean replaceNullInputCountryWithDefault) {
        this.replaceNullInputCountryWithDefault = replaceNullInputCountryWithDefault;
    }

    public boolean isCountryFallbackEnabled() {
        return this.countryFallbackEnabled;
    }

    public void setCountryFallbackEnabled(boolean countryFallbackEnabled) {
        this.countryFallbackEnabled = countryFallbackEnabled;
    }

    public void adjustForOverrides(Map<String, String> customPrefs) {
        if (!this.isAllowConstraintsOverride()) {
            return;
        }
        if (customPrefs == null || customPrefs.isEmpty()) {
            return;
        }
        String value = customPrefs.get(CHECK_SINGLELINE_FOR_COUNTRY_CODE);
        if (value != null) {
            this.checkSingleLineForCountryCode = Boolean.valueOf(value);
        }
        if ((value = customPrefs.get(CHECK_POSTADDRESS_FOR_COUNTRY_CODE)) != null) {
            this.checkLastLineForCountryCode = Boolean.valueOf(value);
        }
        if ((value = customPrefs.get(DEFAULT_GEOCODER_ANY_COUNTRY_KEY)) != null) {
            this.setUseDefaultForAnyUnavailableCountry(Boolean.valueOf(value));
        }
        if ((value = customPrefs.get(REPLACE_NULL_COUNTRY_WITH_DEFAULT)) != null) {
            this.setReplaceNullInputCountryWithDefault(Boolean.valueOf(value));
        }
        if ("false".equalsIgnoreCase(value = customPrefs.get(COUNTRY_FALLBACK_ENABLED))) {
            this.setCountryFallbackEnabled(false);
        }
        if ("false".equalsIgnoreCase(value = customPrefs.get(COUNTRY_FALLBACK_ON_NULL_INPUT_COUNTRY))) {
            this.setCountryFallbackOnNullInputCountry(false);
        }
        if ("false".equalsIgnoreCase(value = customPrefs.get(COUNTRY_FALLBACK_ON_UNRECOGNIZED_INPUT_COUNTRY))) {
            this.setCountryFallbackOnUnrecognizedInputCountry(false);
        }
        if ("true".equalsIgnoreCase(value = customPrefs.get(COUNTRY_FALLBACK_RETURN_ON_FIRST_CLOSE_STREET_CANDIDATES))) {
            this.setReturnOnFirstCloseStreetCandidates(true);
        }
        if ("true".equalsIgnoreCase(value = customPrefs.get(COUNTRY_FALLBACK_PREFERRED_COUNTRIES_ONLY))) {
            this.setSearchPreferredCountriesOnly(true);
        }
        if (!StringUtilities.isEmpty(value = customPrefs.get(COUNTRY_FALLBACK_EXCLUDED_COUNTRIES))) {
            StringTokenizer st = new StringTokenizer(value);
            while (st.hasMoreTokens()) {
                this.getExcludedCountriesSet().add(st.nextToken());
            }
        }
    }

    protected static enum CountryFallbackMode {
        UNKNOWN,
        LIMITED,
        BASIC,
        OPTIMIZED,
        EXTENDED;

    }
}

