/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.multicountry;

import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.multicountry.IGeocodeInputFilter;
import com.mapinfo.mapmarker.core.multicountry.MultiCountryGeocoder;
import com.mapinfo.mapmarker.core.multicountry.MultiCountryGeocoderHelper;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.List;
import java.util.Map;

public class MultiCountryGeocodableAddressFactory
extends GeocodableAddressFactory {
    public static double FILTER_THRESHHOLD = 0.4;
    protected MultiCountryGeocoderHelper multiCountryGeocoderHelper;

    public MultiCountryGeocodableAddressFactory(MultiCountryGeocoderHelper helper) {
        this.multiCountryGeocoderHelper = helper;
    }

    @Override
    public void resetSpecificDataManager() {
    }

    @Override
    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) {
        return new MultiCountryGeocoder(address, constraints, this.multiCountryGeocoderHelper);
    }

    public static int filterCountries(Address address, List<String> testCountries, Map<String, IGeocodeInputFilter> filters) throws IllegalAccessException, InstantiationException, ClassCastException {
        if (filters.isEmpty() || testCountries.isEmpty()) {
            return 0;
        }
        int removedCount = 0;
        StringBuilder sb = new StringBuilder(512);
        String tmp = address.getMainAddress();
        if (!StringUtilities.isEmpty(tmp)) {
            sb.append(tmp);
            sb.append(' ');
        }
        if (!StringUtilities.isEmpty(tmp = address.getPostAddress())) {
            sb.append(tmp);
            sb.append(' ');
        }
        if (!StringUtilities.isEmpty(tmp = address.getAreaName1())) {
            sb.append(tmp);
            sb.append(' ');
        }
        if (!StringUtilities.isEmpty(tmp = address.getAreaName2())) {
            sb.append(tmp);
            sb.append(' ');
        }
        if (!StringUtilities.isEmpty(tmp = address.getAreaName3())) {
            sb.append(tmp);
            sb.append(' ');
        }
        if (!StringUtilities.isEmpty(tmp = address.getAreaName4())) {
            sb.append(tmp);
            sb.append(' ');
        }
        if (!StringUtilities.isEmpty(tmp = address.getPostCode1())) {
            sb.append(tmp);
            sb.append(' ');
        }
        tmp = sb.toString();
        for (String key : filters.keySet()) {
            IGeocodeInputFilter filter;
            double score;
            if (!testCountries.contains(key) || !((score = (filter = filters.get(key)).scoreAddressForCountry(address, tmp)) > 0.0) || !(score < FILTER_THRESHHOLD)) continue;
            testCountries.remove(key);
            ++removedCount;
        }
        return removedCount;
    }
}

