/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.multicountry;

import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.core.multicountry.MultiCountryBasicSettings;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class MultiCountryGeocoderHelper {
    private MultiCountryBasicSettings basicSettings;
    private List<String> countryList = new ArrayList<String>();
    private boolean inputCountryValid;
    private GeocodableAddressFactory defaultGeocoderFactory;
    private GeocodableAddressFactory worldGeocoderFactory;
    private static String SEPARATOR_TOKENS = ", ;";
    private Set<String> availableCountries = new HashSet<String>();

    public MultiCountryGeocoderHelper() {
        this.basicSettings = new MultiCountryBasicSettings();
    }

    public MultiCountryGeocoderHelper(MultiCountryBasicSettings basicSettingValues) {
        this.basicSettings = basicSettingValues;
    }

    public List<String> getCountryList() {
        return this.countryList;
    }

    public void setCountryList(List<String> countryList) {
        this.countryList.clear();
        if (countryList != null) {
            this.countryList.addAll(countryList);
        }
    }

    public String getDefaultGeocoderCountryCode() {
        return this.basicSettings.getDefaultGeocoderCountryCode();
    }

    public void setDefaultGeocoderCountryCode(String defaultCode) {
        this.basicSettings.setDefaultGeocoderCountryCode(defaultCode);
    }

    public boolean isInputCountryValid() {
        return this.inputCountryValid;
    }

    public void setInputCountryValid(boolean isValid) {
        this.inputCountryValid = isValid;
    }

    public boolean isReturnOnFirstCloseStreetCandidates() {
        return this.basicSettings.isReturnOnFirstCloseStreetCandidates();
    }

    public void setReturnOnFirstCloseStreetCandidates(boolean returnOnFirstCloseStreetCandidates) {
        this.basicSettings.setReturnOnFirstCloseStreetCandidates(returnOnFirstCloseStreetCandidates);
    }

    public GeocodableAddressFactory getDefaultGeocoderFactory() {
        return this.defaultGeocoderFactory;
    }

    public void setDefaultGeocoderFactory(GeocodableAddressFactory defaultGeocoderFactory) {
        this.defaultGeocoderFactory = defaultGeocoderFactory;
    }

    public GeocodableAddressFactory getWorldGeocoderFactory() {
        return this.worldGeocoderFactory;
    }

    public void setWorldGeocoderFactory(GeocodableAddressFactory factory) {
        this.worldGeocoderFactory = factory;
    }

    public boolean isSearchWorldGeocoderRecommendationsOnly() {
        return this.basicSettings.isSearchWorldGeocoderRecommendationsOnly();
    }

    public void setSearchWorldGeocoderRecommendationsOnly(boolean searchDefaultRecommendationsOnly) {
        this.basicSettings.setSearchWorldGeocoderRecommendationsOnly(searchDefaultRecommendationsOnly);
    }

    public List<String> getPrimaryGeocoderCountryCodes() {
        return this.basicSettings.getPrimaryGeocoderCountryCodes();
    }

    public void setPrimaryGeocoderCountryCodes(String primaryGeocoder) {
        this.basicSettings.setPrimaryGeocoderCountryCodes(primaryGeocoder);
    }

    public void setPrimaryGeocoderCountryCodes(List<String> primaryGeocoder) {
        this.basicSettings.setPrimaryGeocoderCountryCodes(primaryGeocoder);
    }

    public boolean isSearchPreferredCountriesOnly() {
        return this.basicSettings.isSearchPreferredCountriesOnly();
    }

    public void setSearchPreferredCountriesOnly(boolean searchPreferredCountriesOnly) {
        this.basicSettings.setSearchPreferredCountriesOnly(searchPreferredCountriesOnly);
    }

    public List<String> getPreferredCountriesList() {
        return this.basicSettings.getPreferredCountriesList();
    }

    public void setPreferredCountriesList(List<String> preferredCountriesList) {
        this.basicSettings.setPreferredCountriesList(preferredCountriesList);
    }

    public void setExcludedCountriesSet(Set<String> excludedCountriesSet) {
        this.basicSettings.setExcludedCountriesSet(excludedCountriesSet);
    }

    public Set<String> getExcludedCountriesSet() {
        return this.basicSettings.getExcludedCountriesSet();
    }

    public boolean isDetermineCountryByKeyword() {
        return this.basicSettings.isDetermineCountryByKeyword();
    }

    public void setDetermineCountryByKeyword(boolean determineCountryByKeyword) {
        this.basicSettings.setDetermineCountryByKeyword(determineCountryByKeyword);
    }

    public boolean isDetermineCountryByPattern() {
        return this.basicSettings.isDetermineCountryByPattern();
    }

    public void setDetermineCountryByPattern(boolean determineCountryByPattern) {
        this.basicSettings.setDetermineCountryByPattern(determineCountryByPattern);
    }

    public boolean isAllowConstraintsOverride() {
        return this.basicSettings.isAllowConstraintsOverride();
    }

    public void setAllowConstraintsOverride(boolean allowConstraintsOverride) {
        this.basicSettings.setAllowConstraintsOverride(allowConstraintsOverride);
    }

    public boolean isUseWorldGeocoderToDetermineCountry() {
        return this.basicSettings.isUseWorldGeocoderToDetermineCountry();
    }

    public void setUseWorldGeocoderToDetermineCountry(boolean useWorldGeocoderToDetermineCountry) {
        this.basicSettings.setUseWorldGeocoderToDetermineCountry(useWorldGeocoderToDetermineCountry);
    }

    public void applyUserPreferences(IGeocodeConstraints constraints) {
        String testStr;
        StringTokenizer stringTokenizer;
        if (constraints == null) {
            return;
        }
        if (!this.isAllowConstraintsOverride()) {
            return;
        }
        String override = constraints.getCustomString("COUNTRY_FALLBACK_PREFERRED_COUNTRIES");
        if (!StringUtilities.isEmpty(override)) {
            stringTokenizer = new StringTokenizer(override, SEPARATOR_TOKENS);
            ArrayList<String> preferredCountriesList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                preferredCountriesList.add(stringTokenizer.nextToken().toUpperCase());
            }
            this.setPreferredCountriesList(preferredCountriesList);
        }
        override = constraints.getCustomString("COUNTRY_FALLBACK_PREFERRED_COUNTRIES_ONLY", Boolean.toString(this.isSearchPreferredCountriesOnly()));
        this.setSearchPreferredCountriesOnly(Boolean.valueOf(override));
        override = constraints.getCustomString("COUNTRY_FALLBACK_RETURN_ON_FIRST_CLOSE_STREET_CANDIDATES", Boolean.toString(this.isReturnOnFirstCloseStreetCandidates()));
        this.setReturnOnFirstCloseStreetCandidates(Boolean.valueOf(override));
        override = constraints.getCustomString("COUNTRY_FALLBACK_WORLD_GEOCODER_SUGGESTIONS_ONLY", Boolean.toString(this.isSearchWorldGeocoderRecommendationsOnly()));
        this.setSearchWorldGeocoderRecommendationsOnly(Boolean.valueOf(override));
        override = constraints.getCustomString("COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_KEYWORD", Boolean.toString(this.isDetermineCountryByKeyword()));
        this.setDetermineCountryByKeyword(Boolean.valueOf(override));
        override = constraints.getCustomString("COUNTRY_FALLBACK_DETERMINE_COUNTRY_BY_PATTERN", Boolean.toString(this.isDetermineCountryByPattern()));
        this.setDetermineCountryByPattern(Boolean.valueOf(override));
        override = constraints.getCustomString("COUNTRY_FALLBACK_USE_WORLD_GEOCODER_TO_SUGGEST_COUNTRY", Boolean.toString(this.isUseWorldGeocoderToDetermineCountry()));
        this.setUseWorldGeocoderToDetermineCountry(Boolean.valueOf(override));
        override = constraints.getCustomString("COUNTRY_FALLBACK_PRIMARY_GEOCODER");
        if (!StringUtilities.isEmpty(override)) {
            stringTokenizer = new StringTokenizer(override, SEPARATOR_TOKENS);
            ArrayList<String> primaryCountriesList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                primaryCountriesList.add(stringTokenizer.nextToken().toUpperCase());
            }
            this.setPrimaryGeocoderCountryCodes(primaryCountriesList);
        }
        if ((testStr = constraints.getCustomString("COUNTRY_FALLBACK_EXCLUDED_COUNTRIES")) != null) {
            HashSet<String> excludeSet = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(testStr, SEPARATOR_TOKENS);
            while (st.hasMoreTokens()) {
                excludeSet.add(st.nextToken().toUpperCase());
            }
            this.basicSettings.setExcludedCountriesSet(excludeSet);
        }
    }

    public Set<String> getAvailableCountries() {
        return this.availableCountries;
    }

    public void setAvailableCountries(Set<String> availableCountries) {
        this.availableCountries = availableCountries;
    }
}

