/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.postal;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.postal.ICorePostalGeocoder;
import com.mapinfo.mapmarker.core.postal.IPostalGeocoder;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.Iterator;
import java.util.List;

public final class CorePostalGeocoder
implements IPostalGeocoder {
    private static String lineSeparator = System.getProperty("line.separator");

    @Override
    public GeocodeResult geocodePostal(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        GeocodeResult geocodeResult = new GeocodeResult();
        if (constraints.getHandler().getParsedAddressArray() == null) {
            return geocodeResult;
        }
        IHandler handler = constraints.getHandler();
        handler.getLocalConstraintsHelper().addLocalPostalConstraints(constraints, handler);
        IRetrievedCandidates candidates = handler.getDataManager().retrievePostalCentroids(handler.getParsedAddress(), constraints);
        List matchResults = null;
        if (candidates.getCandidates() != null && candidates.getCandidates().size() != 0) {
            matchResults = ((ICorePostalGeocoder)((Object)handler)).getPostalMatcher().matchPostal(constraints, handler.getParsedAddress(), candidates);
            if (DebugLevel.getDebugLevel(1) >= 2) {
                MMJLog.getLog().debug("Candidates after matching: ");
                this.printCandidateInfo(candidates);
            }
        }
        geocodeResult.setDataLicensed(candidates.getDataLicensed());
        this.countCandidates(matchResults, geocodeResult);
        this.countCloseMatches(matchResults, geocodeResult);
        handler.setGeocodeResult(geocodeResult);
        handler.setMatchResults(matchResults);
        if (geocodeResult.getNumberCloseCandidates() > 0) {
            List sortedMatchResults = ((ICorePostalGeocoder)((Object)handler)).getPostalCentroidFilter().filterPostalCloseMatches(handler);
            this.countCandidates(sortedMatchResults, geocodeResult);
            this.countCloseMatches(sortedMatchResults, geocodeResult);
            handler.setGeocodeResult(geocodeResult);
            handler.setMatchResults(sortedMatchResults);
        }
        return geocodeResult;
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }

    private void printCandidateInfo(IRetrievedCandidates candidates) {
        if (candidates.getCandidates() != null && !candidates.getCandidates().isEmpty()) {
            List candidatesList = candidates.getCandidates();
            for (ICandidate thisOne : candidatesList) {
                MMJLog.getLog().debug(thisOne.toString());
                MMJLog.getLog().debug(lineSeparator);
            }
        } else {
            MMJLog.getLog().debug("No Candidates.");
        }
    }
}

