/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.reverseGeocode;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.dp.IReverseGeocodeDataManager;
import com.mapinfo.mapmarker.core.reverseGeocode.CoreEmptyReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.core.reverseGeocode.ICustomReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeHandler;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;

public class CoreReverseGeocodeHandler
implements IReverseGeocodeHandler {
    private static final CoordSys CORE_DEFAULT_COORDSYS = CoordSysConstants.longLatWGS84;
    private final IConstraints m_constraints;
    private final CoordSys m_defaultCoordSys;
    private IReverseGeocodeSubHandler m_standardSubHandler;
    private IReverseGeocodeSubHandler m_geographicSubHandler = new CoreEmptyReverseGeocodeSubHandler();
    private IReverseGeocodeSubHandler m_postalSubHandler = new CoreEmptyReverseGeocodeSubHandler();
    private ICustomReverseGeocodeSubHandler m_customSubHandler;
    private IReverseGeocodeDataManager m_dataManager;

    public CoreReverseGeocodeHandler(IConstraints constraints) {
        this(constraints, CORE_DEFAULT_COORDSYS);
    }

    public CoreReverseGeocodeHandler(IConstraints constraints, CoordSys defaultCoordSys) {
        this.m_constraints = constraints;
        this.m_defaultCoordSys = defaultCoordSys;
    }

    @Override
    public IConstraints getConstraints() {
        return this.m_constraints;
    }

    public void setStandardSubHandler(IReverseGeocodeSubHandler subHandler) {
        this.m_standardSubHandler = subHandler;
    }

    @Override
    public IReverseGeocodeSubHandler getStandardSubHandler() {
        return this.m_standardSubHandler;
    }

    public void setGeographicSubHandler(IReverseGeocodeSubHandler subHandler) {
        this.m_geographicSubHandler = subHandler;
    }

    @Override
    public IReverseGeocodeSubHandler getGeographicSubHandler() {
        return this.m_geographicSubHandler;
    }

    public void setPostalSubHandler(IReverseGeocodeSubHandler subHandler) {
        this.m_postalSubHandler = subHandler;
    }

    @Override
    public IReverseGeocodeSubHandler getPostalSubHandler() {
        return this.m_postalSubHandler;
    }

    public void setCustomSubHandler(ICustomReverseGeocodeSubHandler subHandler) {
        this.m_customSubHandler = subHandler;
    }

    @Override
    public ICustomReverseGeocodeSubHandler getCustomSubHandler() {
        return this.m_customSubHandler;
    }

    public void setDataManager(IReverseGeocodeDataManager dataManager) {
        this.m_dataManager = dataManager;
    }

    @Override
    public IReverseGeocodeDataManager getDataManager() {
        return this.m_dataManager;
    }

    @Override
    public void release() {
    }

    @Override
    public com.mapinfo.coordsys.CoordSys getDefaultCoordSys() {
        if (this.m_defaultCoordSys == null) {
            return null;
        }
        return MidevConversionUtils.getLegacyCoordSys(this.m_defaultCoordSys);
    }

    @Override
    public CoordSys getDefaultCoordSysObject() {
        return this.m_defaultCoordSys;
    }
}

