/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.reverseGeocode;

import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.IReverseGeocodeCandidate;
import com.mapinfo.mapmarker.common.dp.IReverseGeocodeDataManager;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Deprecated
public class CoreStandardReverseGeocodeSubHandler
implements IReverseGeocodeSubHandler {
    private static Comparator<? super ReverseGeocodeCandidateAddress> CAND_COMPARATOR = new RGCandComparator();

    @Override
    public ReverseGeocodeResponse reverseGeocode(ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        IReverseGeocodeDataManager data = constraints.getHandler().getDataManager();
        IRetrievedCandidates retrievedCands = data.retrieveReverseGeocodeCandidates(location, constraints.getHandler().getConstraints());
        if (retrievedCands.getCandidates().size() == 0 && !retrievedCands.getDataLicensed()) {
            ReverseGeocodeResponse response = new ReverseGeocodeResponse(null);
            response.setDataLicensed(false);
            return response;
        }
        List<ReverseGeocodeCandidateAddress> returnCandidates = this.filterCandidates(location, constraints, retrievedCands.getCandidates());
        this.sortCandidates(returnCandidates);
        return this.createResponse(returnCandidates);
    }

    protected void sortCandidates(List<ReverseGeocodeCandidateAddress> candidatesToSort) {
        if (candidatesToSort != null) {
            Collections.sort(candidatesToSort, CAND_COMPARATOR);
        }
    }

    protected List<ReverseGeocodeCandidateAddress> filterCandidates(ReverseGeocodeLocation originalLocation, IReverseGeocodeInternalConstraints constraints, List<IReverseGeocodeCandidate> allCandidates) throws MapMarkerInternalException {
        double maxDist = originalLocation.getDistanceAsLength().getValue(LinearUnit.METER);
        ArrayList<ReverseGeocodeCandidateAddress> returnCandidates = new ArrayList<ReverseGeocodeCandidateAddress>(1);
        List<IReverseGeocodeCandidate> filteredCandidates = new ArrayList<IReverseGeocodeCandidate>();
        IReverseGeocodeCandidate lastCandidate = null;
        for (IReverseGeocodeCandidate candidate : allCandidates) {
            if (candidate.getDistance() > maxDist) break;
            if (lastCandidate == null) {
                lastCandidate = candidate;
            } else if (candidate.getDistance() > lastCandidate.getDistance()) break;
            candidate.matchAddressNumber(originalLocation, constraints);
            filteredCandidates.add(candidate);
        }
        filteredCandidates = this.filterBasedOnStreetSide(filteredCandidates, originalLocation, constraints);
        for (IReverseGeocodeCandidate candidate : filteredCandidates) {
            returnCandidates.add(candidate.toCandidateAddress(originalLocation, constraints));
        }
        return returnCandidates;
    }

    private List<IReverseGeocodeCandidate> filterBasedOnStreetSide(List<IReverseGeocodeCandidate> candidates, ReverseGeocodeLocation originalLocation, IReverseGeocodeInternalConstraints constraints) {
        if (candidates.size() <= 1) {
            return candidates;
        }
        ArrayList<IReverseGeocodeCandidate> filteredCandidates = new ArrayList<IReverseGeocodeCandidate>(candidates.size());
        for (IReverseGeocodeCandidate candidate : candidates) {
            if (!candidate.isFromCorrectStreetSide(originalLocation, constraints)) continue;
            filteredCandidates.add(candidate);
        }
        if (filteredCandidates.isEmpty()) {
            return candidates;
        }
        return filteredCandidates;
    }

    protected ReverseGeocodeResponse createResponse(List<ReverseGeocodeCandidateAddress> sortedCandidates) {
        return new ReverseGeocodeResponse(sortedCandidates);
    }

    private static class RGCandComparator
    implements Comparator<ReverseGeocodeCandidateAddress> {
        private RGCandComparator() {
        }

        @Override
        public int compare(ReverseGeocodeCandidateAddress o1, ReverseGeocodeCandidateAddress o2) {
            int compare = this.compareWithNullHandling((Comparable)((Object)o1.getMainAddress()), (Object)o2.getMainAddress());
            if (compare != 0) {
                return compare;
            }
            compare = this.compareWithReverseNullHandling(o1.getParsedAddressNumber(), o2.getParsedAddressNumber());
            if (compare != 0) {
                return compare;
            }
            compare = this.compareWithNullHandling((Comparable)((Object)o1.getUnitType()), (Object)o2.getUnitType());
            if (compare != 0) {
                return compare;
            }
            compare = this.compareWithNullHandling((Comparable)((Object)o1.getUnitValue()), (Object)o2.getUnitValue());
            if (compare != 0) {
                return compare;
            }
            return 0;
        }

        private <T> int compareWithNullHandling(Comparable<T> s1, T s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }

        private <T> int compareWithReverseNullHandling(Comparable<T> s1, T s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }
}

