/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.reverseGeocode;

import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.core.reverseGeocode.ICustomReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeHandler;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.core.reverseGeocode.MMGeneralReverseGeocodeException;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeHandlerFactory;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;

public class MMJReverseGeocoder {
    private String m_country;
    private ReverseGeocodeLocation m_location;
    protected static final int TYPE_GEOGRAPHIC = 1;
    protected static final int TYPE_POSTAL = 2;
    protected static final String FALLBACK_GEOCODER = "XWG";

    public MMJReverseGeocoder(String country) {
        this.m_country = country;
    }

    public MMJReverseGeocoder(ReverseGeocodeLocation location) {
        this.m_location = new ReverseGeocodeLocation(location.getPositionPoint(), location.getCoordSysObject(), location.getDistanceAsLength());
    }

    public ReverseGeocodeResponse reverseGeocode(int reverseGeocodeType, ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (StringUtilities.equalStringsIgnoreCase(FALLBACK_GEOCODER, this.m_country) && constraints != null && constraints.getCustomString("XWG_NOT_CONFIGURED") != null) {
            return new ReverseGeocodeResponse(Collections.EMPTY_LIST);
        }
        IReverseGeocodeHandler handler = ReverseGeocodeHandlerFactory.getHandler(this.m_country, constraints);
        ReverseGeocodeResponse response = null;
        response = handler == null ? new ReverseGeocodeResponse(new ArrayList<ReverseGeocodeCandidateAddress>()) : this.performReverseGeocode(reverseGeocodeType, location, constraints, handler);
        if (response != null && response.candidateCount() == 0 && constraints != null && (constraints.isFallbackToGeographic() || constraints.isFallbackToPostal())) {
            MMJReverseGeocoder fallbackGeocoder = this;
            IReverseGeocodeHandler fallbackHandler = handler;
            if (constraints.getCustomString("XWG_NOT_CONFIGURED") != null) {
                return response;
            }
            if (!FALLBACK_GEOCODER.equalsIgnoreCase(this.m_country)) {
                fallbackGeocoder = new MMJReverseGeocoder(FALLBACK_GEOCODER);
                fallbackHandler = ReverseGeocodeHandlerFactory.getHandler(FALLBACK_GEOCODER, constraints);
                if (fallbackHandler == null) {
                    if (handler == null) {
                        throw new MMGeneralReverseGeocodeException(3000, new String[]{this.m_country == null ? this.m_country : this.m_country.toUpperCase()});
                    }
                    return response;
                }
            }
            if (constraints.isFallbackToGeographic()) {
                return fallbackGeocoder.performReverseGeocode(1, location, constraints, fallbackHandler);
            }
            return fallbackGeocoder.performReverseGeocode(2, location, constraints, fallbackHandler);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReverseGeocodeResponse performReverseGeocode(int reverseGeocodeType, ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints, IReverseGeocodeHandler handler) throws MMGeneralReverseGeocodeException, MapMarkerInternalException, MMInternalFatalException {
        if (location.getCoordSysObject() == null) {
            location.setCoordSys(handler.getDefaultCoordSysObject());
        }
        handler.getConstraints().setDictionarySearchOrder(constraints.getDictionarySearchOrder());
        constraints.setHandler(handler);
        try {
            IReverseGeocodeSubHandler subHandler;
            switch (reverseGeocodeType) {
                case 0: {
                    subHandler = handler.getStandardSubHandler();
                    break;
                }
                case 1: {
                    subHandler = handler.getGeographicSubHandler();
                    break;
                }
                case 2: {
                    subHandler = handler.getPostalSubHandler();
                    break;
                }
                default: {
                    if (reverseGeocodeType < 100) {
                        throw new MMGeneralReverseGeocodeException(3001, new String[]{String.valueOf(reverseGeocodeType)});
                    }
                    ICustomReverseGeocodeSubHandler customSubHandler = handler.getCustomSubHandler();
                    if (customSubHandler == null) {
                        throw new MMGeneralReverseGeocodeException(3001, new String[]{String.valueOf(reverseGeocodeType)});
                    }
                    ReverseGeocodeResponse reverseGeocodeResponse = customSubHandler.reverseGeocode(reverseGeocodeType, location, constraints);
                    return reverseGeocodeResponse;
                }
            }
            if (subHandler == null) {
                throw new MMGeneralReverseGeocodeException(3001, new String[]{String.valueOf(reverseGeocodeType)});
            }
            ReverseGeocodeResponse reverseGeocodeResponse = subHandler.reverseGeocode(location, constraints);
            return reverseGeocodeResponse;
        }
        finally {
            handler.release();
        }
    }
}

