/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.reverseGeocode;

import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeHandler;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.core.reverseGeocode.MMGeneralReverseGeocodeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ReverseGeocodeHandlerFactory {
    private static final String PACKAGE = "com.mapinfo.mapmarker.";
    private static final String SUB_PACKAGE = ".reverseGeocode.";
    private static final String CLASS_BASE = "_ReverseGeocodeHandlerFactory";
    private static final String CGGE_CLASS_HEADER = "CGGE";
    private static Map<String, Class<ReverseGeocodeHandlerFactory>> FACTORY_MAP = new ConcurrentHashMap<String, Class<ReverseGeocodeHandlerFactory>>();

    public static IReverseGeocodeHandler getHandler(String country, IReverseGeocodeInternalConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (country != null) {
            country = country.toUpperCase();
        } else if (constraints != null && (constraints.isFallbackToGeographic() || constraints.isFallbackToPostal())) {
            country = "";
        } else {
            throw new MMGeneralReverseGeocodeException(3000, new String[]{country});
        }
        Class<ReverseGeocodeHandlerFactory> factoryClass = FACTORY_MAP.get(country);
        if (factoryClass == null) {
            factoryClass = ReverseGeocodeHandlerFactory.createFactoryClass(country);
            FACTORY_MAP.put(country, factoryClass);
        }
        try {
            if (factoryClass.getName().endsWith("CGGE_ReverseGeocodeHandlerFactory")) {
                ReverseGeocodeHandlerFactory factoryHandler = ReverseGeocodeHandlerFactory.setCountryToCGGEReverseGeocodeHandler(country, factoryClass);
                boolean countrySupported = false;
                try {
                    countrySupported = factoryHandler.isCountrySupported();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (countrySupported) {
                    return factoryHandler.getCountryHandler(constraints);
                }
                if ("XWG".equalsIgnoreCase(country) || constraints != null && (constraints.isFallbackToGeographic() || constraints.isFallbackToPostal())) {
                    return null;
                }
                throw new MMGeneralReverseGeocodeException(3000, new String[]{country});
            }
            return factoryClass.newInstance().getCountryHandler(constraints);
        }
        catch (InstantiationException IEx) {
            throw new MMGeneralReverseGeocodeException(3000, new String[]{country}, IEx);
        }
        catch (IllegalAccessException IAEx) {
            throw new MMGeneralReverseGeocodeException(3000, new String[]{country}, IAEx);
        }
    }

    private static ReverseGeocodeHandlerFactory setCountryToCGGEReverseGeocodeHandler(String country, Class<ReverseGeocodeHandlerFactory> factoryClass) throws IllegalAccessException, MMGeneralReverseGeocodeException {
        ReverseGeocodeHandlerFactory instance = null;
        Method[] classMethod = factoryClass.getDeclaredMethods();
        for (int i = 0; i < classMethod.length; ++i) {
            String methodName = classMethod[i].getName();
            if (!methodName.equals("setCountry")) continue;
            try {
                instance = factoryClass.newInstance();
                classMethod[i].invoke((Object)instance, country);
                continue;
            }
            catch (InvocationTargetException e) {
                throw new MMGeneralReverseGeocodeException(3000, new String[]{country}, e);
            }
            catch (InstantiationException e) {
                throw new MMGeneralReverseGeocodeException(3000, new String[]{country}, e);
            }
        }
        return instance;
    }

    private static Class<ReverseGeocodeHandlerFactory> createFactoryClass(String country) throws MapMarkerInternalException {
        try {
            return Class.forName(PACKAGE + country + SUB_PACKAGE + country + CLASS_BASE);
        }
        catch (ClassNotFoundException CNFEx) {
            try {
                return Class.forName(PACKAGE + CGGE_CLASS_HEADER.toLowerCase() + SUB_PACKAGE + CGGE_CLASS_HEADER + CLASS_BASE);
            }
            catch (ClassNotFoundException CGGECNFEx) {
                throw new MMGeneralReverseGeocodeException(3000, new String[]{country}, CGGECNFEx);
            }
        }
    }

    protected abstract IReverseGeocodeHandler getCountryHandler(IReverseGeocodeInternalConstraints var1) throws MapMarkerInternalException, MMInternalFatalException;

    public boolean isCountrySupported() throws MMGeneralReverseGeocodeException {
        return false;
    }
}

