/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressSplit;

public class AddressSplit
implements IAddressSplit {
    private final Address m_split;
    private final boolean m_fromDelimited;
    private final boolean m_fromReverseSplit;

    public AddressSplit(Address split) {
        this(split, false, false);
    }

    public AddressSplit(Address split, boolean fromDelimited, boolean fromReverseSplit) {
        this.m_split = split;
        this.m_fromDelimited = fromDelimited;
        this.m_fromReverseSplit = fromReverseSplit;
    }

    @Override
    public Address getAddress() {
        return this.m_split;
    }

    @Override
    public boolean isFromDelimited() {
        return this.m_fromDelimited;
    }

    @Override
    public boolean isFromReverseSplit() {
        return this.m_fromReverseSplit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[AddressSplit-");
        if (this.m_fromDelimited) {
            sb.append("<delmited>");
        }
        if (this.m_fromReverseSplit) {
            sb.append("<reverse>");
        }
        sb.append(" input main: {");
        sb.append(this.m_split.getMainAddress());
        sb.append("} input post: {");
        sb.append(this.m_split.getPostAddress());
        sb.append("}]");
        return sb.toString();
    }
}

