/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.singleline.eval;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.core.singleline.SingleLineResult;
import com.mapinfo.mapmarker.core.singleline.eval.SingleLineEvalUtils;
import java.util.Comparator;

public class GeographicPreferenceRule
implements Comparator<SingleLineResult> {
    @Override
    public int compare(SingleLineResult o1, SingleLineResult o2) {
        try {
            boolean isG2_2;
            boolean isG3orG4_2;
            CandidateAddress cand1 = SingleLineEvalUtils.getTopCandOrNull(o1);
            CandidateAddress cand2 = SingleLineEvalUtils.getTopCandOrNull(o2);
            if (cand1 == null || cand2 == null) {
                return 0;
            }
            int prec1 = cand1.getLocationPrecision();
            int prec2 = cand2.getLocationPrecision();
            if (!this.isGeographic(prec1) || !this.isGeographic(prec2)) {
                return 0;
            }
            boolean isG3orG4_1 = prec1 == 10 || prec1 == 11;
            boolean bl = isG3orG4_2 = prec2 == 10 || prec2 == 11;
            if (isG3orG4_1 && !isG3orG4_2) {
                return -1;
            }
            if (!isG3orG4_1 && isG3orG4_2) {
                return 1;
            }
            boolean isG2_1 = prec1 == 9;
            boolean bl2 = isG2_2 = prec2 == 9;
            if (isG2_1 && !isG2_2) {
                return -1;
            }
            if (!isG2_1 && isG2_2) {
                return 1;
            }
            boolean matchedFlags1 = this.checkMatchedFlag(cand1);
            boolean matchedFlags2 = this.checkMatchedFlag(cand2);
            if (matchedFlags1 && !matchedFlags2) {
                return -1;
            }
            if (!matchedFlags1 && matchedFlags2) {
                return 1;
            }
            return 0;
        }
        catch (MapMarkerInternalException e) {
            return 0;
        }
    }

    private boolean checkMatchedFlag(CandidateAddress cand) {
        if (cand.getLocationPrecision() == 8) {
            return cand.doesAreaName1Match();
        }
        if (cand.getLocationPrecision() == 9) {
            return cand.doesAreaName2Match();
        }
        if (cand.getLocationPrecision() == 10) {
            return cand.doesAreaName3Match();
        }
        if (cand.getLocationPrecision() == 11) {
            return cand.doesAreaName4Match();
        }
        return false;
    }

    private boolean isGeographic(int precision) {
        switch (precision) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }
}

