/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.singleline.eval;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.core.singleline.SingleLineResult;
import com.mapinfo.mapmarker.core.singleline.eval.SingleLineEvalUtils;
import java.util.Comparator;

public class MixedPostalGeographicRule
implements Comparator<SingleLineResult> {
    @Override
    public int compare(SingleLineResult o1, SingleLineResult o2) {
        try {
            CandidateAddress cand1 = SingleLineEvalUtils.getTopCandOrNull(o1);
            CandidateAddress cand2 = SingleLineEvalUtils.getTopCandOrNull(o2);
            if (cand1 == null || cand2 == null) {
                return 0;
            }
            int prec1 = cand1.getLocationPrecision();
            int prec2 = cand2.getLocationPrecision();
            boolean isPostal1 = this.isPostal(prec1);
            boolean isPostal2 = this.isPostal(prec2);
            boolean isGeographic1 = this.isGeographic(prec1);
            boolean isGeographic2 = this.isGeographic(prec2);
            if (!isPostal1 && !isGeographic1 || !isPostal2 && !isGeographic2) {
                return 0;
            }
            if (isPostal1 && isPostal2 || isGeographic1 && isGeographic2) {
                return 0;
            }
            if (!(o1.getConstraints().getHandler() instanceof ICoreAddressGeocoder)) {
                return 0;
            }
            boolean preferPostal = ((ICoreAddressGeocoder)((Object)o1.getConstraints().getHandler())).preferPostalFallBack();
            if (preferPostal && isPostal1) {
                return -1;
            }
            if (!preferPostal && !isPostal1) {
                return -1;
            }
            return 1;
        }
        catch (MapMarkerInternalException e) {
            return 0;
        }
    }

    private boolean isPostal(int precision) {
        switch (precision) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private boolean isGeographic(int precision) {
        switch (precision) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }
}

