/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.singleline.eval;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.core.singleline.SingleLineResult;
import com.mapinfo.mapmarker.core.singleline.eval.SingleLineEvalUtils;
import java.util.Comparator;

public class StreetPreferenceRule
implements Comparator<SingleLineResult> {
    @Override
    public int compare(SingleLineResult o1, SingleLineResult o2) {
        try {
            boolean isS42;
            boolean isSX2;
            CandidateAddress cand1 = SingleLineEvalUtils.getTopCandOrNull(o1);
            CandidateAddress cand2 = SingleLineEvalUtils.getTopCandOrNull(o2);
            if (cand1 == null || cand2 == null) {
                return 0;
            }
            int prec1 = cand1.getLocationPrecision();
            int prec2 = cand2.getLocationPrecision();
            if (!this.isStreet(prec1) || !this.isStreet(prec2)) {
                return 0;
            }
            boolean isSX1 = prec1 == 6;
            boolean bl = isSX2 = prec2 == 6;
            if (isSX1 && !isSX2) {
                return -1;
            }
            if (!isSX1 && isSX2) {
                return 1;
            }
            boolean isAP1 = this.isAddressPoint(prec1);
            boolean isAP2 = this.isAddressPoint(prec2);
            if (isAP1 && !isAP2) {
                return -1;
            }
            if (!isAP1 && isAP2) {
                return 1;
            }
            boolean isS41 = prec1 == 2;
            boolean bl2 = isS42 = prec2 == 2;
            if (isS41 && !isS42) {
                return 1;
            }
            if (!isS41 && isS42) {
                return -1;
            }
            return 0;
        }
        catch (MapMarkerInternalException e) {
            return 0;
        }
    }

    private boolean isAddressPoint(int precision) {
        switch (precision) {
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    private boolean isStreet(int precision) {
        switch (precision) {
            case 1: 
            case 2: 
            case 6: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }
}

