/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.standardize;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.IStandardizeCandidate;
import com.mapinfo.mapmarker.core.standardize.ICoreStandardizeGeocoder;
import com.mapinfo.mapmarker.core.standardize.IStandardizeGeocoder;
import java.util.ArrayList;

public final class CoreStandardizeGeocoder
implements IStandardizeGeocoder {
    @Override
    public GeocodeResult standardize(IConstraints preferences) throws MapMarkerInternalException {
        GeocodeResult geocodeResult = new GeocodeResult();
        IHandler handler = preferences.getHandler();
        if (handler.getParsedAddressArray() == null) {
            return geocodeResult;
        }
        if (handler.isParsedIntersection()) {
            geocodeResult.setIntersectionStatus(true);
        }
        ArrayList<IStandardizeCandidate> matchResults = new ArrayList<IStandardizeCandidate>();
        IStandardizeCandidate candidate = ((ICoreStandardizeGeocoder)((Object)handler)).getStandardizeHelper().buildStandardizeCandidate(handler.getParsedAddress());
        candidate.setInputAddress(handler.getInputAddress());
        matchResults.add(candidate);
        handler.setMatchResults(matchResults);
        geocodeResult.setNumberCandidates(1);
        geocodeResult.setNumberCloseCandidates(0);
        handler.setGeocodeResult(geocodeResult);
        return geocodeResult;
    }
}

