/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.generic.soundex;

import com.mapinfo.mapmarker.generic.soundex.ExtendedCharacters;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class SoundexHelper {
    private String CHAR_STRING = "A,E,H,I,O,U,W,Y,B,F,P,V,C,G,J,K,Q,S,X,Z,D,T,L,M,N,R";
    private final int SPECIAL_CASE_INITIALDIGIT = 1;
    private final int MAX_SOUNDEX_KEY_LENGTH = 8;
    private ExtendedCharacters m_extendedCharactersHelper = null;
    private Map m_SimilarSoundsWordsMap = new HashMap();
    private Properties m_Properties;
    private char[] m_LettersArray;
    private int[] m_SoundsArray;
    private String m_ValidCodes;
    private String m_CharString;
    private String m_SoundString;
    private Map m_SoundHash;
    private String[] m_Ignored_Word_Array;
    private List m_CharacterList = new ArrayList();

    public void setExtendedCharacters(ExtendedCharacters extenCharacters) {
        this.m_extendedCharactersHelper = extenCharacters;
    }

    public String getNormalCharacter(char c) {
        if (this.m_extendedCharactersHelper == null) {
            return new Character(c).toString();
        }
        return this.m_extendedCharactersHelper.getNormalReplacementCharacter(c);
    }

    public int getSpecialCaseInitialDigit() {
        return 1;
    }

    public int getMaxSoundexKeyLength() {
        return 8;
    }

    public String getValidCodes() {
        return this.m_ValidCodes;
    }

    public String getCharString() {
        return this.m_CharString;
    }

    public String getSoundString() {
        return this.m_SoundString;
    }

    public String[] getIgnored_Word_Array() {
        return this.m_Ignored_Word_Array;
    }

    public Map getSoundHash() {
        return this.m_SoundHash;
    }

    public Properties getSoundexProperties() {
        return this.m_Properties;
    }

    public Map getSimilarSoundsWordsMap() {
        return this.m_SimilarSoundsWordsMap;
    }

    protected void loadPropertyFile(String fileToBeLoaded) {
        try {
            this.m_SoundHash = new Hashtable();
            this.m_Properties = new Properties();
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(fileToBeLoaded);
            this.m_Properties.load(stream);
            String key = null;
            Enumeration<Object> enumeration = this.m_Properties.keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                if (key.equalsIgnoreCase("LETTERS_KEY")) {
                    this.m_LettersArray = this.loadLetters(key, this.m_Properties);
                    continue;
                }
                if (key.equalsIgnoreCase("SOUNDS_KEY")) {
                    this.m_SoundsArray = this.loadSounds(key, this.m_Properties);
                    continue;
                }
                if (key.equalsIgnoreCase("IGNORED_WORD_LIST_KEY")) {
                    this.loadIgnoredWordList(key);
                    continue;
                }
                if (!key.startsWith("SIMILAR_SOUND_KEY_")) continue;
                this.fillSimilarSoundWordsMap(key, this.m_Properties.getProperty(key));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load the property file " + fileToBeLoaded);
        }
        catch (RuntimeException rex) {
            throw new RuntimeException("Unable to find the property file " + fileToBeLoaded);
        }
    }

    protected void fillSimilarSoundWordsMap(String key, String value) {
        String normalCharacter = key.replaceAll("SIMILAR_SOUND_KEY_", "");
        this.m_SimilarSoundsWordsMap.put(normalCharacter, value);
    }

    protected void loadSoundsMap() {
        if (this.m_LettersArray != null) {
            for (int j = 0; j < this.m_LettersArray.length; ++j) {
                this.m_SoundHash.put(new Character(this.m_LettersArray[j]), new Integer(this.m_SoundsArray[j]));
            }
            this.m_SoundString = this.calculateSoundsString(this.m_SoundHash, this.m_CharacterList);
        }
    }

    protected void loadIgnoredWordList(String key) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_Properties.getProperty(key), ",");
        ArrayList<String> list = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        this.m_Ignored_Word_Array = new String[list.size()];
        list.toArray(this.m_Ignored_Word_Array);
    }

    protected int[] loadSounds(String key, Properties properties) {
        String sounds = properties.getProperty(key);
        String[] intermediateSoundsArray = sounds.split(",");
        int[] soundsArray = new int[intermediateSoundsArray.length];
        for (int i = 0; i < intermediateSoundsArray.length; ++i) {
            soundsArray[i] = Integer.parseInt(intermediateSoundsArray[i].trim());
        }
        this.m_ValidCodes = this.calculateValidCodes(soundsArray);
        return soundsArray;
    }

    protected char[] loadLetters(String key, Properties properties) {
        String letters = properties.getProperty(key);
        StringTokenizer tokens = new StringTokenizer(letters, ",");
        StringBuffer buffer = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            buffer.append(tokens.nextToken());
        }
        char[] charArray = buffer.toString().toCharArray();
        this.m_CharString = this.makeCharString(charArray);
        return charArray;
    }

    protected String calculateValidCodes(int[] soundsArray) {
        ArrayList<String> soundString = new ArrayList<String>();
        StringBuffer validCodes = new StringBuffer();
        String tempValue = null;
        int[] tempSoundArray = this.getSortedArray(soundsArray);
        for (int i = 0; i < tempSoundArray.length; ++i) {
            tempValue = String.valueOf(tempSoundArray[i]);
            if (soundString.contains(tempValue) || "0".equals(tempValue)) continue;
            validCodes.append(tempSoundArray[i]);
            soundString.add(tempValue);
        }
        return validCodes.toString();
    }

    protected String makeCharString(char[] characterArray) {
        StringBuffer charString = new StringBuffer();
        char recentCharacter = '\u0000';
        for (int i = 0; i < characterArray.length; ++i) {
            recentCharacter = characterArray[i];
            if (recentCharacter >= 'A' && recentCharacter <= '[') continue;
            charString.append(recentCharacter);
            this.m_CharacterList.add(String.valueOf(recentCharacter));
        }
        StringTokenizer tokens = new StringTokenizer(this.CHAR_STRING, ",");
        while (tokens.hasMoreTokens()) {
            this.m_CharacterList.add(tokens.nextElement());
        }
        charString.append(this.CHAR_STRING.replaceAll(",", ""));
        return charString.toString();
    }

    protected String calculateSoundsString(Map soundsMap, List characterList) {
        StringBuffer buffer = new StringBuffer();
        int listSize = characterList.size();
        for (int i = 0; i < listSize; ++i) {
            buffer.append(soundsMap.get(new Character(((String)characterList.get(i)).charAt(0))));
        }
        return buffer.toString();
    }

    private int[] getSortedArray(int[] soundsArray) {
        int[] tempSoundArray = new int[soundsArray.length];
        for (int i = 0; i < tempSoundArray.length; ++i) {
            tempSoundArray[i] = soundsArray[i];
        }
        Arrays.sort(tempSoundArray);
        return tempSoundArray;
    }
}

