/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.schema;

import com.mapinfo.mapmarker.schema.MissingSchemaException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SchemaValidator {
    private final Validator m_validator;

    private SchemaValidator(String schemaFileName) throws SAXException, URISyntaxException, MissingSchemaException {
        URL schemaFileURL = Thread.currentThread().getContextClassLoader().getResource(schemaFileName);
        if (schemaFileURL == null) {
            throw new MissingSchemaException(schemaFileName);
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaFileURL);
        this.m_validator = schema.newValidator();
    }

    public static SchemaValidator getInstance(String schemaFileName) throws SAXException, URISyntaxException, MissingSchemaException {
        return new SchemaValidator(schemaFileName);
    }

    public void validate(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        this.validate(builder.parse(is));
    }

    public void validate(Document doc) throws IOException, SAXException {
        this.m_validator.validate(new DOMSource(doc));
    }
}

