/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.GUIDGen;
import java.util.HashMap;

class ClientRequestContainer {
    private final String m_transactionID;
    private final IGeocodeConstraints m_defaultConstraints;
    private static final String ILLEGAL_XML_CHARS = "[^\\u0009\\u000a\\u000d\\u0020-\\ud7ff\\e0000-\\ufffd\\u10000-\\u10ffff]";
    private final ClientRequest m_request;

    protected ClientRequestContainer(Address address, IGeocodeConstraints defaultConstraints) {
        address.setAddressID(GUIDGen.getGUID());
        this.m_defaultConstraints = defaultConstraints;
        this.m_request = new ClientRequest(address);
        this.m_transactionID = GUIDGen.getGUID();
    }

    protected String getID() {
        return this.m_transactionID;
    }

    protected IGeocodeConstraints getDefaultConstraints() {
        return this.m_defaultConstraints;
    }

    protected ClientRequest[] getRequests() {
        return new ClientRequest[]{this.m_request};
    }

    protected static class ClientRequest {
        private final Address m_address;
        private final IGeocodeConstraints m_gc;

        private ClientRequest(Address address) {
            this(address, (IGeocodeConstraints)null);
        }

        private ClientRequest(Address address, IGeocodeConstraints gc) {
            if (address == null) {
                throw new IllegalArgumentException();
            }
            this.stripAddress(address);
            this.m_address = address;
            this.m_gc = gc;
        }

        protected Address getAddress() {
            return this.m_address;
        }

        protected IGeocodeConstraints getConstraints() {
            return this.m_gc;
        }

        private void stripAddress(Address addr) {
            addr.setPlaceName(this.stripIllegalChars(addr.getPlaceName()));
            addr.setMainAddress(this.stripIllegalChars(addr.getMainAddress()));
            addr.setPostAddress(this.stripIllegalChars(addr.getPostAddress()));
            addr.setAreaName1(this.stripIllegalChars(addr.getAreaName1()));
            addr.setAreaName2(this.stripIllegalChars(addr.getAreaName2()));
            addr.setAreaName3(this.stripIllegalChars(addr.getAreaName3()));
            addr.setAreaName4(this.stripIllegalChars(addr.getAreaName4()));
            addr.setPostCode1(this.stripIllegalChars(addr.getPostCode1()));
            addr.setPostCode2(this.stripIllegalChars(addr.getPostCode2()));
            addr.setGenericField1(this.stripIllegalChars(addr.getGenericField1()));
            addr.setGenericField2(this.stripIllegalChars(addr.getGenericField2()));
            addr.setGenericField3(this.stripIllegalChars(addr.getGenericField3()));
            addr.setGenericField4(this.stripIllegalChars(addr.getGenericField4()));
            HashMap map = addr.getAdditionalFields();
            for (String key : map.keySet()) {
                map.put(key, this.stripIllegalChars((String)map.get(key)));
            }
        }

        private String stripIllegalChars(String str) {
            if (str == null) {
                return str;
            }
            return str.replaceAll(ClientRequestContainer.ILLEGAL_XML_CHARS, "");
        }
    }
}

