/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.coordsys.CoordSys;
import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.utils.ISO639;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.UnknownCodeException;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class GeocodeConstraints
implements IGeocodeConstraints {
    public static final String KEY_CLOSEMATCHESONLY = "closeMatchesOnly";
    public static final String KEY_MUST_MATCH_ADDRNUM = "MustMatchAddrNum";
    public static final String KEY_MUST_MATCH_MAINADDR = "MustMatchMainAddr";
    public static final String KEY_MUST_RETURN_PARSED_INPUT_ELEMENT = "MustReturnParsedInputElement";
    public static final String KEY_MUST_MATCH_AREA1 = "MustMatchArea1";
    public static final String KEY_MUST_MATCH_AREA2 = "MustMatchArea2";
    public static final String KEY_MUST_MATCH_AREA3 = "MustMatchArea3";
    public static final String KEY_MUST_MATCH_AREA4 = "MustMatchArea4";
    public static final String KEY_MUST_MATCH_POSTAL = "MustMatchPostalCode";
    public static final String KEY_MUST_MATCH_COUNTRY = "MustMatchCountry";
    public static final String KEY_MUST_MATCH_INPUT = "MustMatchInput";
    public static final String KEY_MAXCANDIDATES = "maxCandidatesReturned";
    public static final String KEY_MAXRANGES = "maxRanges";
    public static final String KEY_MAXRANGEUNITS = "maxRangeUnits";
    public static final String KEY_CORNEROFFSET = "OffsetFromCorner";
    public static final String KEY_STREETOFFSET = "OffsetFromStreet";
    public static final String KEY_CORNEROFFSETUNITS = "cornerOffsetUnits";
    public static final String KEY_STREETOFFSETUNITS = "streetOffsetUnits";
    public static final String KEY_CLIENT_LOCALE = "ClientLocale";
    public static final String KEY_CLIENT_CRS = "ClientCRS";
    public static final String KEY_GEOCODEMATCHTYPE = "GeocodeRequestType";
    public static final String KEY_FALLBACK_TO_POSTAL = "fallbackToPostal";
    public static final String KEY_FALLBACK_TO_GEOGRAPHIC = "fallbackToGeographic";
    public static final String KEY_DICTIONARY_USAGE = "dictionaryUsage";
    public static final String KEY_DICTIONARY_SEARCH_ORDER = "dictionarySearchOrder";
    public static final String VALUE_GEOCODE_MATCH_ADDRESS = "0";
    public static final String VALUE_GEOCODE_MATCH_POSTCODE = "1";
    public static final String VALUE_GEOCODE_MATCH_POI = "2";
    public static final String VALUE_GEOCODE_MATCH_GEOGRAPHIC = "4";
    public static final String VALUE_GEOCODE_MATCH_CITIES = "3";
    public static final String VALUE_GEOCODE_MATCH_STANDARDIZE_ONLY = "5";
    public static final String VALUE_GEOCODE_MATCH_BROWSE = "6";
    public static final String VALUE_GEOCODE_MATCH_UNKNOWN = "-1";
    public static final String VALUE_ALL_POSSIBLE_CANDIDATES = "-1";
    public static final String VALUE_ALL_POSSIBLE_RANGES = "-1";
    public static final String VALUE_ALL_POSSIBLE_RANGEUNITS = "-1";
    public static final String EPSG_WGS84 = "epsg:4326";
    public static final String KEY_ADDRESS_POINT_INTERPOLATION = "addrPntInterp";
    public static final String KEY_MATCH_MODE = "MatchMode";
    public static final String RELAXED_MODE = "RelaxedMode";
    public static final String EXACT_MODE = "ExactMode";
    public static final String DEFAULT_MODE = "DefaultMode";
    public static final String MATCH_MODE_NONE = null;
    public static final String USE_POINT_CENTERLINE_OFFSET = "useCenterlineOffset";
    public static final String POINT_CENTERLINE_OFFSET = "centerlineOffset";
    public static final String KEY_PREFER_POBOX_OVER_STREET = "PreferPOBoxOverStreet";
    public static final String KEY_DUAL_ADDRESS_PARSED_STREET = "DualAddressParsedStreet";
    public static final String KEY_DUAL_ADDRESS_PARSED_POBOX = "DualAddressParsedPOBox";
    public static final String POINT_CENTERLINE_OFFSET_UNIT = "centerlineOffsetUnits";
    public static final String NEAR_BY_STREET_GEOCODING = "NearByStreetGeocoding";
    protected final boolean DEFAULT_MUST_RETURN_PARSED_INPUT_ELEMENT = false;
    protected final boolean DEFAULT_MUST_MATCH_AREA1 = false;
    protected final boolean DEFAULT_MUST_MATCH_AREA2 = false;
    protected final boolean DEFAULT_MUST_MATCH_AREA3 = false;
    protected final boolean DEFAULT_MUST_MATCH_AREA4 = false;
    protected final boolean DEFAULT_MUST_MATCH_ADDR_NUM = false;
    protected final boolean DEFAULT_MUST_MATCH_MAIN_ADDR = false;
    protected final boolean DEFAULT_MUST_MATCH_POSTAL = false;
    protected final boolean DEFAULT_MUST_MATCH_INPUT = false;
    protected final boolean DEFAULT_MUST_MATCH_COUNTRY = true;
    private static final Set m_overriddenSet = new HashSet();
    private Locale m_locale;
    private com.mapinfo.midev.coordsys.CoordSys m_coordSys;
    private boolean m_bMustReturnParsedInputElement;
    private boolean m_bMustMatchArea1;
    private boolean m_bMustMatchArea2;
    private boolean m_bMustMatchArea3;
    private boolean m_bMustMatchArea4;
    private boolean m_bMustMatchAddrNum;
    private boolean m_bMustMatchMainAddr;
    private boolean m_bMustMatchPostal;
    private boolean m_bMustMatchInput;
    private boolean m_bMustMatchCountry;
    private boolean m_bReturnCloseOnly;
    private int m_maxCandidates;
    private int m_maxRanges;
    private int m_maxRangeUnits;
    private double m_cornerOffset;
    private double m_streetOffset;
    private String m_cornerOffsetUnits;
    private String m_streetOffsetUnits;
    private boolean m_bFallbackToGeo;
    private boolean m_bFallbackToPostal;
    private DictionaryUsagePreference m_dictionaryUsage;
    private int m_geocodeType;
    private IDictionarySearchOrder m_dictionarySearchOrder;
    private boolean m_bUseAddressPointInterpolation;
    private double m_nearByStreetOffset;
    private HashMap m_customValues = new HashMap();

    public GeocodeConstraints() {
        this.init();
    }

    public GeocodeConstraints(IGeocodeConstraints defaults) {
        this();
        if (defaults != null) {
            this.copyValues(defaults);
            this.m_customValues.putAll(defaults.getCustomValues());
        }
    }

    protected void copyValues(IGeocodeConstraints copyFrom) {
        if (copyFrom == null) {
            return;
        }
        this.setClientCoordinateSystem(copyFrom.getClientCoordinateSystemObject());
        this.setClientLocale(copyFrom.getClientLocale());
        this.setCornerOffset(copyFrom.getCornerOffset());
        this.setCornerOffsetUnits(copyFrom.getCornerOffsetUnits());
        this.setFallbackToGeographic(copyFrom.isFallbackToGeographic());
        this.setFallbackToPostal(copyFrom.isFallbackToPostal());
        this.setGeocodeType(copyFrom.getGeocodeType());
        this.setMaxCandidates(copyFrom.getMaxCandidates());
        this.setMaxRanges(copyFrom.getMaxRanges());
        this.setMaxRangeUnits(copyFrom.getMaxRangeUnits());
        this.setMustMatchAddressNumber(copyFrom.isMustMatchAddressNumber());
        this.setReturnParsedInputAddress(copyFrom.isReturnParsedInputAddress());
        this.setMustMatchArea1(copyFrom.isMustMatchArea1());
        this.setMustMatchArea2(copyFrom.isMustMatchArea2());
        this.setMustMatchArea3(copyFrom.isMustMatchArea3());
        this.setMustMatchArea4(copyFrom.isMustMatchArea4());
        this.setMustMatchInput(copyFrom.isMustMatchInput());
        this.setMustMatchCountry(copyFrom.isMustMatchCountry());
        this.setMustMatchMainAddress(copyFrom.isMustMatchMainAddress());
        this.setMustMatchPostalCode(copyFrom.isMustMatchPostalCode());
        this.setMatchMode(copyFrom.getMatchMode());
        this.setReturnCloseCandidatesOnly(copyFrom.isReturnCloseCandidatesOnly());
        this.setStreetOffset(copyFrom.getStreetOffset());
        this.setStreetOffsetUnits(copyFrom.getStreetOffsetUnits());
        this.setUseAddressPointInterpolation(copyFrom.getUseAddressPointInterpolation());
        this.setDictionaryUsage(copyFrom.getDictionaryUsage());
        this.setDictionarySearchOrder(copyFrom.getDictionarySearchOrder());
        this.setNearByStreetOffset(copyFrom.getNearByStreetOffset());
    }

    protected void init() {
        this.setGeocodeType(0);
        this.setMustMatchAddressNumber(false);
        this.setReturnParsedInputAddress(false);
        this.setMustMatchArea1(false);
        this.setMustMatchArea2(false);
        this.setMustMatchArea3(false);
        this.setMustMatchArea4(false);
        this.setMustMatchInput(false);
        this.setMustMatchCountry(true);
        this.setMustMatchMainAddress(false);
        this.setMustMatchPostalCode(false);
        this.setReturnCloseCandidatesOnly(false);
        this.setMaxCandidates(3);
        this.setMaxRanges(0);
        this.setMaxRangeUnits(0);
        this.setCornerOffset(25.0);
        this.setStreetOffset(25.0);
        this.setCornerOffsetUnits("ft");
        this.setStreetOffsetUnits("ft");
        this.setFallbackToPostal(false);
        this.setFallbackToGeographic(false);
        this.setDictionaryUsage(DictionaryUsagePreference.AD_AND_UD);
        this.setClientCoordinateSystem(EPSG_WGS84);
        this.setClientLocale(Locale.getDefault());
        this.setDictionarySearchOrder(null);
        this.setNearByStreetOffset(350.0);
        this.setCenterlineOffset(7.0);
        this.setCenterlineOffsetUnit("m");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        String lineSeparator = System.getProperty("line.separator");
        this.appendPair(sb, KEY_GEOCODEMATCHTYPE, String.valueOf(this.getGeocodeType()), lineSeparator);
        this.appendPair(sb, KEY_CLIENT_CRS, this.getClientCoordinateSystemSrsName(), lineSeparator);
        this.appendPair(sb, KEY_CLIENT_LOCALE, this.getClientLocale().getDisplayName(), lineSeparator);
        this.appendPair(sb, KEY_MUST_RETURN_PARSED_INPUT_ELEMENT, String.valueOf(this.isReturnParsedInputAddress()), lineSeparator);
        this.appendPair(sb, KEY_MUST_MATCH_AREA1, String.valueOf(this.isMustMatchArea1()), lineSeparator);
        this.appendPair(sb, KEY_MUST_MATCH_AREA2, String.valueOf(this.isMustMatchArea2()), lineSeparator);
        this.appendPair(sb, KEY_MUST_MATCH_AREA3, String.valueOf(this.isMustMatchArea3()), lineSeparator);
        this.appendPair(sb, KEY_MUST_MATCH_AREA4, String.valueOf(this.isMustMatchArea4()), lineSeparator);
        this.appendPair(sb, KEY_MUST_MATCH_ADDRNUM, String.valueOf(this.isMustMatchAddressNumber()), lineSeparator);
        this.appendPair(sb, KEY_MUST_MATCH_MAINADDR, String.valueOf(this.isMustMatchMainAddress()), lineSeparator);
        this.appendPair(sb, KEY_MUST_MATCH_POSTAL, String.valueOf(this.isMustMatchPostalCode()), lineSeparator);
        this.appendPair(sb, KEY_MUST_MATCH_INPUT, String.valueOf(this.isMustMatchInput()), lineSeparator);
        this.appendPair(sb, KEY_MUST_MATCH_COUNTRY, String.valueOf(this.isMustMatchCountry()), lineSeparator);
        this.appendPair(sb, KEY_CLOSEMATCHESONLY, String.valueOf(this.isReturnCloseCandidatesOnly()), lineSeparator);
        this.appendPair(sb, KEY_MAXCANDIDATES, String.valueOf(this.getMaxCandidates()), lineSeparator);
        this.appendPair(sb, KEY_MAXRANGES, String.valueOf(this.getMaxRanges()), lineSeparator);
        this.appendPair(sb, KEY_MAXRANGEUNITS, String.valueOf(this.getMaxRangeUnits()), lineSeparator);
        this.appendPair(sb, KEY_CORNEROFFSET, String.valueOf(this.getCornerOffset()), lineSeparator);
        this.appendPair(sb, KEY_STREETOFFSET, String.valueOf(this.getStreetOffset()), lineSeparator);
        this.appendPair(sb, KEY_CORNEROFFSETUNITS, this.getCornerOffsetUnits(), lineSeparator);
        this.appendPair(sb, KEY_STREETOFFSETUNITS, this.getStreetOffsetUnits(), lineSeparator);
        this.appendPair(sb, KEY_FALLBACK_TO_GEOGRAPHIC, String.valueOf(this.isFallbackToGeographic()), lineSeparator);
        this.appendPair(sb, KEY_FALLBACK_TO_POSTAL, String.valueOf(this.isFallbackToPostal()), lineSeparator);
        this.appendPair(sb, KEY_DICTIONARY_USAGE, this.getDictionaryUsage().toString(), lineSeparator);
        if (this.getDictionarySearchOrder() != null) {
            this.appendPair(sb, KEY_DICTIONARY_SEARCH_ORDER, this.getDictionarySearchOrder().toString(), lineSeparator);
        }
        this.appendPair(sb, KEY_ADDRESS_POINT_INTERPOLATION, String.valueOf(this.getUseAddressPointInterpolation()), lineSeparator);
        for (String key : this.m_customValues.keySet()) {
            String val = this.getCustomString(key);
            this.appendPair(sb, key, val, lineSeparator);
        }
        return sb.toString();
    }

    private void appendPair(StringBuffer sb, String key, String value, String sep) {
        sb.append(key);
        sb.append("=");
        sb.append(value);
        sb.append(sep);
    }

    private static final void initReplacedKeys() {
        m_overriddenSet.add(KEY_GEOCODEMATCHTYPE);
        m_overriddenSet.add(KEY_CLIENT_LOCALE);
        m_overriddenSet.add(KEY_CLIENT_CRS);
        m_overriddenSet.add(KEY_MUST_RETURN_PARSED_INPUT_ELEMENT);
        m_overriddenSet.add(KEY_MUST_MATCH_AREA1);
        m_overriddenSet.add(KEY_MUST_MATCH_AREA2);
        m_overriddenSet.add(KEY_MUST_MATCH_AREA3);
        m_overriddenSet.add(KEY_MUST_MATCH_AREA4);
        m_overriddenSet.add(KEY_MUST_MATCH_ADDRNUM);
        m_overriddenSet.add(KEY_MUST_MATCH_MAINADDR);
        m_overriddenSet.add(KEY_MUST_MATCH_POSTAL);
        m_overriddenSet.add(KEY_MUST_MATCH_INPUT);
        m_overriddenSet.add(KEY_MUST_MATCH_COUNTRY);
        m_overriddenSet.add(KEY_CLOSEMATCHESONLY);
        m_overriddenSet.add(KEY_MAXCANDIDATES);
        m_overriddenSet.add(KEY_MAXRANGES);
        m_overriddenSet.add(KEY_MAXRANGEUNITS);
        m_overriddenSet.add(KEY_CORNEROFFSET);
        m_overriddenSet.add(KEY_STREETOFFSET);
        m_overriddenSet.add(KEY_CORNEROFFSETUNITS);
        m_overriddenSet.add(KEY_STREETOFFSETUNITS);
        m_overriddenSet.add(KEY_FALLBACK_TO_GEOGRAPHIC);
        m_overriddenSet.add(KEY_FALLBACK_TO_POSTAL);
        m_overriddenSet.add(KEY_DICTIONARY_USAGE);
        m_overriddenSet.add(KEY_DICTIONARY_SEARCH_ORDER);
        m_overriddenSet.add(KEY_ADDRESS_POINT_INTERPOLATION);
    }

    @Override
    public Locale getClientLocale() {
        return this.m_locale;
    }

    @Override
    public void setClientLocale(String localeString) {
        this.m_locale = ISO639.getLocale(localeString);
    }

    @Override
    public void setClientLocale(Locale locale) {
        this.m_locale = locale;
    }

    @Override
    public CoordSys getClientCoordinateSystem() {
        return MidevConversionUtils.getLegacyCoordSys(this.m_coordSys);
    }

    @Override
    public com.mapinfo.midev.coordsys.CoordSys getClientCoordinateSystemObject() {
        return this.m_coordSys;
    }

    public String getClientCoordinateSystemSrsName() {
        if (this.m_coordSys == null) {
            return null;
        }
        return CoordSysUtilities.getSRSName((com.mapinfo.midev.coordsys.CoordSys)this.m_coordSys);
    }

    @Override
    public void setClientCoordinateSystem(String crsString) {
        if (crsString != null && crsString.length() != 0) {
            try {
                this.m_coordSys = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(crsString);
            }
            catch (UnknownCodeException mirx) {
                throw new IllegalArgumentException(mirx.getLocalizedMessage());
            }
        }
    }

    @Override
    public void setClientCoordinateSystem(CoordSys coordSys) {
        if (coordSys == null) {
            this.m_coordSys = null;
            return;
        }
        String oldSrsName = coordSys.getSrsName();
        this.m_coordSys = MidevConversionUtils.getCoordSysFromLegacyString(oldSrsName);
    }

    @Override
    public void setClientCoordinateSystem(com.mapinfo.midev.coordsys.CoordSys coordSys) {
        this.m_coordSys = coordSys;
    }

    @Override
    public boolean isReturnParsedInputAddress() {
        return this.m_bMustReturnParsedInputElement;
    }

    @Override
    public void setReturnParsedInputAddress(boolean bMatch) {
        this.m_bMustReturnParsedInputElement = bMatch;
    }

    @Override
    public boolean isMustMatchArea1() {
        return this.m_bMustMatchArea1;
    }

    @Override
    public void setMustMatchArea1(boolean bMatch) {
        this.m_bMustMatchArea1 = bMatch;
    }

    @Override
    public boolean isMustMatchArea2() {
        return this.m_bMustMatchArea2;
    }

    @Override
    public void setMustMatchArea2(boolean bMatch) {
        this.m_bMustMatchArea2 = bMatch;
    }

    @Override
    public boolean isMustMatchArea3() {
        return this.m_bMustMatchArea3;
    }

    @Override
    public void setMustMatchArea3(boolean bMatch) {
        this.m_bMustMatchArea3 = bMatch;
    }

    @Override
    public boolean isMustMatchArea4() {
        return this.m_bMustMatchArea4;
    }

    @Override
    public void setMustMatchArea4(boolean bMatch) {
        this.m_bMustMatchArea4 = bMatch;
    }

    @Override
    public boolean isMustMatchAddressNumber() {
        return this.m_bMustMatchAddrNum;
    }

    @Override
    public void setMustMatchAddressNumber(boolean bMatch) {
        this.m_bMustMatchAddrNum = bMatch;
    }

    @Override
    public boolean isMustMatchMainAddress() {
        return this.m_bMustMatchMainAddr;
    }

    @Override
    public void setMustMatchMainAddress(boolean bMatch) {
        this.m_bMustMatchMainAddr = bMatch;
    }

    @Override
    public boolean isMustMatchPostalCode() {
        return this.m_bMustMatchPostal;
    }

    @Override
    public void setMustMatchPostalCode(boolean bMatch) {
        this.m_bMustMatchPostal = bMatch;
    }

    @Override
    public boolean isMustMatchInput() {
        return this.m_bMustMatchInput;
    }

    @Override
    public void setMustMatchInput(boolean bMatch) {
        this.m_bMustMatchInput = bMatch;
    }

    @Override
    public boolean isMustMatchCountry() {
        return this.m_bMustMatchCountry;
    }

    @Override
    public void setMustMatchCountry(boolean bMatch) {
        this.m_bMustMatchCountry = bMatch;
    }

    @Override
    public int getMaxRanges() {
        return this.m_maxRanges;
    }

    @Override
    public void setMaxRanges(int m_maxRanges) {
        this.m_maxRanges = m_maxRanges;
    }

    @Override
    public int getMaxRangeUnits() {
        return this.m_maxRangeUnits;
    }

    @Override
    public void setMaxRangeUnits(int m_maxRangeUnits) {
        this.m_maxRangeUnits = m_maxRangeUnits;
    }

    @Override
    public int getMaxCandidates() {
        return this.m_maxCandidates;
    }

    @Override
    public void setMaxCandidates(int m_maxCandidates) {
        this.m_maxCandidates = m_maxCandidates;
    }

    @Override
    public boolean isReturnCloseCandidatesOnly() {
        return this.m_bReturnCloseOnly;
    }

    @Override
    public void setReturnCloseCandidatesOnly(boolean bReturn) {
        this.m_bReturnCloseOnly = bReturn;
    }

    @Override
    public double getStreetOffset() {
        return this.m_streetOffset;
    }

    @Override
    public void setStreetOffset(double offset) {
        this.m_streetOffset = offset;
    }

    @Override
    public double getCornerOffset() {
        return this.m_cornerOffset;
    }

    @Override
    public void setCornerOffset(double offset) {
        this.m_cornerOffset = offset;
    }

    @Override
    public String getCornerOffsetUnits() {
        return this.m_cornerOffsetUnits;
    }

    @Override
    public void setCornerOffsetUnits(String units) {
        this.m_cornerOffsetUnits = units;
    }

    @Override
    public String getStreetOffsetUnits() {
        return this.m_streetOffsetUnits;
    }

    @Override
    public void setStreetOffsetUnits(String units) {
        this.m_streetOffsetUnits = units;
    }

    @Override
    public int getGeocodeType() {
        return this.m_geocodeType;
    }

    @Override
    public void setGeocodeType(int type) {
        this.m_geocodeType = type;
    }

    @Override
    public boolean isFallbackToPostal() {
        return this.m_bFallbackToPostal;
    }

    @Override
    public void setFallbackToPostal(boolean bFallback) {
        this.m_bFallbackToPostal = bFallback;
    }

    @Override
    public boolean isFallbackToGeographic() {
        return this.m_bFallbackToGeo;
    }

    @Override
    public void setFallbackToGeographic(boolean bFallback) {
        this.m_bFallbackToGeo = bFallback;
    }

    @Override
    public DictionaryUsagePreference getDictionaryUsage() {
        return this.m_dictionaryUsage;
    }

    @Override
    public void setDictionaryUsage(DictionaryUsagePreference pref) {
        this.m_dictionaryUsage = pref;
    }

    @Override
    public void setUseAddressPointInterpolation(boolean flag) {
        this.m_bUseAddressPointInterpolation = flag;
    }

    @Override
    public boolean getUseAddressPointInterpolation() {
        return this.m_bUseAddressPointInterpolation;
    }

    protected int parseIntWithDefault(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public String setCustomString(String key, String value) {
        if (m_overriddenSet.contains(key)) {
            return this.putKnownString(key, value);
        }
        return this.m_customValues.put(key, value);
    }

    @Override
    public String getCustomString(String key) {
        if (m_overriddenSet.contains(key)) {
            return this.getKnownString(key);
        }
        return (String)this.m_customValues.get(key);
    }

    @Override
    public String getCustomString(String key, String defaultValue) {
        String ret = this.getCustomString(key);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    @Override
    public HashMap getCustomValues() {
        return this.m_customValues;
    }

    @Override
    public void loadAsCustomStrings(InputStream file) throws IOException {
        Properties properties = new Properties();
        properties.load(file);
        for (String string : properties.keySet()) {
            if (m_overriddenSet.contains(string)) {
                this.putKnownString(string, properties.getProperty(string));
                continue;
            }
            this.m_customValues.put(string, properties.getProperty(string));
        }
    }

    @Override
    public void setDictionarySearchOrder(IDictionarySearchOrder newOrder) {
        this.m_dictionarySearchOrder = newOrder;
    }

    @Override
    public IDictionarySearchOrder getDictionarySearchOrder() {
        return this.m_dictionarySearchOrder;
    }

    @Override
    public void setMatchMode(String MMString) {
        if (MMString != null) {
            this.setCustomString(KEY_MATCH_MODE, MMString);
        } else {
            this.m_customValues.remove(KEY_MATCH_MODE);
        }
    }

    @Override
    public void setUseCenterlineOffset(boolean flag) {
        this.setCustomString(USE_POINT_CENTERLINE_OFFSET, String.valueOf(flag));
    }

    @Override
    public boolean getUseCenterlineOffset() {
        return Boolean.parseBoolean(this.getCustomString(USE_POINT_CENTERLINE_OFFSET, Boolean.FALSE.toString()));
    }

    @Override
    public void setCenterlineOffset(double value) {
        this.setCustomString(POINT_CENTERLINE_OFFSET, String.valueOf(value));
    }

    @Override
    public double getCenterlineOffset() {
        return Double.parseDouble(this.getCustomString(POINT_CENTERLINE_OFFSET, "0.0"));
    }

    @Override
    public void setCenterlineOffsetUnit(String unit) {
        if (unit != null) {
            this.setCustomString(POINT_CENTERLINE_OFFSET_UNIT, unit);
        } else {
            this.m_customValues.remove(POINT_CENTERLINE_OFFSET_UNIT);
        }
    }

    @Override
    public String getCenterlineOffsetUnit() {
        return this.getCustomString(POINT_CENTERLINE_OFFSET_UNIT);
    }

    @Override
    public String getMatchMode() {
        return this.getCustomString(KEY_MATCH_MODE);
    }

    private String getKnownString(String key) {
        if (key.equalsIgnoreCase(KEY_GEOCODEMATCHTYPE)) {
            return String.valueOf(this.m_geocodeType);
        }
        if (key.equalsIgnoreCase(KEY_CLIENT_LOCALE)) {
            return this.m_locale.toString();
        }
        if (key.equalsIgnoreCase(KEY_CLIENT_CRS)) {
            return CoordSysUtilities.getSRSName((com.mapinfo.midev.coordsys.CoordSys)this.m_coordSys);
        }
        if (key.equalsIgnoreCase(KEY_MUST_RETURN_PARSED_INPUT_ELEMENT)) {
            return String.valueOf(this.m_bMustReturnParsedInputElement);
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_AREA1)) {
            return String.valueOf(this.m_bMustMatchArea1);
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_AREA2)) {
            return String.valueOf(this.m_bMustMatchArea2);
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_AREA3)) {
            return String.valueOf(this.m_bMustMatchArea3);
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_AREA4)) {
            return String.valueOf(this.m_bMustMatchArea4);
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_ADDRNUM)) {
            return String.valueOf(this.m_bMustMatchAddrNum);
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_MAINADDR)) {
            return String.valueOf(this.m_bMustMatchMainAddr);
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_POSTAL)) {
            return String.valueOf(this.m_bMustMatchPostal);
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_INPUT)) {
            return String.valueOf(this.m_bMustMatchInput);
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_COUNTRY)) {
            return String.valueOf(this.m_bMustMatchCountry);
        }
        if (key.equalsIgnoreCase(KEY_MAXCANDIDATES)) {
            return String.valueOf(this.m_maxCandidates);
        }
        if (key.equalsIgnoreCase(KEY_MAXRANGES)) {
            return String.valueOf(this.m_maxRanges);
        }
        if (key.equalsIgnoreCase(KEY_MAXRANGEUNITS)) {
            return String.valueOf(this.m_maxRangeUnits);
        }
        if (key.equalsIgnoreCase(KEY_CORNEROFFSET)) {
            return String.valueOf(this.m_cornerOffset);
        }
        if (key.equalsIgnoreCase(KEY_STREETOFFSET)) {
            return String.valueOf(this.m_streetOffset);
        }
        if (key.equalsIgnoreCase(KEY_CORNEROFFSETUNITS)) {
            return this.m_cornerOffsetUnits;
        }
        if (key.equalsIgnoreCase(KEY_STREETOFFSETUNITS)) {
            return this.m_streetOffsetUnits;
        }
        if (key.equalsIgnoreCase(KEY_CLOSEMATCHESONLY)) {
            return String.valueOf(this.m_bReturnCloseOnly);
        }
        if (key.equalsIgnoreCase(KEY_FALLBACK_TO_POSTAL)) {
            return String.valueOf(this.m_bFallbackToPostal);
        }
        if (key.equalsIgnoreCase(KEY_FALLBACK_TO_GEOGRAPHIC)) {
            return String.valueOf(this.m_bFallbackToGeo);
        }
        if (key.equalsIgnoreCase(KEY_ADDRESS_POINT_INTERPOLATION)) {
            return String.valueOf(this.m_bUseAddressPointInterpolation);
        }
        return null;
    }

    private String putKnownString(String key, String value) {
        if (key.equalsIgnoreCase(KEY_GEOCODEMATCHTYPE)) {
            String ret = String.valueOf(this.m_geocodeType);
            this.m_geocodeType = this.parseIntWithDefault(value, 0);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_CLIENT_LOCALE)) {
            String ret = null;
            if (this.m_locale != null) {
                ret = this.m_locale.toString();
            }
            this.m_locale = ISO639.getLocale(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_CLIENT_CRS)) {
            String ret = null;
            if (this.m_coordSys != null) {
                ret = CoordSysUtilities.getSRSName((com.mapinfo.midev.coordsys.CoordSys)this.m_coordSys);
            }
            this.m_coordSys = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_RETURN_PARSED_INPUT_ELEMENT)) {
            String ret = String.valueOf(this.m_bMustReturnParsedInputElement);
            this.m_bMustReturnParsedInputElement = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_AREA1)) {
            String ret = String.valueOf(this.m_bMustMatchArea1);
            this.m_bMustMatchArea1 = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_AREA2)) {
            String ret = String.valueOf(this.m_bMustMatchArea2);
            this.m_bMustMatchArea2 = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_AREA3)) {
            String ret = String.valueOf(this.m_bMustMatchArea3);
            this.m_bMustMatchArea3 = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_AREA4)) {
            String ret = String.valueOf(this.m_bMustMatchArea4);
            this.m_bMustMatchArea4 = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_ADDRNUM)) {
            String ret = String.valueOf(this.m_bMustMatchAddrNum);
            this.m_bMustMatchAddrNum = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_MAINADDR)) {
            String ret = String.valueOf(this.m_bMustMatchMainAddr);
            this.m_bMustMatchMainAddr = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_POSTAL)) {
            String ret = String.valueOf(this.m_bMustMatchPostal);
            this.m_bMustMatchPostal = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_INPUT)) {
            String ret = String.valueOf(this.m_bMustMatchInput);
            this.m_bMustMatchInput = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MUST_MATCH_COUNTRY)) {
            String ret = String.valueOf(this.m_bMustMatchCountry);
            this.m_bMustMatchCountry = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MAXCANDIDATES)) {
            String ret = String.valueOf(this.m_maxCandidates);
            this.m_maxCandidates = this.parseIntWithDefault(value, 3);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MAXRANGES)) {
            String ret = String.valueOf(this.m_maxRanges);
            this.m_maxRanges = this.parseIntWithDefault(value, 0);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_MAXRANGEUNITS)) {
            String ret = String.valueOf(this.m_maxRangeUnits);
            this.m_maxRangeUnits = this.parseIntWithDefault(value, 0);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_CORNEROFFSET)) {
            String ret = String.valueOf(this.m_cornerOffset);
            this.m_cornerOffset = Double.parseDouble(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_STREETOFFSET)) {
            String ret = String.valueOf(this.m_streetOffset);
            this.m_streetOffset = Double.parseDouble(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_CORNEROFFSETUNITS)) {
            String ret = this.m_cornerOffsetUnits;
            this.m_cornerOffsetUnits = value;
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_STREETOFFSETUNITS)) {
            String ret = this.m_streetOffsetUnits;
            this.m_streetOffsetUnits = value;
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_CLOSEMATCHESONLY)) {
            String ret = String.valueOf(this.m_bReturnCloseOnly);
            this.m_bReturnCloseOnly = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_FALLBACK_TO_POSTAL)) {
            String ret = String.valueOf(this.m_bFallbackToPostal);
            this.m_bFallbackToPostal = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_FALLBACK_TO_GEOGRAPHIC)) {
            String ret = String.valueOf(this.m_bFallbackToGeo);
            this.m_bFallbackToGeo = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_ADDRESS_POINT_INTERPOLATION)) {
            String ret = String.valueOf(this.m_bUseAddressPointInterpolation);
            this.m_bUseAddressPointInterpolation = "true".equalsIgnoreCase(value);
            return ret;
        }
        if (key.equalsIgnoreCase(KEY_DICTIONARY_USAGE)) {
            String ret = null;
            if (this.m_dictionaryUsage != null) {
                ret = this.m_dictionaryUsage.toString();
                if ("AD_ONLY".equalsIgnoreCase(value)) {
                    this.m_dictionaryUsage = DictionaryUsagePreference.AD_ONLY;
                } else if ("UD_ONLY".equalsIgnoreCase(value)) {
                    this.m_dictionaryUsage = DictionaryUsagePreference.UD_ONLY;
                } else if ("AD_AND_UD".equalsIgnoreCase(value) || "UD_AND_AD".equalsIgnoreCase(value)) {
                    this.m_dictionaryUsage = DictionaryUsagePreference.AD_AND_UD;
                } else if ("PREFER_UD".equalsIgnoreCase(value)) {
                    this.m_dictionaryUsage = DictionaryUsagePreference.PREFER_UD;
                } else if ("PREFER_AD".equalsIgnoreCase(value)) {
                    this.m_dictionaryUsage = DictionaryUsagePreference.PREFER_AD;
                }
            }
            return ret;
        }
        return null;
    }

    @Override
    public double getNearByStreetOffset() {
        return this.m_nearByStreetOffset;
    }

    @Override
    public void setNearByStreetOffset(double nearByStreetOffset) {
        this.m_nearByStreetOffset = nearByStreetOffset;
    }

    static {
        GeocodeConstraints.initReplacedKeys();
    }
}

