/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.VersionInfo;
import com.mapinfo.mapmarker.user.ClientGeocodeResponse;
import com.mapinfo.mapmarker.user.ClientRequestContainer;
import com.mapinfo.mapmarker.user.ClientResponseContainer;
import com.mapinfo.mapmarker.user.GeocodeConstraints;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.InputAddress;
import com.mapinfo.mapmarker.user.MMJRequestXMLWriter;
import com.mapinfo.mapmarker.user.MMJResponseXMLReader;
import com.mapinfo.mapmarker.user.MapMarkerClientException;
import com.mapinfo.mapmarker.user.MapMarkerException;
import com.mapinfo.mapmarker.user.MapMarkerFatalException;
import com.mapinfo.mapmarker.user.MapMarkerJavaAPI;
import com.mapinfo.mapmarker.user.ReverseGeocodeAPI;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.mapmarker.utils.VersionDescriptor;
import com.mapinfo.mapmarker.utils.net.HttpURLResponseStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class MMJClient
implements MapMarkerJavaAPI,
ReverseGeocodeAPI {
    protected static final String MMJS_RESPONSE_HEADER = "MMJS_RESPONSE";
    private final URL m_url;

    public MMJClient(String url) throws MalformedURLException {
        this(new URL(url));
    }

    public MMJClient(URL url) {
        this.m_url = url;
    }

    public static final ClientGeocodeResponse geocode(int geocodeType, InputAddress inputAddress, IGeocodeConstraints settings, String servletURL) throws MapMarkerException, MapMarkerFatalException {
        return MMJClient.geocode(geocodeType, inputAddress.convert(), settings, servletURL);
    }

    public static final ClientGeocodeResponse geocode(int geocodeType, Address inputAddress, IGeocodeConstraints settings, String servletURL) throws MapMarkerException, MapMarkerFatalException {
        if (settings == null) {
            settings = new GeocodeConstraints();
        }
        settings.setGeocodeType(geocodeType);
        ClientRequestContainer request = new ClientRequestContainer(inputAddress, settings);
        ClientResponseContainer response = null;
        try {
            response = MMJClient.handleRequest(request, new URL(servletURL));
        }
        catch (MalformedURLException e) {
            throw new MapMarkerClientException(2400);
        }
        return response.getResponse();
    }

    @Override
    public final ClientGeocodeResponse geocode(int geocodeType, InputAddress inputAddress, IGeocodeConstraints settings) throws MapMarkerException, MapMarkerFatalException {
        return this.geocode(geocodeType, inputAddress.convert(), settings);
    }

    @Override
    public final ClientGeocodeResponse geocode(int geocodeType, Address inputAddress, IGeocodeConstraints settings) throws MapMarkerException, MapMarkerFatalException {
        if (settings == null) {
            settings = new GeocodeConstraints();
        }
        settings.setGeocodeType(geocodeType);
        ClientRequestContainer request = new ClientRequestContainer(inputAddress, settings);
        ClientResponseContainer response = MMJClient.handleRequest(request, this.m_url);
        return response.getResponse();
    }

    public static final String getVersion() {
        return VersionInfo.getFullVersion();
    }

    public static final boolean ping(String servletURL) {
        boolean bRc = false;
        try {
            HttpURLConnection conn = MMJClient.connect(new URL(servletURL));
            if (conn != null) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "null");
                if (conn.getOutputStream() != null) {
                    String responseheader;
                    PrintWriter pw = new PrintWriter(conn.getOutputStream());
                    pw.println("<HTML></HTML>");
                    pw.flush();
                    pw.close();
                    int code = HttpURLResponseStatus.getResponseCode(conn);
                    if (code == 200 && (responseheader = conn.getHeaderField(MMJS_RESPONSE_HEADER)) != null) {
                        bRc = true;
                    }
                }
            }
        }
        catch (ProtocolException protocolException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bRc;
    }

    public final boolean ping() {
        boolean bRc = false;
        try {
            HttpURLConnection conn = MMJClient.connect(this.m_url);
            if (conn != null) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "null");
                if (conn.getOutputStream() != null) {
                    String responseheader;
                    PrintWriter pw = new PrintWriter(conn.getOutputStream());
                    pw.println("<HTML></HTML>");
                    pw.flush();
                    pw.close();
                    int code = HttpURLResponseStatus.getResponseCode(conn);
                    if (code == 200 && (responseheader = conn.getHeaderField(MMJS_RESPONSE_HEADER)) != null) {
                        bRc = true;
                    }
                }
            }
        }
        catch (ProtocolException protocolException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bRc;
    }

    private static HttpURLConnection connect(URL url) {
        HttpURLConnection uc = null;
        try {
            uc = (HttpURLConnection)url.openConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return uc;
    }

    private static ClientResponseContainer handleRequest(ClientRequestContainer request, URL servletURL) throws MapMarkerException, MapMarkerFatalException {
        if (servletURL != null) {
            HttpURLConnection conn = MMJClient.connect(servletURL);
            try {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "text/xml");
                conn.setRequestProperty("MI_XMLProtocolRequest", "GeocodeRequest");
                conn.setRequestProperty("MI_XMLProtocolVersion", "MI_XML_Protocol_GeocodeRequestAndResponse_3_0");
                XMLOutputter outputter = new XMLOutputter();
                MMJRequestXMLWriter writer = new MMJRequestXMLWriter(outputter, conn.getOutputStream());
                writer.write(request);
                InputStream is = HttpURLResponseStatus.getInputStream(conn);
                if (is == null) {
                    throw new MapMarkerClientException(2401);
                }
                if (conn.getResponseCode() != 200) {
                    throw new MapMarkerFatalException(conn.getResponseMessage(), 2308, "Core");
                }
                MMJResponseXMLReader reader = new MMJResponseXMLReader();
                return reader.readGeocodeResponse(MMJClient.getDocument(is), request.getID());
            }
            catch (JDOMException jde) {
                throw new MapMarkerClientException(2402, (Exception)((Object)jde));
            }
            catch (IOException ioe) {
                throw new MapMarkerClientException(2404, ioe);
            }
        }
        throw new MapMarkerClientException(2405);
    }

    public IGeocodeConstraints getConstraintsFromServer() {
        IGeocodeConstraints result = null;
        try {
            HttpURLConnection conn = MMJClient.connect(this.m_url);
            if (conn != null) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "text/xml");
                conn.setRequestProperty("MI_XMLProtocolRequest", "ConstraintsRequest");
                if (conn.getOutputStream() != null) {
                    PrintWriter pw = new PrintWriter(conn.getOutputStream());
                    pw.print("<GetConstraints></GetConstraints>");
                    pw.flush();
                    pw.close();
                    if (conn.getResponseCode() != 200) {
                        return null;
                    }
                    InputStream is = HttpURLResponseStatus.getInputStream(conn);
                    MMJResponseXMLReader reader = new MMJResponseXMLReader();
                    result = reader.readConstraintsResponse(MMJClient.getDocument(is));
                }
            }
        }
        catch (ProtocolException protocolException) {
        }
        catch (JDOMException jDOMException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public VersionDescriptor getSupportedVersions() {
        VersionDescriptor result = null;
        try {
            HttpURLConnection conn = MMJClient.connect(this.m_url);
            if (conn != null) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "text/xml");
                conn.setRequestProperty("MI_XMLProtocolRequest", "VersionsRequest");
                if (conn.getOutputStream() != null) {
                    PrintWriter pw = new PrintWriter(conn.getOutputStream());
                    pw.print("<GetVersions></GetVersions>");
                    pw.flush();
                    pw.close();
                    if (conn.getResponseCode() != 200) {
                        return null;
                    }
                    InputStream is = HttpURLResponseStatus.getInputStream(conn);
                    MMJResponseXMLReader reader = new MMJResponseXMLReader();
                    result = reader.readVersionsResponse(MMJClient.getDocument(is));
                }
            }
        }
        catch (ProtocolException protocolException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public String[] getLicenseInformation() {
        String[] result;
        block6: {
            result = new String[]{};
            try {
                HttpURLConnection conn = MMJClient.connect(this.m_url);
                if (conn == null) break block6;
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "text/xml");
                conn.setRequestProperty("MI_XMLProtocolRequest", "LicenseInformationRequest");
                if (conn.getOutputStream() == null) break block6;
                PrintWriter pw = new PrintWriter(conn.getOutputStream());
                pw.print("<GetLicenseInformation></GetLicenseInformation>");
                pw.flush();
                pw.close();
                if (HttpURLResponseStatus.getResponseCode(conn) == 200) {
                    InputStream is = HttpURLResponseStatus.getInputStream(conn);
                    MMJResponseXMLReader reader = new MMJResponseXMLReader();
                    result = reader.readLicenseInformationResponse(MMJClient.getDocument(is));
                    break block6;
                }
                String[] ret = new String[]{conn.getResponseMessage()};
                return ret;
            }
            catch (ProtocolException protocolException) {
            }
            catch (JDOMException jDOMException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private static Document getDocument(InputStream in) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder(false);
        return builder.build(in);
    }

    @Override
    public IDictionarySearchOrder getDictionaryInformation(String countryCode, IGeocodeConstraints constraints) throws MapMarkerException, MapMarkerFatalException {
        try {
            HttpURLConnection conn = MMJClient.connect(this.m_url);
            if (conn != null) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "text/xml");
                conn.setRequestProperty("MI_XMLProtocolRequest", "DictionarySearchOrderRequest");
                MMJRequestXMLWriter writer = new MMJRequestXMLWriter(new XMLOutputter(), conn.getOutputStream());
                writer.writeDictionarySearchOrderRequest(countryCode, constraints);
                if (HttpURLResponseStatus.getResponseCode(conn) != 200) {
                    throw new MapMarkerFatalException(conn.getResponseMessage(), 2308, "Core");
                }
                InputStream is = HttpURLResponseStatus.getInputStream(conn);
                if (is == null) {
                    throw new MapMarkerClientException(2401);
                }
                MMJResponseXMLReader reader = new MMJResponseXMLReader();
                return reader.readDictionarySearchOrderResponse(MMJClient.getDocument(is));
            }
        }
        catch (JDOMException jde) {
            throw new MapMarkerClientException(2402, (Exception)((Object)jde));
        }
        catch (IOException ioe) {
            throw new MapMarkerClientException(2404, ioe);
        }
        return null;
    }

    @Override
    public ReverseGeocodeResponse reverseGeocode(String country, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerException, MapMarkerFatalException {
        return this.reverseGeocode(0, country, location, constraints);
    }

    @Override
    public ReverseGeocodeResponse reverseGeocode(int reverseGeocodeType, String country, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerException, MapMarkerFatalException {
        HttpURLConnection conn = null;
        try {
            conn = this.setupConnection("ReverseGeocode");
            MMJRequestXMLWriter writer = new MMJRequestXMLWriter(new XMLOutputter(), conn.getOutputStream());
            writer.writeReverseGeocodeRequest(reverseGeocodeType, country, location, constraints);
            if (HttpURLResponseStatus.getResponseCode(conn) != 200) {
                throw new MapMarkerFatalException(conn.getResponseMessage(), 2308, "Core");
            }
            InputStream is = HttpURLResponseStatus.getInputStream(conn);
            if (is == null) {
                throw new MapMarkerClientException(2401);
            }
            MMJResponseXMLReader reader = new MMJResponseXMLReader();
            ReverseGeocodeResponse reverseGeocodeResponse = reader.readReverseGeocodeResponse(MMJClient.getDocument(is));
            return reverseGeocodeResponse;
        }
        catch (IOException IOEx) {
            throw new MapMarkerClientException(2404, IOEx);
        }
        catch (JDOMException JDOMEx) {
            throw new MapMarkerClientException(2402, (Exception)((Object)JDOMEx));
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void handleError(HttpURLConnection conn) throws MapMarkerException, MapMarkerFatalException {
        try {
            InputStream is = HttpURLResponseStatus.getInputStream(conn);
            if (is == null) {
                return;
            }
            if (is.available() == 0) {
                return;
            }
            Document errorDoc = MMJClient.getDocument(is);
            if (errorDoc == null) {
                return;
            }
            Element root = errorDoc.getRootElement();
            if (root == null) {
                return;
            }
            Element errorElement = root.getChild("ErrorResponse");
            if (errorElement == null) {
                return;
            }
            MMJResponseXMLReader errorReader = new MMJResponseXMLReader();
            errorReader.handleErrorResponse(errorElement);
        }
        catch (IOException iOException) {
        }
        catch (JDOMException jDOMException) {
            // empty catch block
        }
    }

    private HttpURLConnection setupConnection(String requestType) throws IOException, MapMarkerClientException {
        if (this.m_url == null) {
            throw new MapMarkerClientException(2405);
        }
        HttpURLConnection conn = (HttpURLConnection)this.m_url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("MI_XMLProtocolRequest", requestType);
        return conn;
    }
}

