/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import com.mapinfo.mapmarker.common.VersionInfo;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.core.reverseGeocode.MMJReverseGeocoder;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.user.ClientGeocodeResponse;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.InputAddress;
import com.mapinfo.mapmarker.user.MMJGeocoderInstance;
import com.mapinfo.mapmarker.user.MapMarkerException;
import com.mapinfo.mapmarker.user.MapMarkerFatalException;
import com.mapinfo.mapmarker.user.MapMarkerJavaAPI;
import com.mapinfo.mapmarker.user.ReverseGeocodeAPI;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.mapmarker.utils.VersionDescriptor;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

public class MMJEngine
implements MapMarkerJavaAPI,
ReverseGeocodeAPI {
    private final VersionDescriptor m_versionDescriptor = GeocodableAddressFactory.getVersionDescriptor();

    @Override
    public final ClientGeocodeResponse geocode(int geocodeType, InputAddress inputAddress, IGeocodeConstraints constraints) throws MapMarkerException, MapMarkerFatalException {
        return this.geocode(geocodeType, inputAddress.convert(), constraints);
    }

    @Override
    public final ClientGeocodeResponse geocode(int geocodeType, Address inputAddress, IGeocodeConstraints constraints) throws MapMarkerException, MapMarkerFatalException {
        try {
            IConstraints internalSettings = Constraints.convertFromConstraints(constraints, null);
            MMJGeocoderInstance geocoder = new MMJGeocoderInstance();
            GeocodeResult gResult = geocoder.geocode(geocodeType, inputAddress, internalSettings);
            List uCands = null;
            if (geocodeType < 100) {
                switch (geocodeType) {
                    case 0: 
                    case 1: 
                    case 4: {
                        uCands = geocoder.filterReturnCandidates();
                        break;
                    }
                    case 5: 
                    case 6: {
                        uCands = geocoder.createCandidateList(gResult.getNumberCandidates());
                        break;
                    }
                }
            } else {
                uCands = geocoder.createCandidateList(gResult.getNumberCandidates());
            }
            ParsedInputAddress parsed = null;
            if (geocodeType == 0) {
                parsed = gResult.getParsedInput();
            }
            return new ClientGeocodeResponse(inputAddress.getAddressID(), gResult.getNumberCandidates(), gResult.getNumberCloseCandidates(), gResult.isUniqueMatchFound(), gResult.getDataLicensed(), uCands, parsed){};
        }
        catch (MapMarkerInternalException e) {
            throw new MapMarkerException(e, constraints.getClientLocale());
        }
        catch (MMInternalFatalException e) {
            throw new MapMarkerFatalException(e, constraints.getClientLocale());
        }
        catch (DataAccessRuntimeException DAREx) {
            throw new MapMarkerException((DataAccessException)DAREx.getCause(), constraints.getClientLocale());
        }
        catch (NullPointerException NPEx) {
            throw new MapMarkerException(NPEx);
        }
        catch (IndexOutOfBoundsException IOoBEx) {
            throw new MapMarkerException(IOoBEx);
        }
        catch (NoSuchElementException NSEEx) {
            throw new MapMarkerException(NSEEx);
        }
        catch (ArithmeticException AEx) {
            throw new MapMarkerException(AEx);
        }
        catch (NumberFormatException NEx) {
            throw new MapMarkerException(NEx);
        }
        catch (Throwable t) {
            throw new MapMarkerFatalException(t);
        }
    }

    public static String getVersion() {
        return VersionInfo.getFullVersion();
    }

    @Override
    public VersionDescriptor getSupportedVersions() {
        return this.m_versionDescriptor;
    }

    @Override
    public String[] getLicenseInformation() {
        return GeocodableAddressFactory.getAllLicenseInformation();
    }

    @Override
    public IDictionarySearchOrder getDictionaryInformation(String countryCode, IGeocodeConstraints constraints) throws MapMarkerException, MapMarkerFatalException {
        MMJGeocoderInstance geocoder = new MMJGeocoderInstance();
        IConstraints internalSettings = Constraints.convertFromConstraints(constraints, null);
        AddressImpl addr = new AddressImpl();
        addr.setCountry(countryCode);
        try {
            return geocoder.getDictionaryInformation(addr, internalSettings);
        }
        catch (MapMarkerInternalException e) {
            throw new MapMarkerException(e, internalSettings.getClientLocale());
        }
        catch (MMInternalFatalException e) {
            throw new MapMarkerFatalException(e, internalSettings.getClientLocale());
        }
    }

    @Override
    public ReverseGeocodeResponse reverseGeocode(String country, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerException, MapMarkerFatalException {
        return this.reverseGeocode(0, country, location, constraints);
    }

    @Override
    public ReverseGeocodeResponse reverseGeocode(int reverseGeocodeType, String country, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerException, MapMarkerFatalException {
        MMJReverseGeocoder reverseGeocoder = new MMJReverseGeocoder(country);
        Locale locale = constraints == null ? Locale.getDefault() : constraints.getClientLocale();
        try {
            return reverseGeocoder.reverseGeocode(reverseGeocodeType, location, new ReverseGeocodeInternalConstraints(constraints));
        }
        catch (MapMarkerInternalException MMIEx) {
            throw new MapMarkerException(MMIEx, locale);
        }
        catch (MMInternalFatalException MMIFEx) {
            throw new MapMarkerFatalException(MMIFEx, locale);
        }
        catch (DataAccessRuntimeException DAREx) {
            throw new MapMarkerException((DataAccessException)DAREx.getCause(), locale);
        }
        catch (FatalDataAccessRuntimeException FDAREx) {
            throw new MapMarkerFatalException((FatalDataAccessException)FDAREx.getCause(), locale);
        }
        catch (RuntimeException REx) {
            throw new MapMarkerException(REx);
        }
        catch (Throwable t) {
            throw new MapMarkerFatalException(t);
        }
    }
}

