/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.DictionarySearchOrder;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.IDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.user.IGeocoderInstance;
import com.mapinfo.mapmarker.utils.AddressUtils;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MMJGeocoderInstance
implements IGeocoderInstance {
    private IGeocoder m_geocodableAddr = null;
    private IConstraints m_constraints = null;
    private GeocodeResult m_geocodeResult = null;

    @Override
    public GeocodeResult geocode(int geocodeType, Address inAddress, IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        this.prepareConstraints(constraints);
        this.m_geocodeResult = null;
        this.m_geocodableAddr = null;
        AddressImpl uInAddress = new AddressImpl(inAddress);
        if (uInAddress.getCountry() != null) {
            uInAddress.setCountry(uInAddress.getCountry().toUpperCase());
        }
        this.m_geocodableAddr = GeocodableAddressFactory.createGeocodableAddress(uInAddress, this.m_constraints);
        if (this.m_geocodableAddr == null) {
            throw new MMGeneralGeocoderException(2302);
        }
        this.m_constraints = this.m_geocodableAddr.convertConstraints(this.m_constraints);
        this.m_geocodableAddr.prepareAndParse(geocodeType, this.m_constraints);
        switch (geocodeType) {
            case 0: {
                this.m_geocodeResult = this.m_geocodableAddr.geocode(this.m_constraints);
                break;
            }
            case 1: {
                this.m_geocodeResult = this.m_geocodableAddr.geocodePostal(this.m_constraints);
                break;
            }
            case 4: {
                this.m_geocodeResult = this.m_geocodableAddr.geocodeGeographic(this.m_constraints);
                break;
            }
            case 5: {
                this.m_geocodeResult = this.m_geocodableAddr.standardize(this.m_constraints);
                break;
            }
            case 6: {
                this.m_geocodeResult = this.m_geocodableAddr.browse(this.m_constraints);
                break;
            }
            default: {
                if (geocodeType >= 100) {
                    this.m_geocodeResult = this.m_geocodableAddr.geocodeCustom(geocodeType, this.m_constraints);
                    break;
                }
                throw new MMGeneralGeocoderException(2303, new String[]{String.valueOf(geocodeType)});
            }
        }
        return this.m_geocodeResult;
    }

    private void prepareConstraints(IConstraints constraints) {
        if (constraints == null) {
            this.m_constraints = new Constraints();
            this.m_constraints.setClientCoordinateSystem(CoordSysConstants.longLatWGS84);
        } else {
            this.m_constraints = new Constraints(constraints);
            if (this.m_constraints.getClientCoordinateSystemObject() == null) {
                this.m_constraints.setClientCoordinateSystem(CoordSysConstants.longLatWGS84);
            }
            if (this.m_constraints.getClientLocale() == null) {
                this.m_constraints.setClientLocale(Locale.US);
            }
        }
    }

    @Override
    public CandidateAddress getCandidateAt(int index) throws MapMarkerInternalException {
        return this.getCandidateAt(index, this.m_constraints);
    }

    @Override
    public CandidateAddress getCandidateAt(int index, IConstraints constraints) throws MapMarkerInternalException {
        if (this.m_geocodeResult == null || this.m_geocodableAddr == null || index > this.m_geocodeResult.getNumberCandidates()) {
            return null;
        }
        CandidateAddress addr = this.m_geocodableAddr.getIndexedCandidate(index, constraints);
        AddressUtils.fixCoordSysString(addr, constraints);
        return addr;
    }

    @Override
    public CandidateAddress reinterpolateForSelectedRange(int candidateIndex, int rangeIndex) throws MapMarkerInternalException {
        CandidateAddress ca = this.m_geocodableAddr.getIndexedCandidate(candidateIndex, this.m_constraints);
        CandidateRange cr = null;
        cr = ca.getRangeAt(rangeIndex);
        if (cr != null) {
            ca = this.m_geocodableAddr.getIndexedCoords(candidateIndex, cr, this.m_constraints);
            AddressUtils.fixCoordSysString(ca, this.m_constraints);
            return ca;
        }
        return null;
    }

    @Override
    public Address getParsedAddress() {
        return this.m_constraints.getHandler().getParsedAddress();
    }

    public static void main(String[] args) {
        String street = "Amsterdamerstr 21";
        String last = "Berlin";
        String postal = "13347";
        String iso = "DEU";
        Constraints constraints = new Constraints();
        constraints.setMaxRanges(5);
        constraints.setMustMatchAddressNumber(false);
        boolean bTryReinterpolate = false;
        int candNum = 0;
        int rangeNum = 0;
        AddressImpl input = new AddressImpl();
        if (args.length == 3) {
            input.setCountry(args[0]);
            input.setMainAddress(args[1]);
            input.setPostAddress(args[2]);
        } else if (args.length == 4) {
            input.setCountry(args[0]);
            input.setMainAddress(args[1]);
            input.setAreaName3(args[2]);
            input.setPostCode1(args[3]);
        } else if (args.length == 6) {
            input.setCountry(args[0]);
            input.setMainAddress(args[1]);
            input.setAreaName3(args[2]);
            input.setPostCode1(args[3]);
            bTryReinterpolate = true;
            candNum = Integer.parseInt(args[4]);
            rangeNum = Integer.parseInt(args[5]);
        } else {
            input.setCountry(iso);
            input.setMainAddress(street);
            input.setAreaName3(last);
            input.setPostCode1(postal);
        }
        MMJGeocoderInstance engine = new MMJGeocoderInstance();
        try {
            GeocodeResult resp = engine.geocode(0, input, constraints);
            int count = resp.getNumberCandidates();
            System.out.println("total " + count);
            System.out.println("close " + resp.getNumberCloseCandidates());
            for (int i = 0; i < count; ++i) {
                CandidateAddress cand = engine.getCandidateAt(i);
                System.out.println(cand.toString());
                System.out.println(cand.getLocationPoint().toString());
            }
            if (bTryReinterpolate) {
                CandidateAddress ucand = engine.reinterpolateForSelectedRange(candNum, rangeNum);
                System.out.println();
                System.out.println("*** interpolate ***");
                System.out.println();
                System.out.println(ucand.toString());
                System.out.println(ucand.getLocationPoint().toString());
            }
        }
        catch (MapMarkerInternalException e) {
            System.out.println("Error encountered: ");
            e.printStackTrace();
        }
        catch (MMInternalFatalException e) {
            System.out.println("Error encountered: ");
            e.printStackTrace();
        }
    }

    @Override
    public List filterReturnCandidates() throws MapMarkerInternalException {
        int returnCount = -1;
        boolean returnCloseOnly = false;
        if (this.m_constraints != null) {
            returnCount = this.m_constraints.getMaxCandidates();
            returnCloseOnly = this.m_constraints.isReturnCloseCandidatesOnly();
        }
        if (returnCloseOnly && this.m_geocodeResult.getNumberCloseCandidates() == 0) {
            returnCount = 0;
        } else if (returnCloseOnly && this.m_geocodeResult.getNumberCloseCandidates() < returnCount) {
            returnCount = this.m_geocodeResult.getNumberCloseCandidates();
        } else if (returnCloseOnly && returnCount < 0) {
            returnCount = this.m_geocodeResult.getNumberCloseCandidates();
        } else if (!returnCloseOnly && returnCount < 0) {
            returnCount = this.m_geocodeResult.getNumberCandidates();
        } else if (!returnCloseOnly && this.m_geocodeResult.getNumberCandidates() < returnCount) {
            returnCount = this.m_geocodeResult.getNumberCandidates();
        }
        if (returnCount > 0) {
            return this.createCandidateList(returnCount);
        }
        return null;
    }

    @Override
    public List createCandidateList(int count) throws MapMarkerInternalException {
        ArrayList<CandidateAddress> uCands = new ArrayList<CandidateAddress>(count);
        CandidateAddress uCand = null;
        for (int i = 0; i < count; ++i) {
            uCand = this.getCandidateAt(i);
            if (uCand == null) continue;
            uCands.add(uCand);
        }
        return uCands;
    }

    public IDictionarySearchOrder getDictionaryInformation(Address addr, IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        this.m_geocodeResult = null;
        this.m_geocodableAddr = null;
        this.m_geocodableAddr = GeocodableAddressFactory.createGeocodableAddress(addr, constraints);
        if (this.m_geocodableAddr == null) {
            throw new MMGeneralGeocoderException(2302);
        }
        ICountryGeographyInfo info = this.m_geocodableAddr.getCountryGeographyInfo();
        List dictList = info.getDictionaryInfos();
        int count = dictList.size();
        DictionarySearchOrder order = new DictionarySearchOrder(count);
        for (int i = 0; i < count; ++i) {
            IDictionaryGeographyInfo dgInfo = (IDictionaryGeographyInfo)dictList.get(i);
            order.loadDictionaryFromPath(i + 1, dgInfo.getDictionaryPath(), dgInfo.isUserDictionary());
        }
        return order;
    }
}

