/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.user;

import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.util.DoublePoint;

public class ReverseGeocodeLocation {
    public static final Distance DEFAULT_DISTANCE = new Distance(150.0, com.mapinfo.unit.LinearUnit.meter);
    public static final Distance MAX_DISTANCE = new Distance(1.0, com.mapinfo.unit.LinearUnit.mile);
    public static final Length DISTANCE_DEFAULT = new Length(150.0, LinearUnit.METER);
    public static final Length DISTANCE_MAX = new Length(1.0, LinearUnit.MILE);
    private DirectPosition m_position;
    private CoordSys m_coordSys;
    private Distance m_distance;
    private Length m_distanceAsLength = null;

    public ReverseGeocodeLocation(DoublePoint position, com.mapinfo.coordsys.CoordSys coordSys, Distance distance) {
        this.setPosition(MidevConversionUtils.convertToDirectPosition(position));
        if (coordSys != null) {
            this.setCoordSys(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(coordSys.getSrsName()));
        }
        this.setDistance(MidevConversionUtils.convertToLength(distance));
    }

    public ReverseGeocodeLocation(DirectPosition position, CoordSys coordSys, Length distance) {
        this.setPosition(position);
        this.setCoordSys(coordSys);
        this.setDistance(distance);
    }

    public ReverseGeocodeLocation(DoublePoint position, Distance distance) {
        this(MidevConversionUtils.convertToDirectPosition(position), null, MidevConversionUtils.convertToLength(distance));
    }

    public ReverseGeocodeLocation(DirectPosition position, Length distance) {
        this(position, (CoordSys)null, distance);
    }

    public ReverseGeocodeLocation(DoublePoint position) {
        this(new DirectPosition(position.x, position.y), null, DISTANCE_DEFAULT);
    }

    public ReverseGeocodeLocation(DirectPosition position) {
        this(position, (CoordSys)null, DISTANCE_DEFAULT);
    }

    public void setPosition(DoublePoint position) {
        if (position == null) {
            throw new IllegalArgumentException();
        }
        this.m_position = new DirectPosition(position.x, position.y);
    }

    public void setPosition(DirectPosition position) {
        if (position == null) {
            throw new IllegalArgumentException();
        }
        this.m_position = position;
    }

    public DoublePoint getPosition() {
        return new DoublePoint(this.m_position.getX(), this.m_position.getY());
    }

    public DirectPosition getPositionPoint() {
        return this.m_position;
    }

    public void setCoordSys(com.mapinfo.coordsys.CoordSys coordSys) {
        if (coordSys == null) {
            this.m_coordSys = null;
            return;
        }
        this.m_coordSys = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(coordSys.getSrsName());
    }

    public void setCoordSys(CoordSys coordSys) {
        this.m_coordSys = coordSys;
    }

    public com.mapinfo.coordsys.CoordSys getCoordSys() {
        return MidevConversionUtils.getLegacyCoordSys(this.m_coordSys);
    }

    public CoordSys getCoordSysObject() {
        return this.m_coordSys;
    }

    public void setDistance(Distance distance) {
        if (!this.isValidDistance(distance)) {
            throw new IllegalArgumentException();
        }
        this.m_distance = distance;
    }

    public void setDistance(Length distance) {
        if (!this.isValidDistance(distance)) {
            throw new IllegalArgumentException();
        }
        this.m_distance = MidevConversionUtils.convertToDistance(distance);
        this.m_distanceAsLength = distance;
    }

    public Distance getDistance() {
        return this.m_distance;
    }

    public Length getDistanceAsLength() {
        if (this.m_distanceAsLength == null) {
            this.m_distanceAsLength = MidevConversionUtils.convertToLength(this.m_distance);
        }
        return this.m_distanceAsLength;
    }

    private boolean isValidDistance(Distance distance) {
        return distance != null && distance.getScalarValue(MAX_DISTANCE.getUnit()) <= MAX_DISTANCE.getScalarValue();
    }

    private boolean isValidDistance(Length distance) {
        return distance != null && distance.getValue(DISTANCE_MAX.getUnit()) <= DISTANCE_MAX.getValue();
    }
}

