/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.Comparator;
import java.util.List;

public class AggregateComparator<T>
implements Comparator<T> {
    private final List<Comparator<T>> m_comparators;
    private final boolean m_debugOn;

    public AggregateComparator(List<Comparator<T>> comparators) {
        this(comparators, false);
    }

    public AggregateComparator(List<Comparator<T>> comparators, boolean debugOn) {
        this.m_comparators = comparators;
        this.m_debugOn = debugOn;
    }

    @Override
    public int compare(T o1, T o2) {
        for (Comparator<T> comparator : this.m_comparators) {
            int result = comparator.compare(o1, o2);
            if (result == 0) continue;
            if (this.m_debugOn) {
                this.debugChoice(o1, o2, comparator, result);
            }
            return result;
        }
        if (this.m_debugOn) {
            this.debugNoChoice(o1, o2);
        }
        return 0;
    }

    private void debugNoChoice(T o1, T o2) {
        MMJLog.getLog().debug("Making NO choice (equal)");
        MMJLog.getLog().debug("Obj1: ");
        MMJLog.getLog().debug("Obj1: ", o1);
        MMJLog.getLog().debug("Obj2: ");
        MMJLog.getLog().debug("Obj2: ", o2);
    }

    private void debugChoice(T o1, T o2, Comparator<T> comparator, int result) {
        T other;
        T best;
        MMJLog.getLog().debug("Making a choice based on comparator: " + comparator.getClass().getName());
        if (result < 0) {
            best = o1;
            other = o2;
        } else {
            best = o2;
            other = o1;
        }
        MMJLog.getLog().debug("Chose: ");
        MMJLog.getLog().debug("Chose: ", best);
        MMJLog.getLog().debug("Over: ");
        MMJLog.getLog().debug("Over: ", other);
    }
}

