/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BlobUtilities {
    private BlobUtilities() {
    }

    public static boolean isEmpty(byte[] blob) {
        return blob == null || blob.length == 0;
    }

    public static String[] decodeStringArray(byte[] blob) throws IOException {
        if (BlobUtilities.isEmpty(blob)) {
            throw new IllegalArgumentException();
        }
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(blob));
        int count = stream.readShort();
        if (count <= 0) {
            throw new IllegalStateException();
        }
        String[] values = new String[count];
        for (int i = 0; i < count; ++i) {
            values[i] = stream.readUTF();
        }
        return values;
    }

    public static byte[] encode(String[] data) throws IOException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(byteStream);
        stream.writeShort(data.length);
        for (String entry : data) {
            stream.writeUTF(entry);
        }
        return byteStream.toByteArray();
    }
}

