/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.io.DataInput;
import java.io.IOException;

public class DataInputUtilities {
    public static final int BYTES_IN_BYTE = 1;
    public static final int BYTES_IN_BOOLEAN = 1;
    public static final int BYTES_IN_CHAR = 2;
    public static final int BYTES_IN_DOUBLE = 8;
    public static final int BYTES_IN_FLOAT = 4;
    public static final int BYTES_IN_INT = 4;
    public static final int BYTES_IN_LONG = 8;
    public static final int BYTES_IN_SHORT = 2;

    public static byte[] readByteArray(DataInput in, int numBytes) throws IOException {
        byte[] bytes = new byte[numBytes];
        in.readFully(bytes);
        return bytes;
    }

    public static short getUnsignedByteFromByteArray(int byteIndex, byte[] bytes) {
        return (short)(bytes[byteIndex] & 0xFF);
    }

    public static int getUnsignedShortFromByteArray(int byteIndex, byte[] bytes) {
        return (bytes[byteIndex] & 0xFF) << 8 | bytes[byteIndex + 1] & 0xFF;
    }

    public static char getCharFromByteArray(int byteIndex, byte[] bytes) {
        return (char)(bytes[byteIndex] << 8 | bytes[byteIndex + 1] & 0xFF);
    }

    public static double getDoubleFromByteArray(int byteIndex, byte[] bytes) {
        return Double.longBitsToDouble(DataInputUtilities.getLongFromByteArray(byteIndex, bytes));
    }

    public static int getIntFromByteArray(int byteIndex, byte[] bytes) {
        return (bytes[byteIndex] & 0xFF) << 24 | (bytes[byteIndex + 1] & 0xFF) << 16 | (bytes[byteIndex + 2] & 0xFF) << 8 | bytes[byteIndex + 3] & 0xFF;
    }

    public static float getFloatFromByteArray(int byteIndex, byte[] bytes) {
        return Float.intBitsToFloat(DataInputUtilities.getIntFromByteArray(byteIndex, bytes));
    }

    public static long getLongFromByteArray(int byteIndex, byte[] bytes) {
        return (long)(bytes[byteIndex] & 0xFF) << 56 | (long)(bytes[byteIndex + 1] & 0xFF) << 48 | (long)(bytes[byteIndex + 2] & 0xFF) << 40 | (long)(bytes[byteIndex + 3] & 0xFF) << 32 | (long)(bytes[byteIndex + 4] & 0xFF) << 24 | (long)(bytes[byteIndex + 5] & 0xFF) << 16 | (long)(bytes[byteIndex + 6] & 0xFF) << 8 | (long)(bytes[byteIndex + 7] & 0xFF);
    }

    public static short getShortFromByteArray(int byteIndex, byte[] bytes) {
        return (short)(bytes[byteIndex] << 8 | bytes[byteIndex + 1] & 0xFF);
    }
}

