/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

public abstract class DebugLevel {
    public static final int COMPONENT_SERVER = 0;
    public static final int COMPONENT_GEOCODABLES = 1;
    public static final int COMPONENT_PARSER = 2;
    public static final int COMPONENT_DATA_ACCESS = 3;
    public static final int COMPONENT_MATCHER = 4;
    public static final int COMPONENT_DATA_CREATE = 5;
    public static final int COMPONENT_SINGLE_LINE = 6;
    private static final int MAX_COMPONENT = 6;
    public static final int DEBUG_OFF = 0;
    public static final int DEBUG_LOW = 1;
    public static final int DEBUG_MEDIUM = 2;
    public static final int DEBUG_HIGH = 3;
    private static final int DEBUG_MAX = 3;
    private static DebugSettings[] debugSettings = DebugLevel.buildDebugSettings();
    private static int m_DebugLevel = 0;
    private static final int NUM_BITS_PER_SETTING = 2;

    public static void setDebugLevel(int debugLevel) {
        m_DebugLevel = debugLevel;
    }

    public static int getDebugLevel(int component) {
        if (m_DebugLevel == 0) {
            return 0;
        }
        return DebugLevel.decodeDebugLevel(debugSettings[component], m_DebugLevel);
    }

    public static int createDebugLevel(int component, int componentDebugLevel, int currentDebugLevel) {
        DebugSettings setting = debugSettings[component];
        int componentLevelMask = componentDebugLevel << setting.getHighBitPosition() - 1;
        int newLevel = currentDebugLevel | componentLevelMask;
        return newLevel;
    }

    private static int decodeDebugLevel(DebugSettings debugSettings, int constraintsDebug) {
        int bitMask = debugSettings.getBitMask();
        int highBitPosition = debugSettings.getHighBitPosition();
        short temp = (short)(constraintsDebug & bitMask);
        temp = (short)(temp >> highBitPosition - 1);
        return temp;
    }

    private static DebugSettings[] buildDebugSettings() {
        DebugSettings[] settings = new DebugSettings[7];
        int startBit = 0;
        for (int i = 0; i <= 6; ++i) {
            settings[i] = new DebugSettings(3 << startBit, startBit + 2 - 1);
            startBit += 2;
        }
        return settings;
    }

    public static String toLevelString() {
        return String.valueOf(m_DebugLevel);
    }

    private static class DebugSettings {
        private int bitMask;
        private int highBitPosition;

        public DebugSettings(int bitMask, int highBitPosition) {
            this.bitMask = bitMask;
            this.highBitPosition = highBitPosition;
        }

        public int getBitMask() {
            return this.bitMask;
        }

        public int getHighBitPosition() {
            return this.highBitPosition;
        }
    }
}

