/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.EnglishAbbreviationItem;
import com.mapinfo.mapmarker.utils.FileUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class EnglishNumericAbbreviations {
    private static final String ABBR_FILE = "com.mapinfo.mapmarker.utils.EnglishNumericAbbreviations.properties";
    private static final Map m_abbreviationMap;
    private static final Map m_expandedNameMap;

    private EnglishNumericAbbreviations() {
    }

    public static String getExpandedName(String abbr) {
        EnglishAbbreviationItem item = (EnglishAbbreviationItem)m_abbreviationMap.get(abbr);
        if (item != null) {
            return item.getExpandedName();
        }
        return null;
    }

    public static String getProperName(String abbr) {
        EnglishAbbreviationItem item = (EnglishAbbreviationItem)m_abbreviationMap.get(abbr);
        if (item != null) {
            return item.getProperName();
        }
        return null;
    }

    public static String getAbbrFromValue(String val) {
        EnglishAbbreviationItem item = (EnglishAbbreviationItem)m_expandedNameMap.get(val);
        if (item != null) {
            return item.getAbbr();
        }
        return null;
    }

    static {
        Properties props = null;
        try {
            props = FileUtilities.loadProperties(ABBR_FILE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        m_abbreviationMap = new HashMap(props.size());
        m_expandedNameMap = new HashMap(props.size());
        for (String key : props.keySet()) {
            EnglishAbbreviationItem item = new EnglishAbbreviationItem(key, (String)props.get(key));
            m_abbreviationMap.put(item.getAbbr(), item);
            m_expandedNameMap.put(item.getExpandedName(), item);
        }
    }
}

