/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

public class IntArray {
    private static final int DEFAULT_CAPACITY = 10;
    private int[] m_data;
    private int m_count = 0;

    public IntArray() {
        this(10);
    }

    public IntArray(int capacity) {
        this.m_data = new int[capacity];
    }

    public void add(int val) {
        this.ensureCapacity(this.m_count + 1);
        this.m_data[this.m_count] = val;
        ++this.m_count;
    }

    public int length() {
        return this.m_count;
    }

    public int get(int index) {
        if (index >= this.m_count) {
            return -1;
        }
        return this.m_data[index];
    }

    public boolean contains(int val) {
        for (int n = 0; n < this.m_count; ++n) {
            if (this.m_data[n] != val) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.m_data = new int[10];
        this.m_count = 0;
    }

    public int[] asArray() {
        int[] result = new int[this.m_count];
        System.arraycopy(this.m_data, 0, result, 0, this.m_count);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.m_count; ++i) {
            sb.append(this.m_data[i]);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    private void ensureCapacity(int reqCapacity) {
        int oldCapacity = this.m_data.length;
        if (reqCapacity > oldCapacity) {
            int newCapacity = (int)Math.max((double)oldCapacity * 1.5, (double)reqCapacity);
            int[] newData = new int[newCapacity];
            System.arraycopy(this.m_data, 0, newData, 0, oldCapacity);
            this.m_data = newData;
        }
    }
}

