/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.util.Arrays;

public class IntObjMap {
    private static final int DEFAULT_HASH_CAPACITY = 8;
    private static final float DEFAULT_LOAD_FACTOR = 1.5f;
    private int[] m_key = new int[8];
    private Object[] m_value = new Object[8];
    private int m_keyCount;
    private int[] m_keyPointer = new int[8];
    private int[] m_hashTable = new int[8];
    private int m_threshold = 8;

    public IntObjMap() {
        Arrays.fill(this.m_hashTable, -1);
        Arrays.fill(this.m_keyPointer, -1);
    }

    public IntObjMap(IntObjMap map) {
        this.m_key = new int[map.m_key.length];
        this.m_value = new Object[map.m_value.length];
        this.m_keyPointer = new int[map.m_keyPointer.length];
        this.m_hashTable = new int[map.m_hashTable.length];
        System.arraycopy(map.m_key, 0, this.m_key, 0, map.m_key.length);
        System.arraycopy(map.m_value, 0, this.m_value, 0, map.m_value.length);
        System.arraycopy(map.m_keyPointer, 0, this.m_keyPointer, 0, map.m_keyPointer.length);
        System.arraycopy(map.m_hashTable, 0, this.m_hashTable, 0, map.m_hashTable.length);
        this.m_keyCount = map.m_keyCount;
        this.m_threshold = map.m_threshold;
    }

    public void put(int key, Object value) {
        int hashIndex = this.hash(key) & this.m_hashTable.length - 1;
        int i = this.m_hashTable[hashIndex];
        while (i >= 0) {
            if (key == this.m_key[i] && this.m_value[i] != null) {
                this.m_value[i] = value;
                return;
            }
            i = this.m_keyPointer[i];
        }
        this.ensureKeyCapacity(this.m_keyCount + 1);
        this.m_key[this.m_keyCount] = key;
        this.m_value[this.m_keyCount] = value;
        this.m_keyPointer[this.m_keyCount] = this.m_hashTable[hashIndex];
        this.m_hashTable[hashIndex] = this.m_keyCount++;
        if (this.m_keyCount >= this.m_threshold) {
            this.resize(2 * this.m_hashTable.length);
        }
    }

    public Object get(int key) {
        Object result = null;
        int hashIndex = this.hash(key) & this.m_hashTable.length - 1;
        int i = this.m_hashTable[hashIndex];
        while (i >= 0) {
            if (key == this.m_key[i]) {
                result = this.m_value[i];
                break;
            }
            i = this.m_keyPointer[i];
        }
        return result;
    }

    public int[] keys() {
        int[] result = new int[this.m_keyCount];
        System.arraycopy(this.m_key, 0, result, 0, this.m_keyCount);
        return result;
    }

    public Object[] values() {
        Object[] result = new Object[this.m_keyCount];
        System.arraycopy(this.m_value, 0, result, 0, this.m_keyCount);
        return result;
    }

    public int size() {
        return this.m_keyCount;
    }

    private void resize(int newSize) {
        this.m_hashTable = new int[newSize];
        Arrays.fill(this.m_hashTable, -1);
        int i = 0;
        while (i < this.m_keyCount) {
            int hashIndex = this.hash(this.m_key[i]) & this.m_hashTable.length - 1;
            this.m_keyPointer[i] = this.m_hashTable[hashIndex];
            this.m_hashTable[hashIndex] = i++;
        }
        this.m_threshold = (int)((float)newSize * 1.5f);
    }

    private int hash(int key) {
        int result = 17;
        result = result * 37 + key;
        return result;
    }

    private void ensureKeyCapacity(int reqCapacity) {
        int oldCapacity = this.m_key.length;
        if (reqCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 2;
            int[] newKey = new int[newCapacity];
            System.arraycopy(this.m_key, 0, newKey, 0, oldCapacity);
            this.m_key = newKey;
            Object[] newValue = new Object[newCapacity];
            System.arraycopy(this.m_value, 0, newValue, 0, oldCapacity);
            this.m_value = newValue;
            int[] newKeyPointer = new int[newCapacity];
            System.arraycopy(this.m_keyPointer, 0, newKeyPointer, 0, oldCapacity);
            this.m_keyPointer = newKeyPointer;
            Arrays.fill(this.m_keyPointer, oldCapacity, newCapacity, -1);
        }
    }
}

