/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.util.ArrayList;
import java.util.Collections;

public class IntegerSequenceDivider {
    protected ArrayList m_segments;
    protected int m_oddEvenBoth;
    static final int NO_OVERLAP = 0;
    static final int RANGE_OVERLAPS_SEGMENT_START = 1;
    static final int RANGE_OVERLAPS_SEGMENT_END = 2;
    static final int SEGMENT_COMPLETELY_CONTAINS_RANGE = 3;
    static final int RANGE_COMPLETELY_CONTAINS_SEGMENT = 4;
    public static final int ODDEVEN_ODD = 1;
    public static final int ODDEVEN_EVEN = 2;
    public static final int ODDEVEN_BOTH = 0;

    public IntegerSequenceDivider(int start, int end, int oddEvenBoth) {
        this.m_oddEvenBoth = oddEvenBoth;
        this.m_segments = new ArrayList();
        this.m_segments.add(new IntegerSegment(start, end));
    }

    public boolean removeRange(int start, int end) {
        if (this.m_segments.isEmpty()) {
            return false;
        }
        IntegerSegment range = new IntegerSegment(start, end);
        int count = this.m_segments.size();
        boolean bChanged = false;
        IntegerSegment curSeg = null;
        block7: for (int i = count - 1; i >= 0; --i) {
            curSeg = (IntegerSegment)this.m_segments.get(i);
            int overlap = curSeg.compareToRange(range);
            switch (overlap) {
                case 0: {
                    continue block7;
                }
                case 4: {
                    bChanged = true;
                    this.m_segments.remove(i);
                    continue block7;
                }
                case 2: {
                    bChanged = true;
                    curSeg.setEnd(this.getPrevInSequence(range.getStart()));
                    continue block7;
                }
                case 1: {
                    bChanged = true;
                    curSeg.setStart(this.getNextInSequence(range.getEnd()));
                    continue block7;
                }
                case 3: {
                    int origEnd = curSeg.getEnd();
                    bChanged = true;
                    curSeg.setEnd(this.getPrevInSequence(range.getStart()));
                    int newSegStart = this.getNextInSequence(range.getEnd());
                    if (!this.isValidSegment(newSegStart, origEnd)) continue block7;
                    IntegerSegment newSeg = new IntegerSegment(newSegStart, origEnd);
                    this.m_segments.add(newSeg);
                }
            }
        }
        return bChanged;
    }

    public ArrayList getRemainingRanges() {
        if (this.m_segments.size() > 1) {
            Collections.sort(this.m_segments);
        }
        return this.m_segments;
    }

    protected int getNextInSequence(int newPos) {
        if (this.m_oddEvenBoth == 0) {
            return newPos + 1;
        }
        if (this.m_oddEvenBoth == 1 && newPos % 2 == 0) {
            return newPos + 1;
        }
        if (this.m_oddEvenBoth == 2 && newPos % 2 == 1) {
            return newPos + 1;
        }
        return newPos + 2;
    }

    protected int getPrevInSequence(int newPos) {
        if (this.m_oddEvenBoth == 0) {
            return newPos - 1;
        }
        if (this.m_oddEvenBoth == 1 && newPos % 2 == 0) {
            return newPos - 1;
        }
        if (this.m_oddEvenBoth == 2 && newPos % 2 == 1) {
            return newPos - 1;
        }
        return newPos - 2;
    }

    protected boolean isValidSegment(int start, int end) {
        if (start > end) {
            return false;
        }
        return end - start != 1 || this.m_oddEvenBoth == 0;
    }

    public class IntegerSegment
    implements Comparable {
        private int start;
        private int end;

        public IntegerSegment(int startNum, int endNum) {
            if (startNum > endNum) {
                int tmp = startNum;
                startNum = endNum;
                endNum = tmp;
            }
            this.setStart(startNum);
            this.setEnd(endNum);
        }

        int compareToRange(IntegerSegment range) {
            if (range.getEnd() < this.getStart()) {
                return 0;
            }
            if (range.getStart() > this.getEnd()) {
                return 0;
            }
            if (range.getStart() <= this.getStart()) {
                if (range.getEnd() < this.getEnd()) {
                    return 1;
                }
                return 4;
            }
            if (range.getEnd() >= this.getEnd()) {
                return 2;
            }
            return 3;
        }

        public int getStart() {
            return this.start;
        }

        protected void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        protected void setEnd(int end) {
            this.end = end;
        }

        public int compareTo(Object obj) {
            IntegerSegment that = (IntegerSegment)obj;
            if (this.getStart() < that.getStart()) {
                return -1;
            }
            if (this.getStart() > that.getStart()) {
                return 1;
            }
            if (this.getEnd() < that.getEnd()) {
                return -1;
            }
            if (this.getEnd() > that.getEnd()) {
                return 1;
            }
            return 0;
        }
    }
}

