/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.SeekableDataInputNIO;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class LRUFileCache {
    private final int m_maxItems;
    private final Map m_cache;
    private CacheEntry m_firstEntry;
    private CacheEntry m_lastEntry;

    LRUFileCache(int maxItems) {
        this.m_maxItems = maxItems;
        this.m_cache = new HashMap(maxItems);
    }

    public SeekableDataInput get(String filename) throws IOException {
        CacheEntry newEntry = (CacheEntry)this.m_cache.get(filename);
        if (newEntry == null) {
            SeekableDataInputNIO stream = new SeekableDataInputNIO(new File(filename), true);
            this.put(filename, stream);
            return stream;
        }
        if (newEntry != this.m_firstEntry) {
            if (newEntry.m_next != null) {
                newEntry.m_next.m_prev = newEntry.m_prev;
            } else {
                this.m_lastEntry = newEntry.m_prev;
            }
            newEntry.m_prev.m_next = newEntry.m_next;
            this.addFirstEntry(newEntry);
        }
        return newEntry.m_stream;
    }

    private void put(String filename, SeekableDataInput stream) throws IOException {
        if (this.m_cache.size() == this.m_maxItems) {
            this.removeLastEntry();
        }
        CacheEntry newFirstEntry = new CacheEntry(filename, stream);
        this.addFirstEntry(newFirstEntry);
        this.m_cache.put(filename, newFirstEntry);
    }

    private void addFirstEntry(CacheEntry newFirstEntry) {
        newFirstEntry.m_prev = null;
        if (this.m_firstEntry != null) {
            newFirstEntry.m_next = this.m_firstEntry;
            this.m_firstEntry.m_prev = newFirstEntry;
        } else {
            newFirstEntry.m_next = null;
            this.m_lastEntry = newFirstEntry;
        }
        this.m_firstEntry = newFirstEntry;
    }

    private void removeLastEntry() throws IOException {
        this.m_lastEntry.m_stream.close();
        this.m_cache.remove(this.m_lastEntry.m_filename);
        if (this.m_lastEntry.m_prev != null) {
            this.m_lastEntry.m_prev.m_next = null;
            this.m_lastEntry = this.m_lastEntry.m_prev;
        } else {
            this.m_firstEntry = null;
            this.m_lastEntry = null;
        }
    }

    private static class CacheEntry {
        private final String m_filename;
        private final SeekableDataInput m_stream;
        private CacheEntry m_next;
        private CacheEntry m_prev;

        private CacheEntry(String filename, SeekableDataInput stream) {
            this.m_filename = filename;
            this.m_stream = stream;
        }
    }
}

