/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.util.HashMap;
import java.util.Map;

public class LRUHashMapCache {
    private final int m_maxItems;
    private final Map m_cache;
    private CacheEntry m_firstEntry;
    private CacheEntry m_lastEntry;

    public LRUHashMapCache(int maxItems) {
        this.m_maxItems = maxItems < 0 ? 0 : maxItems;
        this.m_cache = new HashMap(maxItems);
    }

    public Object get(Object key) {
        CacheEntry newEntry = (CacheEntry)this.m_cache.get(key);
        if (newEntry == null) {
            return null;
        }
        if (newEntry != this.m_firstEntry) {
            if (newEntry.m_next != null) {
                newEntry.m_next.m_prev = newEntry.m_prev;
            } else {
                this.m_lastEntry = newEntry.m_prev;
            }
            newEntry.m_prev.m_next = newEntry.m_next;
            this.addFirstEntry(newEntry);
        }
        return newEntry.m_obj;
    }

    public void put(Object key, Object obj) {
        if (this.m_maxItems == 0) {
            return;
        }
        if (this.m_cache.size() == this.m_maxItems) {
            this.removeLastEntry();
        }
        CacheEntry newFirstEntry = new CacheEntry(key, obj);
        this.addFirstEntry(newFirstEntry);
        this.m_cache.put(key, newFirstEntry);
    }

    private void addFirstEntry(CacheEntry newFirstEntry) {
        newFirstEntry.m_prev = null;
        if (this.m_firstEntry != null) {
            newFirstEntry.m_next = this.m_firstEntry;
            this.m_firstEntry.m_prev = newFirstEntry;
        } else {
            newFirstEntry.m_next = null;
            this.m_lastEntry = newFirstEntry;
        }
        this.m_firstEntry = newFirstEntry;
    }

    private void removeLastEntry() {
        this.m_cache.remove(this.m_lastEntry.m_key);
        if (this.m_lastEntry.m_prev != null) {
            this.m_lastEntry.m_prev.m_next = null;
            this.m_lastEntry = this.m_lastEntry.m_prev;
        } else {
            this.m_firstEntry = null;
            this.m_lastEntry = null;
        }
    }

    private static class CacheEntry {
        private final Object m_key;
        private final Object m_obj;
        private CacheEntry m_next;
        private CacheEntry m_prev;

        private CacheEntry(Object key, Object obj) {
            this.m_key = key;
            this.m_obj = obj;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("key: " + this.m_key + "\n");
            sb.append("obj: " + this.m_obj + "\n");
            sb.append("next: " + (this.m_next == null ? "null\n" : "not null"));
            sb.append("prev: " + (this.m_prev == null ? "null\n" : "not null"));
            return sb.toString();
        }
    }
}

