/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.DataInputUtilities;
import com.mapinfo.mapmarker.utils.MappedByteBufferProviderFactory;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.SeekableDataInputUtilities;
import com.mapinfo.mapmarker.utils.SlicedMappedByteBuffer;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.BufferUnderflowException;

public class MappedSeekableDataInputStream
extends InputStream
implements SeekableDataInput {
    private SlicedMappedByteBuffer m_buffer;
    private final int m_length;

    private MappedSeekableDataInputStream(SlicedMappedByteBuffer buffer) {
        this.m_buffer = buffer;
        this.m_length = buffer.limit();
    }

    public static MappedSeekableDataInputStream getInstance(File file) throws IOException {
        SlicedMappedByteBuffer buffer = MappedByteBufferProviderFactory.getProvider().get(file);
        if (buffer == null) {
            return null;
        }
        return new MappedSeekableDataInputStream(buffer);
    }

    public static void releaseAllStreams() {
        MappedByteBufferProviderFactory.getProvider().releaseAllBuffers();
    }

    @Override
    public int available() {
        return this.m_buffer.remaining();
    }

    @Override
    public long skip(long n) {
        return this.skipBytes((int)n);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int markLimit) {
        this.m_buffer.mark();
    }

    @Override
    public void reset() {
        this.m_buffer.reset();
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        if (length > this.available()) {
            if (this.available() == 0) {
                return -1;
            }
            length = this.available();
        }
        this.m_buffer.get(b, offset, length);
        return length;
    }

    @Override
    public long length() {
        return this.m_length;
    }

    @Override
    public long getFilePointer() {
        return this.m_buffer.position();
    }

    @Override
    public void seek(long pos) {
        this.m_buffer.position((int)pos);
    }

    @Override
    public void close() {
        this.m_buffer = null;
    }

    @Override
    public int read() {
        try {
            return this.m_buffer.get() & 0xFF;
        }
        catch (BufferUnderflowException BUEx) {
            return -1;
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.m_buffer.get();
        }
        catch (BufferUnderflowException BUEx) {
            throw new EOFException();
        }
    }

    private byte[] getTemp(int size) throws IOException {
        byte[] temp = new byte[size];
        this.readFully(temp);
        return temp;
    }

    @Override
    public char readChar() throws IOException {
        return DataInputUtilities.getCharFromByteArray(0, this.getTemp(2));
    }

    @Override
    public double readDouble() throws IOException {
        return DataInputUtilities.getDoubleFromByteArray(0, this.getTemp(8));
    }

    @Override
    public float readFloat() throws IOException {
        return DataInputUtilities.getFloatFromByteArray(0, this.getTemp(4));
    }

    @Override
    public int readInt() throws IOException {
        return DataInputUtilities.getIntFromByteArray(0, this.getTemp(4));
    }

    @Override
    public int readUnsignedByte() throws IOException {
        try {
            return this.m_buffer.get() & 0xFF;
        }
        catch (BufferUnderflowException BUEx) {
            throw new EOFException();
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return DataInputUtilities.getUnsignedShortFromByteArray(0, this.getTemp(2));
    }

    @Override
    public long readLong() throws IOException {
        return DataInputUtilities.getLongFromByteArray(0, this.getTemp(8));
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            return this.m_buffer.get() != 0;
        }
        catch (BufferUnderflowException BUEx) {
            throw new EOFException();
        }
    }

    @Override
    public short readShort() throws IOException {
        return DataInputUtilities.getShortFromByteArray(0, this.getTemp(2));
    }

    @Override
    public int skipBytes(int n) {
        int available = this.available();
        if (available < n) {
            n = available;
        }
        this.m_buffer.position(this.m_buffer.position() + n);
        return n;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.read(b, off, len);
        if (bytesRead < len) {
            throw new EOFException();
        }
    }

    @Override
    public String readLine() throws IOException {
        return new BufferedReader(new InputStreamReader(this)).readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return new DataInputStream(this).readUTF();
    }

    @Override
    public long binarySearch(long floor, long ceiling, int recSize, int target) throws IOException {
        return SeekableDataInputUtilities.binarySearch((SeekableDataInput)this, floor, ceiling, recSize, target);
    }

    @Override
    public long binarySearch(long floor, long ceiling, int recSize, byte[] target) throws IOException {
        return SeekableDataInputUtilities.binarySearch((SeekableDataInput)this, floor, ceiling, recSize, target);
    }
}

