/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MiVersion
implements Comparable {
    private final byte m_majorRelease;
    private final byte m_minorRelease;
    private final byte m_revision;

    public MiVersion(byte majorRelease, byte minorRelease, byte revision) {
        this.m_majorRelease = majorRelease;
        this.m_minorRelease = minorRelease;
        this.m_revision = revision;
    }

    public String getVersionString() {
        return this.m_majorRelease + "." + this.m_minorRelease + "." + this.m_revision;
    }

    public static MiVersion read(DataInput in) throws IOException {
        byte majorRelease = in.readByte();
        byte minorRelease = in.readByte();
        byte revision = in.readByte();
        return new MiVersion(majorRelease, minorRelease, revision);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.m_majorRelease);
        out.writeByte(this.m_minorRelease);
        out.writeByte(this.m_revision);
    }

    public int compareTo(Object o) {
        MiVersion otherVersion = (MiVersion)o;
        int diff = this.m_majorRelease - otherVersion.m_majorRelease;
        if (diff == 0 && (diff = this.m_minorRelease - otherVersion.m_minorRelease) == 0) {
            diff = this.m_revision - otherVersion.m_revision;
        }
        return diff;
    }
}

