/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.coordsys.CoordSys;
import com.mapinfo.coordsys.CoordSysFactory;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.midev.coordsys.parser.LegacyMXJCoordSysParser;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.unit.Distance;
import com.mapinfo.util.DoublePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MidevConversionUtils {
    private static final String MAPINFO_COORDSYS = "mapinfo:coordsys";
    private static final String LEGACY_MAPINFO_COORDSYS = "mapinfo:";
    static Map<String, LinearUnit> UNIT_MAP;
    static Map<LinearUnit, String> ABBR_MAP;

    private MidevConversionUtils() {
    }

    public static LinearUnit getLinearUnit(String name) {
        if (name == null) {
            return LinearUnit.METER;
        }
        if (UNIT_MAP.containsKey(name)) {
            return UNIT_MAP.get(name);
        }
        return LinearUnit.valueOf((String)name);
    }

    public static LinearUnit getLinearUnitFromAbbreviation(String name) {
        if (name == null) {
            return null;
        }
        return UNIT_MAP.get(name.toLowerCase());
    }

    public static String getCommonAbbreviation(LinearUnit unit) {
        return ABBR_MAP.get(unit);
    }

    public static String getSRSname(com.mapinfo.midev.coordsys.CoordSys csys) {
        if (csys == null) {
            return null;
        }
        return CoordSysUtilities.getSRSName((com.mapinfo.midev.coordsys.CoordSys)csys);
    }

    public static Distance convertToDistance(Length length) {
        if (length == null) {
            return null;
        }
        return new Distance(length.getValue(), MidevConversionUtils.convertToOldUnit(length.getUnit()));
    }

    public static Length convertToLength(Distance distance) {
        if (distance == null) {
            return null;
        }
        return new Length(distance.getScalarValue(), MidevConversionUtils.convertToNewUnit(distance.getLinearUnit()));
    }

    protected static com.mapinfo.unit.LinearUnit convertToOldUnit(LinearUnit unit) {
        if (unit.equals((Object)LinearUnit.METER)) {
            return com.mapinfo.unit.LinearUnit.meter;
        }
        if (unit.equals((Object)LinearUnit.FOOT)) {
            return com.mapinfo.unit.LinearUnit.foot;
        }
        if (unit.equals((Object)LinearUnit.INCH)) {
            return com.mapinfo.unit.LinearUnit.inch;
        }
        if (unit.equals((Object)LinearUnit.YARD)) {
            return com.mapinfo.unit.LinearUnit.yard;
        }
        if (unit.equals((Object)LinearUnit.MILE)) {
            return com.mapinfo.unit.LinearUnit.mile;
        }
        if (unit.equals((Object)LinearUnit.KILOMETER)) {
            return com.mapinfo.unit.LinearUnit.kilometer;
        }
        if (unit.equals((Object)LinearUnit.MILLIMETER)) {
            return com.mapinfo.unit.LinearUnit.millimeter;
        }
        if (unit.equals((Object)LinearUnit.CENTIMETER)) {
            return com.mapinfo.unit.LinearUnit.centimeter;
        }
        return null;
    }

    protected static LinearUnit convertToNewUnit(com.mapinfo.unit.LinearUnit unit) {
        if (unit.equivalent(com.mapinfo.unit.LinearUnit.meter)) {
            return LinearUnit.METER;
        }
        if (unit.equivalent(com.mapinfo.unit.LinearUnit.foot)) {
            return LinearUnit.FOOT;
        }
        if (unit.equivalent(com.mapinfo.unit.LinearUnit.inch)) {
            return LinearUnit.INCH;
        }
        if (unit.equivalent(com.mapinfo.unit.LinearUnit.yard)) {
            return LinearUnit.YARD;
        }
        if (unit.equivalent(com.mapinfo.unit.LinearUnit.mile)) {
            return LinearUnit.MILE;
        }
        if (unit.equivalent(com.mapinfo.unit.LinearUnit.kilometer)) {
            return LinearUnit.KILOMETER;
        }
        if (unit.equivalent(com.mapinfo.unit.LinearUnit.millimeter)) {
            return LinearUnit.MILLIMETER;
        }
        if (unit.equivalent(com.mapinfo.unit.LinearUnit.centimeter)) {
            return LinearUnit.CENTIMETER;
        }
        return null;
    }

    public static ArrayList<DirectPosition> getPoints(IMultiCurve geom, com.mapinfo.midev.coordsys.CoordSys sourceCoordSys) {
        ArrayList<DirectPosition> pointsArray = new ArrayList<DirectPosition>();
        if (geom != null) {
            for (ICurve curve : geom) {
                for (ICurveSegment seg : curve) {
                    IDirectPositionList list = seg.getControlPoints();
                    IDirectPositionIterator dpIt = list.getDirectPositionIterator();
                    while (dpIt.hasNext()) {
                        DirectPosition pt = dpIt.nextDirectPosition(new DirectPosition());
                        if (sourceCoordSys != null) {
                            pointsArray.add(CoordConvertor.transformPointFromWGS84(sourceCoordSys, pt));
                            continue;
                        }
                        pointsArray.add(pt);
                    }
                }
            }
        }
        return pointsArray;
    }

    public static com.mapinfo.midev.coordsys.CoordSys getCoordSysFromLegacyString(String unknownCoordSys) throws IllegalArgumentException {
        if (unknownCoordSys != null && unknownCoordSys.toLowerCase().startsWith(LEGACY_MAPINFO_COORDSYS)) {
            String[] parts = unknownCoordSys.split(":");
            Code code = new Code(parts[0], parts[1]);
            String s1 = LegacyMXJCoordSysParser.getMapBasic((Code)code);
            StringBuilder sb = new StringBuilder("mapinfo:coordsys " + s1);
            return com.mapinfo.midev.coordsys.factory.CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(sb.toString());
        }
        return com.mapinfo.midev.coordsys.factory.CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(unknownCoordSys);
    }

    public static CoordSys getLegacyCoordSys(com.mapinfo.midev.coordsys.CoordSys coordSys) {
        String modifiedName;
        CoordSys legacy;
        if (coordSys == null) {
            return null;
        }
        String unknownCoordSys = CoordSysUtilities.getSRSName((com.mapinfo.midev.coordsys.CoordSys)coordSys);
        if (unknownCoordSys != null && unknownCoordSys.toLowerCase().startsWith(MAPINFO_COORDSYS) && (legacy = CoordSysFactory.createCoordSys((String)(modifiedName = LEGACY_MAPINFO_COORDSYS + unknownCoordSys.substring(MAPINFO_COORDSYS.length())))) != null) {
            return legacy;
        }
        return CoordSysFactory.createCoordSys((String)unknownCoordSys);
    }

    public static DirectPosition convertToDirectPosition(DoublePoint point) {
        if (point == null) {
            return null;
        }
        return new DirectPosition(point.x, point.y);
    }

    static {
        HashMap<String, LinearUnit> tmpMap = new HashMap<String, LinearUnit>();
        tmpMap.put("cm", LinearUnit.CENTIMETER);
        tmpMap.put("centimeter", LinearUnit.CENTIMETER);
        tmpMap.put("centimetre", LinearUnit.CENTIMETER);
        tmpMap.put("mm", LinearUnit.MILLIMETER);
        tmpMap.put("millimeter", LinearUnit.MILLIMETER);
        tmpMap.put("millimetre", LinearUnit.MILLIMETER);
        tmpMap.put("m", LinearUnit.METER);
        tmpMap.put("meter", LinearUnit.METER);
        tmpMap.put("metre", LinearUnit.METER);
        tmpMap.put("in", LinearUnit.INCH);
        tmpMap.put("inch", LinearUnit.INCH);
        tmpMap.put("ft", LinearUnit.FOOT);
        tmpMap.put("foot", LinearUnit.FOOT);
        tmpMap.put("mi", LinearUnit.MILE);
        tmpMap.put("mile", LinearUnit.MILE);
        tmpMap.put("nmi", LinearUnit.NAUTICAL_MILE);
        tmpMap.put("nautical mile", LinearUnit.NAUTICAL_MILE);
        tmpMap.put("survey ft", LinearUnit.SURVEY_FOOT);
        tmpMap.put("US Survey foot", LinearUnit.SURVEY_FOOT);
        tmpMap.put("ch", LinearUnit.CHAIN);
        tmpMap.put("chain", LinearUnit.CHAIN);
        tmpMap.put("li", LinearUnit.LINK);
        tmpMap.put("link", LinearUnit.LINK);
        tmpMap.put("rd", LinearUnit.ROD);
        tmpMap.put("rod", LinearUnit.ROD);
        tmpMap.put("yd", LinearUnit.YARD);
        tmpMap.put("yard", LinearUnit.YARD);
        tmpMap.put("km", LinearUnit.KILOMETER);
        tmpMap.put("kilometer", LinearUnit.KILOMETER);
        tmpMap.put("kilometre", LinearUnit.KILOMETER);
        UNIT_MAP = Collections.unmodifiableMap(tmpMap);
        HashMap<LinearUnit, String> tmp = new HashMap<LinearUnit, String>();
        tmp.put(LinearUnit.CENTIMETER, "cm");
        tmp.put(LinearUnit.MILLIMETER, "mm");
        tmp.put(LinearUnit.METER, "m");
        tmp.put(LinearUnit.INCH, "in");
        tmp.put(LinearUnit.FOOT, "ft");
        tmp.put(LinearUnit.MILE, "mi");
        tmp.put(LinearUnit.NAUTICAL_MILE, "nmi");
        tmp.put(LinearUnit.SURVEY_FOOT, "survey ft");
        tmp.put(LinearUnit.CHAIN, "ch");
        tmp.put(LinearUnit.LINK, "li");
        tmp.put(LinearUnit.ROD, "rd");
        tmp.put(LinearUnit.YARD, "yd");
        tmp.put(LinearUnit.KILOMETER, "km");
        ABBR_MAP = Collections.unmodifiableMap(tmp);
    }
}

