/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class NIOOutputStream
extends OutputStream
implements DataOutput {
    private static final int BUFFER_SIZE = 2048;
    private RandomAccessFile m_readWriteStream;
    private FileOutputStream m_outputOnlyStream;
    private FileChannel m_channel;
    private ByteBuffer m_buffer;
    private long m_position;

    public NIOOutputStream(File file) throws IOException {
        this(file, false);
    }

    protected NIOOutputStream(File file, boolean bReadWrite) throws IOException {
        if (bReadWrite) {
            this.m_readWriteStream = new RandomAccessFile(file, "rw");
            this.m_channel = this.m_readWriteStream.getChannel();
        } else {
            this.m_outputOnlyStream = new FileOutputStream(file);
            this.m_channel = this.m_outputOnlyStream.getChannel();
        }
        this.m_buffer = ByteBuffer.allocate(2048);
        this.m_position = 0L;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_channel.close();
        if (this.m_readWriteStream != null) {
            this.m_readWriteStream.close();
            this.m_readWriteStream = null;
        }
        if (this.m_outputOnlyStream != null) {
            this.m_outputOnlyStream.close();
            this.m_outputOnlyStream = null;
        }
        this.m_buffer.clear();
        this.m_channel = null;
        this.m_buffer = null;
    }

    @Override
    public void flush() throws IOException {
        this.write();
        this.m_channel.force(true);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.m_buffer.remaining() == 0) {
            this.write();
        }
        this.m_buffer.put((byte)b);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        while (length > this.m_buffer.remaining()) {
            int remaining = this.m_buffer.remaining();
            this.m_buffer.put(bytes, offset, remaining);
            offset += remaining;
            length -= remaining;
            this.write();
        }
        this.m_buffer.put(bytes, offset, length);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeChar(int v) throws IOException {
        byte[] bytes = new byte[]{(byte)(v >> 8), (byte)(v & 0xFF)};
        this.write(bytes, 0, 2);
    }

    @Override
    public void writeChars(String s) throws IOException {
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i * 2] = (byte)(chars[i] >> 8);
            bytes[i * 2 + 1] = (byte)(0xFF & chars[i]);
        }
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeInt(int v) throws IOException {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)(0xFF & v >> 24 - i * 8);
        }
        this.write(bytes, 0, 4);
    }

    @Override
    public void writeLong(long l) throws IOException {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & l >> 56 - i * 8);
        }
        this.write(bytes, 0, 8);
    }

    @Override
    public void writeShort(int v) throws IOException {
        byte[] bytes = new byte[]{(byte)(0xFF & v >> 8), (byte)(0xFF & v)};
        this.write(bytes, 0, 2);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        DataOutputStream stream = new DataOutputStream(this);
        stream.writeUTF(s);
    }

    protected FileChannel getChannel() {
        return this.m_channel;
    }

    protected ByteBuffer getBuffer() {
        return this.m_buffer;
    }

    protected long getPosition() {
        return this.m_position;
    }

    protected void setPosition(long position) {
        this.m_position = position;
    }

    protected void write() throws IOException {
        ByteBuffer buffer;
        if (this.m_buffer.remaining() != 0) {
            int newLimit = this.m_buffer.position();
            this.m_buffer.position(0);
            buffer = this.m_buffer.slice();
            buffer.limit(newLimit);
        } else {
            buffer = this.m_buffer;
        }
        this.m_channel.position(this.m_position);
        buffer.position(0);
        this.m_channel.write(buffer);
        this.m_buffer.clear();
        this.m_position = this.m_channel.position();
    }
}

