/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import com.mapinfo.mapmarker.utils.RandomAccessStreamImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

public class RandomAccessDataStream
extends RandomAccessStreamImpl
implements IRandomDataInputOutputStream {
    public RandomAccessDataStream(File file) throws IOException {
        super(file);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeChar(int v) throws IOException {
        byte[] bytes = new byte[]{(byte)(v >> 8), (byte)(v & 0xFF)};
        this.write(bytes, 0, 2);
    }

    @Override
    public char readChar() throws IOException {
        byte[] bytes = new byte[2];
        this.readFully(bytes, 0, 2);
        return (char)(bytes[0] << 8 | bytes[1] & 0xFF);
    }

    @Override
    public void writeChars(String s) throws IOException {
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i * 2] = (byte)(chars[i] >> 8);
            bytes[i * 2 + 1] = (byte)(0xFF & chars[i]);
        }
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void writeInt(int v) throws IOException {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)(0xFF & v >> 24 - i * 8);
        }
        this.write(bytes, 0, 4);
    }

    @Override
    public int readInt() throws IOException {
        byte[] bytes = new byte[4];
        this.readFully(bytes, 0, 4);
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value |= (bytes[i] & 0xFF) << 24 - i * 8;
        }
        return value;
    }

    @Override
    public void writeLong(long l) throws IOException {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & l >> 56 - i * 8);
        }
        this.write(bytes, 0, 8);
    }

    @Override
    public long readLong() throws IOException {
        byte[] bytes = new byte[8];
        this.readFully(bytes, 0, 8);
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)(bytes[i] & 0xFF) << 56 - i * 8;
        }
        return value;
    }

    @Override
    public void writeShort(int v) throws IOException {
        byte[] bytes = new byte[]{(byte)(0xFF & v >> 8), (byte)(0xFF & v)};
        this.write(bytes, 0, 2);
    }

    @Override
    public short readShort() throws IOException {
        byte[] bytes = new byte[2];
        this.readFully(bytes, 0, 2);
        return (short)(bytes[0] << 8 | bytes[1] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte[] bytes = new byte[2];
        this.readFully(bytes, 0, 2);
        return (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
    }

    @Override
    public void writeUTF(String s) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(stream);
        dataStream.writeUTF(s);
        this.write(stream.toByteArray());
    }

    @Override
    public String readUTF() throws IOException {
        int len = this.readUnsignedShort();
        if (len == 0) {
            return "";
        }
        byte[] bytes = new byte[2 + len];
        this.readFully(bytes, 2, len);
        bytes[0] = (byte)(0xFF & len >> 8);
        bytes[1] = (byte)(0xFF & len);
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
        return stream.readUTF();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }
}

