/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.IRandomAccessStream;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RandomAccessNIOOutputStream
extends NIOOutputStream
implements IRandomAccessStream {
    private boolean m_bFilled;
    private int m_maxBufferPosition = 0;

    public RandomAccessNIOOutputStream(File file) throws IOException {
        super(file, true);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.getPosition() + (long)this.getBuffer().position();
    }

    @Override
    public void seek(long offset) throws IOException {
        int newPos = (int)(offset - this.getPosition());
        ByteBuffer buffer = this.getBuffer();
        int currentPos = buffer.position();
        if (this.m_bFilled && newPos >= 0 && newPos < buffer.limit()) {
            this.updateMaxBufferPosition(currentPos);
            buffer.position(newPos);
        } else if (newPos >= 0 && (newPos <= currentPos || newPos <= this.m_maxBufferPosition)) {
            this.updateMaxBufferPosition(currentPos);
            buffer.position(newPos);
        } else {
            FileChannel channel = this.getChannel();
            this.write();
            channel.position(offset);
            channel.read(buffer);
            this.m_bFilled = true;
            buffer.position(0);
            this.setPosition(offset);
        }
    }

    @Override
    public final long length() throws IOException {
        long channelLength = this.getChannel().size();
        long position = this.getPosition();
        if (position + (long)this.getBuffer().limit() > channelLength) {
            int currentPos = this.getBuffer().position();
            int currentMax = this.m_maxBufferPosition > currentPos ? this.m_maxBufferPosition : currentPos;
            long internalSize = position + (long)currentMax;
            return internalSize > channelLength ? internalSize : channelLength;
        }
        return channelLength;
    }

    private void updateMaxBufferPosition(int newMax) {
        if (newMax > this.m_maxBufferPosition) {
            this.m_maxBufferPosition = newMax;
        }
    }

    @Override
    protected void write() throws IOException {
        if (this.m_maxBufferPosition > this.getBuffer().position()) {
            this.getBuffer().position(this.m_maxBufferPosition);
        }
        super.write();
        this.m_maxBufferPosition = 0;
    }
}

