/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ReadOnlyNIODataAccess
implements DataInput {
    private FileInputStream m_in;
    private FileChannel m_fc;
    private ByteBuffer m_buffer;
    private final int m_bufferSize;
    private long m_fcPosition;

    public ReadOnlyNIODataAccess(File f, int bufferSize, boolean allocateDirect) throws FileNotFoundException, IOException {
        this(new FileInputStream(f), bufferSize, allocateDirect);
    }

    public ReadOnlyNIODataAccess(FileInputStream in, int bufferSize, boolean allocateDirect) throws IOException {
        this(in.getChannel(), bufferSize, allocateDirect);
        this.m_in = in;
    }

    public ReadOnlyNIODataAccess(FileChannel fc, int bufferSize, boolean allocateDirect) throws IOException {
        if (bufferSize < 8) {
            throw new IllegalArgumentException("Buffer size must be >= 8 bytes.");
        }
        this.m_fc = fc;
        this.m_buffer = allocateDirect ? ByteBuffer.allocateDirect(bufferSize) : ByteBuffer.allocate(bufferSize);
        this.m_bufferSize = bufferSize;
        this.fillBuffer(this.m_buffer);
        this.m_fcPosition = 0L;
    }

    public void close() throws IOException {
        if (this.m_in != null) {
            this.m_in.close();
            this.m_in = null;
        }
        if (this.m_fc != null) {
            this.m_fc.close();
            this.m_fc = null;
        }
        this.m_buffer = null;
    }

    public long position() throws IOException {
        return this.m_fcPosition + (long)this.m_buffer.position();
    }

    public void position(long newPosition) throws IOException {
        long positionDiff = newPosition - this.position();
        if (positionDiff == 0L) {
            return;
        }
        if (positionDiff > 0L) {
            if (positionDiff <= (long)this.m_buffer.remaining()) {
                this.m_buffer.position(this.m_buffer.position() + (int)positionDiff);
            } else {
                this.moveBuffer(newPosition);
            }
        } else if (-positionDiff <= (long)this.m_buffer.position()) {
            this.m_buffer.position(this.m_buffer.position() + (int)positionDiff);
        } else {
            this.moveBuffer(newPosition);
        }
    }

    private void moveBuffer(long newPosition) throws IOException {
        this.m_fc.position(newPosition);
        this.fillBuffer(this.m_buffer);
        this.m_fcPosition = newPosition;
    }

    private void fillBuffer(ByteBuffer buf) throws IOException {
        buf.clear();
        if (this.m_fc.read(buf) != this.m_bufferSize) {
            buf.limit(buf.position());
        }
        buf.position(0);
    }

    private void ensureBytes(int bytesToBeRead) throws IOException {
        if (this.m_buffer.remaining() < bytesToBeRead) {
            this.moveBuffer(this.position());
        }
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureBytes(1);
        return this.m_buffer.get();
    }

    @Override
    public char readChar() throws IOException {
        this.ensureBytes(2);
        return this.m_buffer.getChar();
    }

    @Override
    public double readDouble() throws IOException {
        this.ensureBytes(8);
        return this.m_buffer.getDouble();
    }

    @Override
    public float readFloat() throws IOException {
        this.ensureBytes(4);
        return this.m_buffer.getFloat();
    }

    @Override
    public int readInt() throws IOException {
        this.ensureBytes(4);
        return this.m_buffer.getInt();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.ensureBytes(1);
        return this.m_buffer.get() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.ensureBytes(2);
        return this.m_buffer.getShort() & 0xFFFF;
    }

    @Override
    public long readLong() throws IOException {
        this.ensureBytes(8);
        return this.m_buffer.getLong();
    }

    @Override
    public short readShort() throws IOException {
        this.ensureBytes(2);
        return this.m_buffer.getShort();
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.ensureBytes(1);
        return this.m_buffer.get() != 0;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (n <= this.m_buffer.remaining()) {
            this.m_buffer.position(this.m_buffer.position() + n);
        } else {
            this.moveBuffer(this.position() + (long)n);
        }
        return n;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.m_bufferSize < len) {
            ByteBuffer buf = ByteBuffer.allocate(len);
            this.m_fc.position(this.position());
            this.fillBuffer(buf);
            if (buf.limit() != buf.capacity()) {
                throw new EOFException();
            }
            buf.get(b, off, len);
            this.moveBuffer(this.m_fc.position());
        } else {
            this.ensureBytes(len);
            this.m_buffer.get(b, off, len);
        }
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }
}

