/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

class SlicedMappedByteBuffer {
    static final byte MAX_MBS_PER_SLICE = 32;
    private static final int BYTES_PER_MB = 0x100000;
    private final boolean m_bSingleSlice;
    private final MappedByteBuffer[] m_buffers;
    private final int m_length;
    private final int m_standardLength;
    private int m_position;
    private int m_markPosition = 0;
    private int m_activeSubBuffer;

    SlicedMappedByteBuffer(FileChannel fc) throws IOException {
        this(fc, 32);
    }

    SlicedMappedByteBuffer(FileChannel fc, byte maxMBsPerSlice) throws IOException {
        if (maxMBsPerSlice > 32) {
            throw new IllegalArgumentException("maxMBsPerSlice cannot exceed 32");
        }
        if (fc.size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to map files larger than 2147483647");
        }
        this.m_length = (int)fc.size();
        int maxBytesPerSlice = maxMBsPerSlice * 0x100000;
        if (this.m_length <= maxBytesPerSlice) {
            this.m_bSingleSlice = true;
            this.m_buffers = new MappedByteBuffer[1];
            this.m_buffers[0] = fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.m_length);
            if (!this.m_buffers[0].isLoaded()) {
                this.m_buffers[0].load();
            }
            this.m_standardLength = this.m_length;
        } else {
            int i;
            this.m_bSingleSlice = false;
            int sliceCount = this.m_length / maxBytesPerSlice;
            if (sliceCount * maxBytesPerSlice != this.m_length) {
                ++sliceCount;
            }
            this.m_buffers = new MappedByteBuffer[sliceCount];
            for (i = 0; i < sliceCount - 1; ++i) {
                this.m_buffers[i] = fc.map(FileChannel.MapMode.READ_ONLY, i * maxBytesPerSlice, maxBytesPerSlice);
                if (this.m_buffers[i].isLoaded()) continue;
                this.m_buffers[i].load();
            }
            this.m_buffers[i] = fc.map(FileChannel.MapMode.READ_ONLY, i * maxBytesPerSlice, this.m_length - i * maxBytesPerSlice);
            if (!this.m_buffers[i].isLoaded()) {
                this.m_buffers[i].load();
            }
            this.m_standardLength = maxBytesPerSlice;
        }
        this.m_position = 0;
        this.m_activeSubBuffer = 0;
        this.m_markPosition = 0;
    }

    private SlicedMappedByteBuffer(SlicedMappedByteBuffer source) {
        this.m_length = source.m_length;
        this.m_bSingleSlice = source.m_bSingleSlice;
        this.m_standardLength = source.m_standardLength;
        this.m_position = source.m_position;
        this.m_markPosition = source.m_markPosition;
        this.m_buffers = new MappedByteBuffer[source.m_buffers.length];
        for (int i = 0; i < source.m_buffers.length; ++i) {
            this.m_buffers[i] = (MappedByteBuffer)source.m_buffers[i].duplicate();
        }
    }

    SlicedMappedByteBuffer duplicate() {
        return new SlicedMappedByteBuffer(this);
    }

    int limit() {
        return this.m_length;
    }

    private void activatePosition() {
        if (this.m_position < this.m_length) {
            if (this.m_bSingleSlice) {
                this.getActiveBuffer().position(this.m_position);
            } else {
                this.m_activeSubBuffer = this.m_position / this.m_standardLength;
                this.getActiveBuffer().position(this.m_position - this.m_standardLength * this.m_activeSubBuffer);
            }
        }
    }

    private MappedByteBuffer getActiveBuffer() {
        return this.m_buffers[this.m_activeSubBuffer];
    }

    void position(int pos) {
        if (pos < 0 || pos > this.m_length) {
            throw new IllegalArgumentException();
        }
        this.m_position = pos;
        this.activatePosition();
    }

    int position() {
        return this.m_position;
    }

    public int remaining() {
        return this.m_length - this.m_position;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    void mark() {
        this.m_markPosition = this.position();
    }

    void reset() {
        this.position(this.m_markPosition);
    }

    byte get() {
        if (!this.hasRemaining()) {
            throw new BufferUnderflowException();
        }
        byte b = this.getActiveBuffer().get();
        ++this.m_position;
        this.activatePosition();
        return b;
    }

    void get(byte[] bytes, int offset, int length) {
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (this.getActiveBuffer().remaining() >= length) {
            this.getActiveBuffer().get(bytes, offset, length);
            this.m_position += length;
            this.activatePosition();
        } else {
            int totalRead = 0;
            int totalRemaining = length;
            while (totalRemaining > 0) {
                int toRead = this.min(totalRemaining, this.getActiveBuffer().remaining());
                this.getActiveBuffer().get(bytes, offset + totalRead, toRead);
                totalRemaining -= toRead;
                totalRead += toRead;
                this.m_position += toRead;
                this.activatePosition();
            }
        }
    }

    private int min(int i1, int i2) {
        if (i1 < i2) {
            return i1;
        }
        return i2;
    }
}

