/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtilities {
    private static Pattern pattern = Pattern.compile("(^\\p{Punct})");

    private StringUtilities() {
    }

    public static boolean isNumeric(String s) {
        return s != null && StringUtilities.isNumeric(s, 0, s.length());
    }

    public static String removePunctuationCharsFromStart(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        Matcher m = pattern.matcher(str);
        if (m.find()) {
            str = str.substring(1, str.length());
            str = StringUtilities.removePunctuationCharsFromStart(str);
        }
        return str;
    }

    public static boolean isNumeric(String s, int startIndex, int endIndex) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        if (len == 0) {
            return false;
        }
        if (startIndex < 0 || startIndex >= endIndex || endIndex > len) {
            return false;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNumeric(String s) {
        return StringUtilities.findFirstNumeric(s) >= 0;
    }

    public static int findFirstNumeric(String s) {
        if (s == null) {
            return -1;
        }
        int len = s.length();
        if (len == 0) {
            return -1;
        }
        for (int n = 0; n < len; ++n) {
            if (!Character.isDigit(s.charAt(n))) continue;
            return n;
        }
        return -1;
    }

    public static boolean isFractionalNumber(String s) {
        int index;
        if (s == null) {
            return false;
        }
        if (StringUtilities.hasNumeric(s) && (index = s.indexOf(47)) != -1) {
            if (s.indexOf(47, index + 1) != -1) {
                return false;
            }
            try {
                String n = s.substring(0, index).trim();
                String d = s.substring(index + 1).trim();
                if (StringUtilities.isNumeric(n) && StringUtilities.isNumeric(d)) {
                    int iN = Integer.parseInt(n);
                    int iD = Integer.parseInt(d);
                    if (iD == 0 || iN == 0) {
                        return false;
                    }
                    return iN / iD < 1;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static String replaceWith(String input, String strToReplace, String replaceStr) {
        if (input == null || strToReplace == null) {
            return input;
        }
        if (replaceStr == null) {
            replaceStr = "";
        }
        if (strToReplace.equals(replaceStr)) {
            return input;
        }
        StringBuffer buf = new StringBuffer(input);
        int pos = buf.toString().indexOf(strToReplace, 0);
        while (pos != -1) {
            buf = buf.replace(pos, pos + strToReplace.length(), replaceStr);
            if (pos + (replaceStr.length() + 1) < buf.toString().length()) {
                pos = buf.toString().indexOf(strToReplace, 0);
                continue;
            }
            pos = -1;
        }
        return buf.toString();
    }

    public static String trimToChars(String input, String charsToKeep) {
        if (input == null) {
            return null;
        }
        if (charsToKeep == null) {
            return input;
        }
        int len = input.length();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (charsToKeep.indexOf(c) == -1) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String trimToCharsIgnoreCase(String input, String charsToKeep) {
        if (input == null) {
            return null;
        }
        if (charsToKeep == null) {
            return input;
        }
        int len = input.length();
        StringBuffer buf = new StringBuffer(len);
        char[] inputChars = input.toUpperCase().toCharArray();
        String charsToKeepUpper = charsToKeep.toUpperCase();
        for (int i = 0; i < len; ++i) {
            char c = inputChars[i];
            if (charsToKeepUpper.indexOf(c) < 0) continue;
            buf.append(input.charAt(i));
        }
        return buf.toString();
    }

    public static String appendToPath(String path, String append) {
        return StringUtilities.appendToPath(path, append, null);
    }

    public static String appendToPath(String path, String fileBaseName, String fileExtension) {
        StringBuffer result = new StringBuffer();
        if (path != null) {
            result.append(path);
            if (!path.endsWith(File.separator)) {
                result.append(File.separatorChar);
            }
        }
        if (fileBaseName != null) {
            result.append(fileBaseName);
        }
        if (fileExtension != null && fileExtension.trim().length() != 0) {
            if (!fileExtension.startsWith(".")) {
                result.append(".");
            }
            result.append(fileExtension);
        }
        return result.toString();
    }

    public static boolean isSpecialChar(char c, char[] excludeChars) {
        if (excludeChars == null || excludeChars.length == 0) {
            return false;
        }
        Arrays.sort(excludeChars);
        int index = Arrays.binarySearch(excludeChars, c);
        return index >= 0;
    }

    public static LinkedList tokensToList(StringTokenizer tokens) {
        if (tokens == null) {
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        while (tokens.hasMoreTokens()) {
            list.add(tokens.nextToken());
        }
        return list;
    }

    public static String toProperCase(String input, String delimiters) {
        if (input == null) {
            return null;
        }
        String output = "";
        input = input.toLowerCase();
        StringTokenizer tokenizer = new StringTokenizer(input, delimiters);
        int pos = 0;
        while (tokenizer.hasMoreElements()) {
            char ch;
            String temp = tokenizer.nextToken();
            if (temp == null) continue;
            temp = temp.substring(0, 1).toUpperCase() + temp.substring(1);
            for (pos = output.length() + temp.length(); pos < input.length() && (ch = input.charAt(pos)) != '\u0000' && StringUtilities.isSpecialChar(ch, delimiters.toCharArray()); ++pos) {
                temp = temp + ch;
            }
            output = output + temp;
        }
        return output;
    }

    public static String toProperCase(String input) {
        return StringUtilities.toProperCase(input, " .-\t\n\r\f");
    }

    public static String intToLeadingZeroString(int numDigits, int number) {
        if (number < 0) {
            return null;
        }
        char[] digits = null;
        if (numDigits == 5 && number < 100000) {
            digits = new char[]{number > 9999 ? (char)(48 + number / 10000 % 10) : (char)'0', number > 999 ? (char)(48 + number / 1000 % 10) : (char)'0', number > 99 ? (char)(48 + number / 100 % 10) : (char)'0', number > 9 ? (char)(48 + number / 10 % 10) : (char)'0', (char)(48 + number % 10)};
            return new String(digits);
        }
        if (numDigits > 0) {
            digits = new char[numDigits];
            for (int i = 0; i < numDigits; ++i) {
                int idx = numDigits - i - 1;
                if (number == 0) {
                    digits[idx] = 48;
                    continue;
                }
                int digit = number % 10;
                digits[idx] = (char)(48 + digit);
                number /= 10;
            }
        }
        if (number == 0) {
            if (digits != null) {
                return new String(digits);
            }
            return "0";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(number);
        if (digits != null) {
            buf.append(digits);
        }
        return buf.toString();
    }

    public static String stripString(String instr, String charsToIgnore) {
        char[] stringChars = instr.toCharArray();
        StringBuffer str = new StringBuffer(stringChars.length);
        for (int i = 0; i < stringChars.length; ++i) {
            char c = stringChars[i];
            if (charsToIgnore.indexOf(c) != -1) continue;
            str.append(c);
        }
        return str.toString();
    }

    public static String displayBytesAsString(byte[] bArray, boolean bHex, int len) {
        StringBuffer ans = new StringBuffer();
        block5: for (int i = 0; i < len; ++i) {
            String tmp = bHex ? Integer.toHexString(bArray[i]) : Integer.toBinaryString(bArray[i]);
            switch (tmp.length()) {
                case 2: {
                    ans.append(tmp);
                    continue block5;
                }
                case 0: {
                    ans.append("00");
                    continue block5;
                }
                case 1: {
                    ans.append('0');
                    ans.append(tmp);
                    continue block5;
                }
                default: {
                    ans.append(tmp.charAt(tmp.length() - 2));
                    ans.append(tmp.charAt(tmp.length() - 1));
                }
            }
        }
        return ans.toString();
    }

    public static boolean equalStrings(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null ^ str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean equalStringsIgnoreCase(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null ^ str2 == null) {
            return false;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String removeCharsFromBack(String strVal) {
        int index;
        if (strVal == null || strVal.length() == 0) {
            return strVal;
        }
        for (index = strVal.length() - 1; index >= 0 && Character.isLetter(strVal.charAt(index)); --index) {
        }
        if (index < 0) {
            return null;
        }
        if (++index == strVal.length()) {
            return strVal;
        }
        return strVal.substring(0, index);
    }

    public static String blankIfNull(String s) {
        return s == null ? "" : s;
    }

    public static String replaceFirstOccurenceWith(String input, String strToReplace, String replaceStr) {
        if (input == null || strToReplace == null) {
            return input;
        }
        if (replaceStr == null) {
            replaceStr = "";
        }
        if (strToReplace.equals(replaceStr)) {
            return input;
        }
        StringBuffer buf = new StringBuffer(input);
        int pos = buf.toString().indexOf(strToReplace, 0);
        buf = buf.replace(pos, pos + strToReplace.length(), replaceStr);
        return buf.toString();
    }
}

