/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import com.mapinfo.mapmarker.utils.TaggedToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class TaggedTokenList {
    private List m_list = new ArrayList(0);

    public TaggedTokenList() {
    }

    public TaggedTokenList(StringTokenizer tokens) {
        if (tokens == null) {
            return;
        }
        while (tokens.hasMoreTokens()) {
            this.m_list.add(new TaggedToken(tokens.nextToken()));
        }
    }

    public TaggedTokenList(String[] tokens) {
        if (tokens == null) {
            return;
        }
        for (int i = 0; i < tokens.length; ++i) {
            this.m_list.add(new TaggedToken(tokens[i]));
        }
    }

    private TaggedTokenList(List<TaggedToken> tokens) {
        this.m_list = tokens;
    }

    public TaggedToken get(int i) {
        return (TaggedToken)this.m_list.get(i);
    }

    public int size() {
        return this.m_list.size();
    }

    public String getValue(int i) {
        return ((TaggedToken)this.m_list.get(i)).getValue();
    }

    public String getTag(int i) {
        return ((TaggedToken)this.m_list.get(i)).getTag();
    }

    public void setTag(int i, String tag) {
        ((TaggedToken)this.m_list.get(i)).setTag(tag);
    }

    public boolean isTagged(int i) {
        return ((TaggedToken)this.m_list.get(i)).isTagged();
    }

    public String getTaggedTokenString(String tag) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_list.size(); ++i) {
            TaggedToken token = (TaggedToken)this.m_list.get(i);
            if (!token.isTagged() || !token.getTag().equals(tag)) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(token.getValue());
        }
        return sb.toString();
    }

    public List<String> getTaggedTokens(String tag) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.m_list.size(); ++i) {
            TaggedToken token = (TaggedToken)this.m_list.get(i);
            if (!token.isTagged() || !token.getTag().equals(tag)) continue;
            list.add(token.getValue());
        }
        return list;
    }

    public int indexOfFirstUntaggedToken() {
        return this.indexOfTag(null, 0);
    }

    public int indexOfTag(String tag) {
        return this.indexOfTag(tag, 0);
    }

    public int indexOfTag(String searchTag, int startPosition) {
        for (int i = startPosition; i < this.m_list.size(); ++i) {
            String tag = ((TaggedToken)this.m_list.get(i)).getTag();
            if (!(tag == null ? searchTag == null : tag.equals(searchTag))) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.m_list.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String valuesAsString() {
        StringBuilder sb = new StringBuilder();
        int lastIdx = this.m_list.size() - 1;
        for (int i = 0; i < this.m_list.size(); ++i) {
            TaggedToken token = (TaggedToken)this.m_list.get(i);
            sb.append(token.getValue());
            if (i == lastIdx) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public TaggedTokenList subList(int fromIdx, int toIdx) {
        List sublist = this.m_list.subList(fromIdx, toIdx);
        ArrayList<TaggedToken> newList = new ArrayList<TaggedToken>(sublist.size());
        for (TaggedToken token : sublist) {
            newList.add(new TaggedToken(token));
        }
        return new TaggedTokenList(newList);
    }
}

