/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils.geometry;

import com.mapinfo.mapmarker.utils.geometry.SplitSegment;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SegmentGeometryUtils {
    public static boolean intersects(List segment, DirectPosition pnt) {
        Iterator segmentIterator = segment.iterator();
        if (!segmentIterator.hasNext()) {
            return false;
        }
        DirectPosition pnt1 = (DirectPosition)segmentIterator.next();
        while (segmentIterator.hasNext()) {
            DirectPosition pnt2 = (DirectPosition)segmentIterator.next();
            if (SegmentGeometryUtils.tryTriplet(pnt1, pnt2, pnt)) {
                return true;
            }
            pnt1 = pnt2;
        }
        return false;
    }

    public static SplitSegment split(List segment, DirectPosition pnt) {
        DirectPosition pnt1;
        Iterator segmentIterator = segment.iterator();
        int firstSplitPoint = -1;
        double minHeight = Double.MAX_VALUE;
        if (segmentIterator.hasNext()) {
            pnt1 = (DirectPosition)segmentIterator.next();
            int currentFirstPoint = 0;
            while (segmentIterator.hasNext()) {
                DirectPosition pnt2 = (DirectPosition)segmentIterator.next();
                if (SegmentGeometryUtils.tryTriplet(pnt1, pnt2, pnt)) {
                    double c;
                    double b;
                    double a = SegmentGeometryUtils.computeDistance(pnt1, pnt);
                    double h = SegmentGeometryUtils.computeHeight(a, b = SegmentGeometryUtils.computeDistance(pnt, pnt2), c = SegmentGeometryUtils.computeDistance(pnt2, pnt1));
                    if (h < minHeight) {
                        minHeight = h;
                        firstSplitPoint = currentFirstPoint;
                    } else if (Double.isNaN(h) && SegmentGeometryUtils.isColinear(pnt1, pnt2, pnt)) {
                        minHeight = -1.0;
                        firstSplitPoint = currentFirstPoint;
                        break;
                    }
                }
                pnt1 = pnt2;
                ++currentFirstPoint;
            }
        }
        ArrayList segment1 = null;
        ArrayList<Object> segment2 = null;
        if (firstSplitPoint >= 0) {
            segment1 = new ArrayList();
            segment2 = new ArrayList<Object>();
            segmentIterator = segment.iterator();
            int currentFirstPoint = 0;
            while (segmentIterator.hasNext()) {
                if (currentFirstPoint < firstSplitPoint) {
                    segment1.add(segmentIterator.next());
                    ++currentFirstPoint;
                    continue;
                }
                if (currentFirstPoint == firstSplitPoint) {
                    pnt1 = (DirectPosition)segmentIterator.next();
                    segment1.add(pnt1);
                    DirectPosition pnt2 = (DirectPosition)segmentIterator.next();
                    DirectPosition splitPoint = minHeight <= 0.0 ? pnt : SegmentGeometryUtils.findSplitPoint(pnt1, pnt2, pnt);
                    segment2.add(splitPoint);
                    if (!splitPoint.equals((Object)pnt1)) {
                        segment1.add(splitPoint);
                    }
                    if (!splitPoint.equals((Object)pnt2)) {
                        segment2.add(pnt2);
                    }
                    currentFirstPoint += 2;
                    continue;
                }
                segment2.add(segmentIterator.next());
            }
        }
        return new SplitSegment(segment1, segment2);
    }

    public static void applyCornerOffset(List segment, Length offset, boolean bStart, boolean bEnd) {
        boolean bAddLast;
        double endOffset;
        if (segment == null || segment.size() <= 1) {
            return;
        }
        if (!bStart && !bEnd) {
            return;
        }
        if (offset == null || offset.getValue() == 0.0) {
            return;
        }
        double offsetDegrees = SegmentGeometryUtils.convertToDegrees(offset);
        double segmentLengthDegrees = 0.0;
        Iterator segmentIterator = segment.iterator();
        DirectPosition pnt1 = (DirectPosition)segmentIterator.next();
        DirectPosition pnt2 = null;
        while (segmentIterator.hasNext()) {
            pnt2 = (DirectPosition)segmentIterator.next();
            segmentLengthDegrees += SegmentGeometryUtils.computeDistance(pnt1, pnt2);
            pnt1 = pnt2;
        }
        if (segmentLengthDegrees <= offsetDegrees) {
            return;
        }
        double startOffset = bStart ? offsetDegrees : 0.0;
        double d = endOffset = bEnd ? segmentLengthDegrees - offsetDegrees : segmentLengthDegrees;
        if (startOffset >= endOffset) {
            return;
        }
        ArrayList<DirectPosition> newSegment = new ArrayList<DirectPosition>();
        segmentIterator = segment.iterator();
        pnt1 = (DirectPosition)segmentIterator.next();
        double partialLength = 0.0;
        boolean bl = bAddLast = !bEnd;
        while (segmentIterator.hasNext()) {
            pnt2 = (DirectPosition)segmentIterator.next();
            double subLength = SegmentGeometryUtils.computeDistance(pnt1, pnt2);
            if (bStart) {
                if (partialLength + subLength < startOffset) {
                    pnt1 = pnt2;
                    partialLength += subLength;
                    continue;
                }
                double startLeftOver = startOffset - partialLength;
                DirectPosition newStart = SegmentGeometryUtils.computeOffsetPoint(pnt1, pnt2, startLeftOver / subLength);
                newSegment.add(newStart);
                bStart = false;
                pnt1 = pnt2;
                partialLength += subLength;
                continue;
            }
            newSegment.add(pnt1);
            if (bEnd) {
                if (partialLength + subLength < endOffset) {
                    newSegment.add(pnt2);
                    pnt1 = pnt2;
                    partialLength += subLength;
                    continue;
                }
                double endLeftOver = endOffset - partialLength;
                DirectPosition newEnd = SegmentGeometryUtils.computeOffsetPoint(pnt1, pnt2, endLeftOver / subLength);
                newSegment.add(newEnd);
                break;
            }
            partialLength += subLength;
            pnt1 = pnt2;
        }
        if (bAddLast) {
            newSegment.add(pnt2);
        }
        segment.clear();
        segment.addAll(newSegment);
    }

    private static boolean tryTriplet(DirectPosition pnt1, DirectPosition pnt2, DirectPosition target) {
        if (pnt1.equals((Object)pnt2)) {
            return false;
        }
        if (SegmentGeometryUtils.intersects(pnt1, pnt2, target)) {
            if (Double.isNaN(SegmentGeometryUtils.computeHeight(SegmentGeometryUtils.computeDistance(pnt1, target), SegmentGeometryUtils.computeDistance(target, pnt2), SegmentGeometryUtils.computeDistance(pnt2, pnt1)))) {
                return SegmentGeometryUtils.isColinear(pnt1, pnt2, target);
            }
            return true;
        }
        return false;
    }

    private static double computeSlope(DirectPosition pnt1, DirectPosition pnt2) {
        double deltaX = pnt1.getX() - pnt2.getX();
        double deltaY = pnt1.getY() - pnt2.getY();
        if (deltaX == 0.0) {
            return Double.NaN;
        }
        return deltaY / deltaX;
    }

    private static boolean intersects(DirectPosition pnt1, DirectPosition pnt2, DirectPosition target) {
        double c;
        double c2;
        double b;
        double b2;
        double slope1 = SegmentGeometryUtils.computeSlope(pnt1, target);
        double slope2 = SegmentGeometryUtils.computeSlope(pnt2, target);
        double segmentSlope = SegmentGeometryUtils.computeSlope(pnt1, pnt2);
        if (SegmentGeometryUtils.inverseSlopes(segmentSlope, slope1) || SegmentGeometryUtils.inverseSlopes(segmentSlope, slope2)) {
            return true;
        }
        double a = SegmentGeometryUtils.computeDistance(pnt1, target);
        double a2 = a * a;
        if (SegmentGeometryUtils.isObtuse(a2, b2 = (b = SegmentGeometryUtils.computeDistance(target, pnt2)) * b, c2 = (c = SegmentGeometryUtils.computeDistance(pnt2, pnt1)) * c)) {
            return SegmentGeometryUtils.checkSides(a, b, c);
        }
        return true;
    }

    private static double computeDistance(DirectPosition pnt1, DirectPosition pnt2) {
        Length length = MeasurementUtilities.sphericalLength((DirectPosition)pnt1, (DirectPosition)pnt2, (CoordSys)CoordSysConstants.longLatWGS84);
        return length.getValue(LinearUnit.METER);
    }

    private static boolean isObtuse(double a2, double b2, double c2) {
        if (a2 + b2 < c2) {
            return true;
        }
        if (b2 + c2 < a2) {
            return true;
        }
        return c2 + a2 < b2;
    }

    private static boolean checkSides(double a, double b, double c) {
        return c > a && c > b;
    }

    private static double computeHeight(double a, double b, double c) {
        double p = (a + b + c) / 2.0;
        double h = Math.sqrt(4.0 * p * (p - a) * (p - b) * (p - c) / (c * c));
        return h;
    }

    private static boolean isColinear(DirectPosition pnt1, DirectPosition pnt2, DirectPosition target) {
        double mSub;
        double mLine = SegmentGeometryUtils.computeSlope(pnt1, pnt2);
        return mLine == (mSub = SegmentGeometryUtils.computeSlope(pnt1, target)) || Double.isNaN(mLine) && Double.isNaN(mSub);
    }

    private static DirectPosition findSplitPoint(DirectPosition pnt1, DirectPosition pnt2, DirectPosition target) {
        double d;
        double c;
        double b;
        double m = SegmentGeometryUtils.computeSlope(pnt1, pnt2);
        double m1 = SegmentGeometryUtils.computeSlope(pnt1, target);
        double m2 = SegmentGeometryUtils.computeSlope(pnt2, target);
        if (SegmentGeometryUtils.inverseSlopes(m, m1)) {
            return pnt1;
        }
        if (SegmentGeometryUtils.inverseSlopes(m, m2)) {
            return pnt2;
        }
        double a = SegmentGeometryUtils.computeDistance(pnt1, target);
        double h = SegmentGeometryUtils.computeHeight(a, b = SegmentGeometryUtils.computeDistance(target, pnt2), c = SegmentGeometryUtils.computeDistance(pnt2, pnt1));
        if (h > a) {
            double e = Math.sqrt(b * b - h * h);
            d = c - e;
        } else {
            d = Math.sqrt(a * a - h * h);
        }
        return SegmentGeometryUtils.computeOffsetPoint(pnt1, pnt2, d / c);
    }

    private static boolean inverseSlopes(double m1, double m2) {
        if (m1 == 0.0) {
            return Double.isNaN(m2);
        }
        if (Double.isNaN(m1)) {
            return m2 == 0.0;
        }
        if (m2 == 0.0 || Double.isNaN(m2)) {
            return false;
        }
        return Math.abs(m1 * m2) == 1.0;
    }

    private static DirectPosition computeOffsetPoint(DirectPosition start, DirectPosition end, double percentage) {
        double x = start.getX() + percentage * (end.getX() - start.getX());
        double y = start.getY() + percentage * (end.getY() - start.getY());
        return new DirectPosition(x, y);
    }

    private static double convertToDegrees(Length length) {
        double valueInMeters = length.getValue(LinearUnit.METER);
        double valueInRadians = valueInMeters / 6370997.0;
        return AngularUnit.convert((double)valueInRadians, (AngularUnit)AngularUnit.RADIAN, (AngularUnit)AngularUnit.DEGREE);
    }
}

