/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.geometry.MValue;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public final class DirectPosition
implements Serializable {
    private double m_x;
    private double m_y;
    private double m_z;
    private MValue m_m;

    public DirectPosition() {
        this(0.0, 0.0, Double.NaN, null);
    }

    public DirectPosition(double x, double y) {
        this(x, y, Double.NaN, null);
    }

    @PrivateAPI
    public DirectPosition(double x, double y, double z) {
        this(x, y, z, null);
    }

    @PrivateAPI
    public DirectPosition(double x, double y, MValue m) {
        this(x, y, Double.NaN, m);
    }

    @PrivateAPI
    public DirectPosition(double x, double y, double z, MValue m) {
        this.m_x = x;
        this.m_y = y;
        this.m_z = z;
        this.m_m = m;
    }

    public DirectPosition(DirectPosition dp) {
        this(dp.m_x, dp.m_y, dp.m_z, dp.m_m);
    }

    public DirectPosition getCopy() {
        return new DirectPosition(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DirectPosition)) {
            return false;
        }
        DirectPosition dp = (DirectPosition)obj;
        if (this == dp) {
            return true;
        }
        boolean bEqual = this.equalsXYZ(dp) && (dp.m_m == this.m_m || dp.m_m != null && dp.m_m.equals(this.m_m));
        return bEqual;
    }

    public int hashCode() {
        int hashCode = new Double(this.m_x).hashCode();
        hashCode = 31 * hashCode + new Double(this.m_y).hashCode();
        hashCode = 31 * hashCode + new Double(this.m_z).hashCode();
        hashCode = 31 * hashCode + (this.m_m == null ? 0 : this.m_m.hashCode());
        return hashCode;
    }

    @PrivateAPI
    public boolean equalsXY(DirectPosition dp) {
        return dp.m_x == this.m_x && dp.m_y == this.m_y;
    }

    @PrivateAPI
    public boolean equalsXYZ(DirectPosition dp) {
        boolean bEqual = this.equalsXY(dp) && (dp.m_z == this.m_z || Double.isNaN(dp.m_z) && Double.isNaN(this.m_z));
        return bEqual;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        buf.append(this.m_x).append(",");
        buf.append(this.m_y).append(",");
        if (!Double.isNaN(this.m_z)) {
            buf.append(this.m_z);
        }
        buf.append(",");
        if (this.m_m != null) {
            buf.append(this.m_m.toString());
        }
        buf.append(')');
        return buf.toString();
    }

    public double getX() {
        return this.m_x;
    }

    public void setX(double x) {
        this.m_x = x;
    }

    public double getY() {
        return this.m_y;
    }

    public void setY(double y) {
        this.m_y = y;
    }

    @PrivateAPI
    public double getZ() {
        return this.m_z;
    }

    @PrivateAPI
    public void setZ(double z) {
        this.m_z = z;
    }

    @PrivateAPI
    public boolean zSet() {
        return DirectPosition.zSet(this.m_z);
    }

    @PrivateAPI
    public static boolean zSet(double z) {
        return !Double.isNaN(z);
    }

    @PrivateAPI
    public MValue getM() {
        return this.m_m;
    }

    @PrivateAPI
    public boolean mSet() {
        return DirectPosition.mSet(this.m_m);
    }

    @PrivateAPI
    public static boolean mSet(MValue m) {
        return m != null;
    }

    @PrivateAPI
    public void setM(MValue m) {
        this.m_m = m;
    }

    @PrivateAPI
    public void setXY(double x, double y) {
        this.m_x = x;
        this.m_y = y;
    }

    @PrivateAPI
    public void setXYZ(double x, double y, double z) {
        this.setXY(x, y);
        this.m_z = z;
    }

    @PrivateAPI
    public void set(double x, double y, double z, MValue m) {
        this.setXYZ(x, y, z);
        this.m_m = m;
    }

    public void set(DirectPosition dp) {
        this.set(dp.m_x, dp.m_y, dp.m_z, dp.m_m);
    }

    public void offsetXY(double deltaX, double deltaY) {
        this.m_x += deltaX;
        this.m_y += deltaY;
    }
}

