/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.metadata;

import com.mapinfo.midev.metadata.UnmodifiableMetadata;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

@PublicAPI
public class Metadata
implements Serializable,
Iterable<Metadata> {
    public static final String DELIMITER = "\\";
    private final List<Metadata> m_children = new ArrayList<Metadata>();
    private Metadata m_unmodifiableMetadata;
    private String m_key = "";
    private String m_value = "";

    public Metadata() {
        this.m_key = "";
    }

    public Metadata(String key) {
        this.setKey(key);
    }

    public Metadata(String key, String value) {
        this(key);
        this.setValue(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata rhs = (Metadata)o;
        if (!this.getKey().equals(rhs.getKey())) {
            return false;
        }
        if (!this.getValue().equals(rhs.getValue())) {
            return false;
        }
        if (this.getNumberChildren() != rhs.getNumberChildren()) {
            return false;
        }
        Iterator<Metadata> myChildren = this.getMetadataIterator();
        Iterator<Metadata> rhsChildren = rhs.getMetadataIterator();
        while (myChildren.hasNext()) {
            if (myChildren.next().equals(rhsChildren.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_key.hashCode() + this.m_value.hashCode();
    }

    public String toString() {
        return "Metadata{m_children=" + this.m_children + ", m_unmodifiableMetadata=" + this.m_unmodifiableMetadata + ", m_key='" + this.m_key + '\'' + ", m_value='" + this.m_value + '\'' + '}';
    }

    public static String[] tokenizeKey(String key) {
        if (key == null || key.length() == 0) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(key, DELIMITER);
        int nTokens = tokenizer.countTokens();
        int i = 0;
        String[] strings = new String[nTokens];
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            strings[i++] = token;
        }
        return strings;
    }

    public static boolean containsDelimiter(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        for (int i = 0; i < DELIMITER.length(); ++i) {
            if (key.indexOf(DELIMITER.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWithDelimiter(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return DELIMITER.indexOf(key.charAt(0)) >= 0;
    }

    private static int analyzeKey(Metadata node, String[] componentKeys, int keyLevel, List<Metadata> path) {
        for (Metadata childNode : node) {
            if (childNode.getKey().compareToIgnoreCase(componentKeys[keyLevel]) != 0) continue;
            if (++keyLevel == componentKeys.length) {
                if (path != null) {
                    path.add(0, childNode);
                }
                return keyLevel;
            }
            int matchLevel = Metadata.analyzeKey(childNode, componentKeys, keyLevel, path);
            if (path != null) {
                path.add(0, childNode);
            }
            return matchLevel;
        }
        return keyLevel;
    }

    private static int analyzeKey(String key, String[] componentKeys, Metadata root, List<Metadata> path) {
        if (path != null) {
            path.clear();
        }
        if (componentKeys.length == 0) {
            return 0;
        }
        int matchedKeyLevel = 0;
        if (Metadata.startsWithDelimiter(key)) {
            if (root.getKey().compareToIgnoreCase(componentKeys[0]) != 0) {
                return 0;
            }
            matchedKeyLevel = componentKeys.length == 1 ? 1 : Metadata.analyzeKey(root, componentKeys, 1, path);
        } else {
            matchedKeyLevel = Metadata.analyzeKey(root, componentKeys, 0, path);
        }
        if (path != null) {
            path.add(0, root);
        }
        return matchedKeyLevel;
    }

    private static boolean analyzeKey(String key, Metadata root, List<Metadata> path) {
        String[] componentKeys;
        if (path != null) {
            path.clear();
        }
        if ((componentKeys = Metadata.tokenizeKey(key)).length == 0) {
            return false;
        }
        int matchedKeyLevel = Metadata.analyzeKey(key, componentKeys, root, path);
        return matchedKeyLevel == componentKeys.length;
    }

    private static boolean analyzeKey(String key, Metadata root) {
        return Metadata.analyzeKey(key, root, null);
    }

    public Metadata getUnmodifiableMetadata() {
        if (this.m_unmodifiableMetadata == null) {
            this.m_unmodifiableMetadata = new UnmodifiableMetadata(this);
        }
        return this.m_unmodifiableMetadata;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getValue() {
        return this.m_value;
    }

    protected Metadata getChild(int index) {
        return this.m_children.get(index);
    }

    public void setKey(String key) {
        ArgumentValidator.assertNotNullReference("key", key);
        if (Metadata.containsDelimiter(key)) {
            throw new IllegalArgumentException("Badly formed key; key cannot contain delimiter characters.");
        }
        this.m_key = key;
    }

    public void setValue(String value) {
        this.m_value = value == null || value.length() == 0 ? "" : value;
    }

    public boolean contains(String key) {
        return Metadata.analyzeKey(key, this, null);
    }

    public int getNumberChildren() {
        if (this.m_children == null) {
            return 0;
        }
        return this.m_children.size();
    }

    public Metadata get(String key) {
        ArrayList<Metadata> path = new ArrayList<Metadata>();
        boolean bFound = Metadata.analyzeKey(key, this, path);
        if (!bFound) {
            return null;
        }
        return (Metadata)path.get(path.size() - 1);
    }

    public String put(String key, String value) {
        ArgumentValidator.assertNotEmptyString("key", key);
        ArrayList<Metadata> path = new ArrayList<Metadata>();
        String[] componentKeys = Metadata.tokenizeKey(key);
        if (componentKeys.length == 0) {
            throw new IllegalArgumentException("Empty or null key supplied.");
        }
        int matchedKeyLevel = Metadata.analyzeKey(key, componentKeys, this, path);
        Metadata last = (Metadata)path.get(path.size() - 1);
        if (matchedKeyLevel == componentKeys.length) {
            String oldValue = last.getValue();
            last.setValue(value);
            return oldValue;
        }
        for (int i = matchedKeyLevel; i < componentKeys.length - 1; ++i) {
            Metadata newChild = new Metadata(componentKeys[i]);
            last.put(newChild);
            last = newChild;
        }
        last.put(new Metadata(componentKeys[componentKeys.length - 1], value));
        return null;
    }

    public void put(String key, Metadata value) {
        ArgumentValidator.assertNotEmptyString("key", key);
        ArrayList<Metadata> path = new ArrayList<Metadata>();
        String[] componentKeys = Metadata.tokenizeKey(key);
        if (componentKeys.length == 0) {
            throw new IllegalArgumentException("Empty or null key supplied.");
        }
        int matchedKeyLevel = Metadata.analyzeKey(key, componentKeys, this, path);
        Metadata last = (Metadata)path.get(path.size() - 1);
        if (matchedKeyLevel == componentKeys.length) {
            last.put(value);
        } else {
            for (int i = matchedKeyLevel; i < componentKeys.length; ++i) {
                Metadata newChild = new Metadata(componentKeys[i]);
                last.put(newChild);
                last = newChild;
            }
            last.put(value);
        }
    }

    public void put(Metadata value) {
        ArgumentValidator.assertNotNullReference("value", value);
        this.m_children.add(value);
    }

    public void putAll(Metadata metadata) {
        for (Metadata child : metadata) {
            this.put(child.getCopy());
        }
    }

    public void delete(Metadata child) {
        if (this.m_children != null) {
            this.m_children.remove(child);
        }
    }

    public void delete(String key) {
        ArrayList<Metadata> path = new ArrayList<Metadata>();
        boolean bFound = Metadata.analyzeKey(key, this, path);
        if (!bFound) {
            throw new IllegalArgumentException("Invalid or malformed key, key not found.");
        }
        if (path.size() <= 1) {
            throw new IllegalArgumentException("A metadata node cannot delete itself. Key refers to only this node.");
        }
        Metadata parent = (Metadata)path.get(path.size() - 2);
        Metadata child = (Metadata)path.get(path.size() - 1);
        parent.delete(child);
    }

    public void clear() {
        if (this.m_children != null) {
            this.m_children.clear();
        }
    }

    public Metadata getCopy() {
        Metadata copy = new Metadata(this.getKey(), this.getValue());
        if (this.m_children != null) {
            for (Metadata child : this.m_children) {
                copy.put(child.getCopy());
            }
        }
        return copy;
    }

    @Override
    public Iterator<Metadata> iterator() {
        return this.getMetadataIterator();
    }

    public Iterator<Metadata> getMetadataIterator() {
        return new MetadataIterator();
    }

    public Iterator<Map.Entry<String, String>> getDictionaryIterator() {
        return new DictionaryIterator(this, false);
    }

    public Iterator<Map.Entry<String, String>> getDictionaryIterator(boolean bAllMappings) {
        return new DictionaryIterator(this, bAllMappings);
    }

    private class MetadataIterator
    implements Iterator<Metadata> {
        private int m_current = 0;

        MetadataIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.m_current < Metadata.this.getNumberChildren();
        }

        @Override
        public Metadata next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Metadata.this.getChild(this.m_current++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DictionaryIterator
    implements Iterator<Map.Entry<String, String>> {
        private final boolean m_bIncludeEmptyValueMappings;
        private final List<MetadataNavigationEntry> m_depthFirstList;
        private int m_workingDepth;
        private boolean m_bHasNext;

        DictionaryIterator(Metadata metadata, boolean bIncludeEmptyValueMappings) {
            this.m_bIncludeEmptyValueMappings = bIncludeEmptyValueMappings;
            this.m_bHasNext = false;
            this.m_depthFirstList = new ArrayList<MetadataNavigationEntry>();
            this.m_depthFirstList.add(new MetadataNavigationEntry(metadata));
            this.m_workingDepth = 1;
            if (!this.getDoesLeafHaveValue()) {
                this.advance();
            } else {
                this.m_bHasNext = true;
            }
        }

        private void advance() {
            this.m_bHasNext = false;
            do {
                if (this.getNext()) continue;
                return;
            } while (!this.getDoesLeafHaveValue());
            this.m_bHasNext = true;
        }

        private boolean getDoesLeafHaveValue() {
            if (this.m_bIncludeEmptyValueMappings) {
                return true;
            }
            if (this.m_workingDepth > 0) {
                return this.m_depthFirstList.get(this.m_workingDepth - 1).getNode().getValue().length() > 0;
            }
            return false;
        }

        private boolean getNext() {
            do {
                MetadataNavigationEntry last = this.m_depthFirstList.get(this.m_workingDepth - 1);
                Metadata child = null;
                child = last.getNextChild();
                if (child != null) {
                    if (this.m_depthFirstList.size() == this.m_workingDepth) {
                        this.m_depthFirstList.add(new MetadataNavigationEntry(child));
                    } else {
                        this.m_depthFirstList.get(this.m_workingDepth).setNode(child);
                    }
                    ++this.m_workingDepth;
                    return true;
                }
                --this.m_workingDepth;
            } while (this.m_workingDepth > 0);
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.m_bHasNext;
        }

        @Override
        public Map.Entry<String, String> next() {
            StringBuilder key = new StringBuilder();
            key.setLength(0);
            for (int i = 0; i < this.m_workingDepth; ++i) {
                key.append(Metadata.DELIMITER);
                key.append(this.m_depthFirstList.get(i).getNode().getKey());
            }
            DictionaryEntry entry = new DictionaryEntry(key.toString(), this.m_depthFirstList.get(this.m_workingDepth - 1).getNode());
            this.advance();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MetadataNavigationEntry {
        private Metadata m_node;
        private int m_childNumber;

        MetadataNavigationEntry(Metadata node) {
            this.m_node = node;
            this.m_childNumber = -1;
        }

        Metadata getNode() {
            return this.m_node;
        }

        int getChildNumber() {
            return this.m_childNumber;
        }

        void setNode(Metadata node) {
            this.m_node = node;
            this.m_childNumber = -1;
        }

        Metadata getNextChild() {
            ++this.m_childNumber;
            if (this.m_node.getNumberChildren() <= this.m_childNumber) {
                return null;
            }
            return this.m_node.getChild(this.m_childNumber);
        }
    }

    private static class DictionaryEntry
    implements Map.Entry<String, String> {
        private final String m_key;
        private final Metadata m_metadata;

        DictionaryEntry(String key, Metadata metadata) {
            this.m_key = key;
            this.m_metadata = metadata;
        }

        @Override
        public String getKey() {
            return this.m_key;
        }

        @Override
        public String getValue() {
            return this.m_metadata.getValue();
        }

        @Override
        public String setValue(String value) {
            String oldValue = this.m_metadata.getValue();
            this.m_metadata.setValue(value);
            return oldValue;
        }
    }
}

