/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.type;

import com.mapinfo.midev.type.MIDateTimeUtils;
import com.mapinfo.midev.type.MITimespan;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;
import java.util.Date;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

@PublicAPI
public final class MIDate
implements Comparable<MIDate>,
Serializable {
    private final LocalDate m_date;

    public MIDate(int year, int month, int day) {
        try {
            this.m_date = new LocalDate(year, month, day, (Chronology)ISOChronology.getInstanceUTC());
        }
        catch (IllegalFieldValueException e) {
            throw MIDateTimeUtils.buildException(e);
        }
    }

    public MIDate(long milliSeconds) {
        this.m_date = new LocalDate(milliSeconds, (Chronology)ISOChronology.getInstanceUTC());
    }

    private MIDate(LocalDate date) {
        this.m_date = date;
    }

    public MIDate(Date date) {
        this.m_date = LocalDate.fromDateFields((Date)date);
    }

    public long getTimeInMilliSeconds() {
        return DateTimeUtils.getInstantMillis((ReadableInstant)this.m_date.toDateTimeAtStartOfDay(DateTimeZone.UTC));
    }

    public int getYear() {
        return this.m_date.getYear();
    }

    public int getMonth() {
        return this.m_date.getMonthOfYear();
    }

    public int getDay() {
        return this.m_date.getDayOfMonth();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MIDate miDate = (MIDate)o;
        return this.m_date.equals((Object)miDate.m_date);
    }

    @Override
    public int compareTo(MIDate date) {
        return this.m_date.compareTo((ReadablePartial)date.m_date);
    }

    public int hashCode() {
        return this.m_date.hashCode();
    }

    public MIDate plus(MITimespan timespan) {
        return new MIDate(this.m_date.plus((ReadablePeriod)new Period(0, 0, 0, timespan.getDays(), timespan.getHours(), timespan.getMinutes(), (int)timespan.getSeconds(), 0)));
    }

    public MIDate minus(MITimespan timespan) {
        return new MIDate(this.m_date.minus((ReadablePeriod)new Period(0, 0, 0, timespan.getDays(), timespan.getHours(), timespan.getMinutes(), (int)timespan.getSeconds(), 0)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMonth()).append('/');
        sb.append(this.getDay()).append('/');
        sb.append(this.getYear());
        return sb.toString();
    }

    @PrivateAPI
    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern((String)pattern).print((ReadablePartial)this.m_date);
    }

    @PrivateAPI
    public String toISO8601FormattedString() {
        return ISODateTimeFormat.date().print((ReadablePartial)this.m_date);
    }

    @PrivateAPI
    public static MIDate fromISO8601FormattedString(String dateString) {
        LocalDate date = ISODateTimeFormat.dateParser().parseLocalDate(dateString);
        return new MIDate(date);
    }
}

