/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.type;

import com.mapinfo.midev.type.MIDate;
import com.mapinfo.midev.type.MIDateTimeUtils;
import com.mapinfo.midev.type.MITime;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;
import java.util.Date;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

@PublicAPI
public final class MIDateTime
implements Comparable<MIDateTime>,
Serializable {
    private final LocalDateTime m_date;

    public MIDateTime(int year, int month, int day, int hour, int minute, double seconds) {
        int wholeSeconds = (int)Math.floor(seconds);
        int milliSeconds = (int)Math.round((seconds - (double)wholeSeconds) * 1000.0);
        try {
            this.m_date = new LocalDateTime(year, month, day, hour, minute, wholeSeconds, milliSeconds, (Chronology)ISOChronology.getInstanceUTC());
        }
        catch (IllegalFieldValueException e) {
            throw MIDateTimeUtils.buildException(e);
        }
    }

    public MIDateTime(MIDate date, MITime time) {
        this(date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSeconds());
    }

    public MIDateTime(long milliSeconds) {
        this.m_date = new LocalDateTime(milliSeconds, (Chronology)ISOChronology.getInstanceUTC());
    }

    @PrivateAPI
    public MIDateTime(Date timestamp) {
        this.m_date = LocalDateTime.fromDateFields((Date)timestamp);
    }

    public long getTimeInMilliSeconds() {
        return DateTimeUtils.getInstantMillis((ReadableInstant)this.m_date.toDateTime(DateTimeZone.UTC));
    }

    public int getYear() {
        return this.m_date.getYear();
    }

    public int getMonth() {
        return this.m_date.getMonthOfYear();
    }

    public int getDay() {
        return this.m_date.getDayOfMonth();
    }

    public int getHour() {
        return this.m_date.getHourOfDay();
    }

    public int getMinute() {
        return this.m_date.getMinuteOfHour();
    }

    public double getSeconds() {
        return (double)this.m_date.getSecondOfMinute() + (double)this.m_date.getMillisOfSecond() / 1000.0;
    }

    @Override
    public int compareTo(MIDateTime dateTime) {
        return this.m_date.compareTo((ReadablePartial)dateTime.m_date);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MIDateTime miDateTime = (MIDateTime)o;
        return this.m_date.equals((Object)miDateTime.m_date);
    }

    public int hashCode() {
        return this.m_date.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMonth()).append('/');
        sb.append(this.getDay()).append('/');
        sb.append(this.getYear()).append(' ');
        sb.append(this.getHour()).append(':');
        sb.append(this.getMinute()).append(':');
        sb.append(this.getSeconds());
        return sb.toString();
    }

    @PrivateAPI
    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern((String)pattern).print((ReadablePartial)this.m_date);
    }

    @PrivateAPI
    public String toISO8601FormattedString() {
        return ISODateTimeFormat.dateTime().print((ReadablePartial)this.m_date);
    }

    @PrivateAPI
    public static MIDateTime fromISO8601FormattedString(String dateTimeString) {
        LocalDateTime dateTime = ISODateTimeFormat.dateTimeParser().parseLocalDateTime(dateTimeString);
        return new MIDateTime(dateTime.toDate());
    }
}

